/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.model.WingModel;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class WingsLayer<T extends LivingEntity, Q extends EntityModel<T>>
extends LayerRenderer<T, Q> {
    private final WingModel<T> model = new WingModel();
    private final Predicate<T> predicateRender;
    private final BiFunction<T, Q, ModelRenderer> bodyPartFunction;
    private final ResourceLocation texture = new ResourceLocation("vampirism", "textures/entity/wings.png");

    public WingsLayer(IEntityRenderer<T, Q> entityRendererIn, Predicate<T> predicateRender, BiFunction<T, Q, ModelRenderer> bodyPartFunction) {
        super(entityRendererIn);
        this.predicateRender = predicateRender;
        this.bodyPartFunction = bodyPartFunction;
    }

    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.func_82150_aj() && this.predicateRender.test(entity)) {
            this.model.copyRotationFromBody(this.bodyPartFunction.apply(entity, this.func_215332_c()));
            float s = 1.0f;
            if (entity instanceof VampireBaronEntity) {
                s = ((VampireBaronEntity)entity).getEnragedProgress();
            } else if (entity instanceof PlayerEntity) {
                int ticks = VampirePlayer.getOpt((PlayerEntity)entity).map(VampirePlayer::getWingCounter).orElse(0);
                s = ticks > 20 ? (ticks > 1180 ? 1.0f - (float)(ticks - 1180) / 20.0f : 1.0f) : (float)ticks / 20.0f;
            }
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, (double)0.02f);
            stack.func_227862_a_(s, s, s);
            WingsLayer.func_229140_a_((EntityModel)this.func_215332_c(), this.model, (ResourceLocation)this.texture, (MatrixStack)stack, (IRenderTypeBuffer)buffer, (int)packedLight, entity, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.func_227865_b_();
        }
    }
}

