/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.client.model.CoffinModel;
import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.CoffinTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CoffinTESR
extends VampirismTESR<CoffinTileEntity> {
    private final int maxLidPos = 61;
    private final CoffinModel model;
    private final ResourceLocation[] textures = new ResourceLocation[DyeColor.values().length];
    private final Logger LOGGER = LogManager.getLogger();

    public CoffinTESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.model = new CoffinModel();
        for (DyeColor e : DyeColor.values()) {
            this.textures[e.func_196059_a()] = new ResourceLocation("vampirism", "textures/block/coffin/coffin_" + e.func_176610_l() + ".png");
        }
    }

    public void render(CoffinTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int i, int i1) {
        if (!tile.renderAsItem) {
            boolean occupied;
            if (!this.isHeadSafe(tile.func_145831_w(), tile.func_174877_v())) {
                return;
            }
            boolean bl = occupied = tile.func_145830_o() && CoffinBlock.isOccupied((IBlockReader)tile.func_145831_w(), tile.func_174877_v());
            if (!occupied && tile.lidPos > 0) {
                --tile.lidPos;
            } else if (occupied && tile.lidPos < 61) {
                ++tile.lidPos;
            }
        } else {
            tile.lidPos = 61;
        }
        this.model.rotateLid(this.calcLidAngle(tile.lidPos));
        int color = Math.min(tile.color.func_196059_a(), 15);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        matrixStack.func_227860_a_();
        this.adjustRotatePivotViaState(tile, matrixStack);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, 0.0, -1.0);
        IVertexBuilder vertexBuilder = iRenderTypeBuffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.textures[color]));
        this.model.func_225598_a_(matrixStack, vertexBuilder, i, i1, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    private float calcLidAngle(int pos) {
        if (pos == 61) {
            return 0.0f;
        }
        if (pos == 0) {
            return 2.3561945f;
        }
        return (float)(-Math.pow(1.02, pos) + 1.0 + 2.356194490192345);
    }

    private boolean isHeadSafe(World world, BlockPos pos) {
        try {
            return CoffinBlock.isHead((IBlockReader)world, pos);
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error("CoffinTESR", (Object)"Failed to check coffin head at %s caused by wrong blockstate. Block at that pos: %s", (Object)pos, (Object)world.func_180495_p(pos));
        }
        catch (Exception e) {
            this.LOGGER.error("CoffinTESR", (Object)e, (Object)"Failed to check coffin head at %s.", (Object)pos);
        }
        return false;
    }
}

