/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.command.arguments.SkillArgument;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SkillCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSource, ?> registerTest() {
        return SkillCommand.create(Commands.func_197057_a((String)"skill"));
    }

    public static ArgumentBuilder<CommandSource, ?> register() {
        return SkillCommand.create(Commands.func_197057_a((String)"skills"));
    }

    private static ArgumentBuilder<CommandSource, ?> create(ArgumentBuilder<CommandSource, ?> builder) {
        return builder.requires(context -> context.func_197034_c(3)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)SkillArgument.skills()).executes(context -> SkillCommand.skill((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), SkillArgument.getSkill((CommandContext<CommandSource>)context, "type"), false))).then(Commands.func_197057_a((String)"force").executes(context -> SkillCommand.skill((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), SkillArgument.getSkill((CommandContext<CommandSource>)context, "type"), true)))).then(Commands.func_197057_a((String)"disableall").executes(context -> SkillCommand.disableall((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h())));
    }

    private static int disableall(CommandSource commandSource, ServerPlayerEntity asPlayer) {
        IFactionPlayer factionPlayer;
        IFactionPlayer iFactionPlayer = factionPlayer = asPlayer.func_70089_S() ? (IFactionPlayer)FactionPlayerHandler.get((PlayerEntity)asPlayer).getCurrentFactionPlayer().orElse(null) : null;
        if (factionPlayer == null) {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.noinfaction"), false);
            return 0;
        }
        factionPlayer.getSkillHandler().resetSkills();
        return 0;
    }

    private static int skill(CommandSource commandSource, ServerPlayerEntity asPlayer, ISkill skill, boolean force) {
        IFactionPlayer factionPlayer;
        IFactionPlayer iFactionPlayer = factionPlayer = asPlayer.func_70089_S() ? (IFactionPlayer)FactionPlayerHandler.get((PlayerEntity)asPlayer).getCurrentFactionPlayer().orElse(null) : null;
        if (factionPlayer == null) {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.noinfaction"), false);
            return 0;
        }
        if (factionPlayer.getSkillHandler().isSkillEnabled(skill)) {
            factionPlayer.getSkillHandler().disableSkill(skill);
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.disabled"), false);
            return 0;
        }
        ISkillHandler.Result result = factionPlayer.getSkillHandler().canSkillBeEnabled(skill);
        if (force) {
            result = ISkillHandler.Result.OK;
        }
        switch (result) {
            case OK: {
                factionPlayer.getSkillHandler().enableSkill(skill);
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.enabled", new Object[]{skill.getRegistryName() + " (" + skill.getName().getString() + ")"}), false);
                return 0;
            }
            case ALREADY_ENABLED: {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.alreadyenabled", new Object[]{skill.getName()}), false);
                return 0;
            }
            case PARENT_NOT_ENABLED: {
                ISkill[] skills = factionPlayer.getSkillHandler().getParentSkills(skill);
                if (skills == null || skills.length == 0) {
                    return 0;
                }
                if (skills.length == 1) {
                    commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.parent", new Object[]{skills[0].getRegistryName()}), false);
                } else {
                    commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.parents", new Object[]{skills[0].getRegistryName(), skills[1].getRegistryName()}), false);
                }
                return 0;
            }
            case NO_POINTS: {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.nopoints"), false);
                return 0;
            }
            case OTHER_NODE_SKILL: {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.othernode"), false);
                return 0;
            }
            case NOT_FOUND: {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.otherfaction"), false);
                return 0;
            }
            case LOCKED_BY_OTHER_NODE: {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.locked"), false);
                return 0;
            }
            case LOCKED_BY_PLAYER_STATE: {
                commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.skill.locked_player_state"), false);
                return 0;
            }
        }
        return 0;
    }
}

