/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.world.biome.VampireForestBiome;
import de.teamlapen.vampirism.world.biome.VampirismBiomeFeatures;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

public class ModBiomes {
    @ObjectHolder(value="vampirism:vampire_forest")
    public static final Biome vampire_forest = (Biome)UtilLib.getNull();
    @ObjectHolder(value="vampirism:vampire_forest_hills")
    public static final Biome vampire_forest_hills = (Biome)UtilLib.getNull();
    public static final RegistryKey<Biome> VAMPIRE_FOREST_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("vampirism", "vampire_forest"));
    public static final RegistryKey<Biome> VAMPIRE_FOREST_HILLS_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("vampirism", "vampire_forest_hills"));

    static void registerBiomes(IForgeRegistry<Biome> registry) {
        registry.register(VampireForestBiome.createVampireForest(0.1f, 0.025f).setRegistryName(VAMPIRE_FOREST_KEY.func_240901_a_()));
        registry.register(VampireForestBiome.createVampireForest(0.8f, 0.5f).setRegistryName(VAMPIRE_FOREST_HILLS_KEY.func_240901_a_()));
        VampirismAPI.sundamageRegistry().addNoSundamageBiomes(VAMPIRE_FOREST_KEY.func_240901_a_());
        VampirismAPI.sundamageRegistry().addNoSundamageBiomes(VAMPIRE_FOREST_HILLS_KEY.func_240901_a_());
        BiomeDictionary.addTypes(VAMPIRE_FOREST_KEY, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SPOOKY});
    }

    static void addBiomesToGeneratorUnsafe() {
        BiomeManager.addAdditionalOverworldBiomes(VAMPIRE_FOREST_KEY);
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(VAMPIRE_FOREST_KEY, ((Integer)VampirismConfig.COMMON.vampireForestWeight.get()).intValue()));
    }

    public static void onBiomeLoadingEventAdditions(BiomeLoadingEvent event) {
        Biome.Category cat;
        List monsterList = event.getSpawns().getSpawner(EntityClassification.MONSTER);
        if (monsterList != null && monsterList.stream().anyMatch(spawners -> spawners.field_242588_c == EntityType.field_200725_aD)) {
            int advancedHunterChance;
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.vampire, ((Integer)VampirismConfig.COMMON.vampireSpawnChance.get()).intValue(), 1, 3));
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.advanced_vampire, ((Integer)VampirismConfig.COMMON.advancedVampireSpawnChance.get()).intValue(), 1, 1));
            int hunterChance = (Integer)VampirismConfig.COMMON.hunterSpawnChance.get();
            if (hunterChance > 0) {
                event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.hunter, hunterChance, 1, 3));
            }
            if ((advancedHunterChance = ((Integer)VampirismConfig.COMMON.advancedHunterSpawnChance.get()).intValue()) > 0) {
                event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.advanced_hunter, advancedHunterChance, 1, 1));
            }
        }
        if ((cat = event.getCategory()) != Biome.Category.NETHER && cat != Biome.Category.THEEND && cat != Biome.Category.OCEAN && cat != Biome.Category.NONE) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, VampirismBiomeFeatures.vampire_dungeon);
        }
        if (VampirismAPI.worldGenRegistry().canStructureBeGeneratedInBiome(ModFeatures.hunter_camp.getRegistryName(), event.getName(), event.getCategory())) {
            event.getGeneration().func_242516_a(VampirismBiomeFeatures.hunter_camp);
        }
    }
}

