/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.effects.FreezeEffect;
import de.teamlapen.vampirism.effects.OblivionEffect;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.ThirstEffect;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.effects.VampirismNightVisionPotion;
import de.teamlapen.vampirism.effects.VampirismPoisonEffect;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ObjectHolder(value="vampirism")
public class ModEffects {
    public static final Effect sanguinare = (Effect)UtilLib.getNull();
    public static final Effect thirst = (Effect)UtilLib.getNull();
    public static final Effect saturation = (Effect)UtilLib.getNull();
    public static final Effect sunscreen = (Effect)UtilLib.getNull();
    public static final Effect disguise_as_vampire = (Effect)UtilLib.getNull();
    public static final Effect fire_protection = (Effect)UtilLib.getNull();
    public static final Effect garlic = (Effect)UtilLib.getNull();
    public static final Effect poison = (Effect)UtilLib.getNull();
    public static final Effect freeze = (Effect)UtilLib.getNull();
    public static final Effect neonatal = (Effect)UtilLib.getNull();
    public static final Effect oblivion = (Effect)UtilLib.getNull();
    public static final Effect armor_regeneration = (Effect)UtilLib.getNull();
    public static final Effect bad_omen_hunter = (Effect)UtilLib.getNull();
    public static final Effect bad_omen_vampire = (Effect)UtilLib.getNull();
    private static final Logger LOGGER = LogManager.getLogger();
    private static Effect modded_night_vision;
    private static Effect vanilla_night_vision;

    static void registerEffects(IForgeRegistry<Effect> registry) {
        vanilla_night_vision = Effects.field_76439_r;
        registry.register((IForgeRegistryEntry)new VampirismNightVisionPotion());
        registry.register((IForgeRegistryEntry)new ThirstEffect("thirst", EffectType.HARMFUL, 859494));
        registry.register((IForgeRegistryEntry)new SanguinareEffect("sanguinare", EffectType.NEUTRAL, 6949000));
        registry.register((IForgeRegistryEntry)new VampirismEffect("saturation", EffectType.BENEFICIAL, 14483200));
        registry.register((IForgeRegistryEntry)new VampirismEffect("sunscreen", EffectType.BENEFICIAL, 0xFFF100).func_220304_a((Attribute)ModAttributes.sundamage, "9dc9420c-3e5e-41c7-9ba4-ff70e9dc69fc", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        registry.register((IForgeRegistryEntry)new VampirismEffect("fire_protection", EffectType.BENEFICIAL, 14981690));
        registry.register((IForgeRegistryEntry)new VampirismEffect("disguise_as_vampire", EffectType.NEUTRAL, 0x999900));
        registry.register((IForgeRegistryEntry)new VampirismEffect("garlic", EffectType.HARMFUL, 0xFFFFFF));
        registry.register((IForgeRegistryEntry)new VampirismPoisonEffect("poison", 5149489));
        registry.register((IForgeRegistryEntry)new FreezeEffect("freeze"));
        registry.register((IForgeRegistryEntry)new VampirismEffect("neonatal", EffectType.NEUTRAL, 0xFFBBBB).func_220304_a(Attributes.field_233823_f_, "377d132d-d091-43b2-8a8f-b940f9bc894c", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL).func_220304_a(Attributes.field_233821_d_, "ad6d7def-46e2-485f-afba-39252767f114", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL));
        registry.register((IForgeRegistryEntry)new OblivionEffect("oblivion", EffectType.NEUTRAL, 5149489));
        registry.register((IForgeRegistryEntry)new VampirismEffect("armor_regeneration", EffectType.NEUTRAL, 13727298));
        registry.register((IForgeRegistryEntry)new BadOmenEffect("vampirism", REFERENCE.HUNTER_PLAYER_KEY){

            @Override
            public IFaction<?> getFaction() {
                return VReference.HUNTER_FACTION;
            }
        });
        registry.register((IForgeRegistryEntry)new BadOmenEffect("vampirism", REFERENCE.VAMPIRE_PLAYER_KEY){

            @Override
            public IFaction<?> getFaction() {
                return VReference.VAMPIRE_FACTION;
            }
        });
    }

    static void fixNightVisionEffectTypes() {
        LOGGER.info("Fixing vanilla night vision potion types");
        try {
            for (EffectInstance effect : Potions.field_185234_f.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(EffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"potion");
            }
            for (EffectInstance effect : Potions.field_185235_g.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(EffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"potion");
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            LOGGER.error("Unable to modify vanilla night vision types. Potion tileInventory and more might not work", (Throwable)e);
        }
    }

    static boolean checkNightVision() {
        if (!(Effects.field_76439_r instanceof VampirismNightVisionPotion)) {
            LOGGER.warn("Vampirism was not able to register it's night vision potion");
            return false;
        }
        return true;
    }
}

