/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.BlindingBatEntity;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.ThrowableItemEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCowEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedDonkeyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedHorseEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedMuleEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedSheepEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.converted.SpecialConvertingHandler;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTaskMasterEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.entity.vampire.DummyBittenAnimalEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireTaskMasterEntity;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="vampirism")
public class ModEntities {
    public static final EntityType<AdvancedHunterEntity> advanced_hunter;
    public static final EntityType<AdvancedHunterEntity.IMob> advanced_hunter_imob;
    public static final EntityType<AdvancedVampireEntity> advanced_vampire;
    public static final EntityType<AdvancedVampireEntity.IMob> advanced_vampire_imob;
    public static final EntityType<BlindingBatEntity> blinding_bat;
    public static final EntityType<ConvertedCreatureEntity> converted_creature;
    public static final EntityType<ConvertedCreatureEntity.IMob> converted_creature_imob;
    public static final EntityType<ConvertedSheepEntity> converted_sheep;
    public static final EntityType<ConvertedCowEntity> converted_cow;
    public static final EntityType<ConvertedDonkeyEntity> converted_donkey;
    public static final EntityType<ConvertedMuleEntity> converted_mule;
    public static final EntityType<ConvertedHorseEntity> converted_horse;
    public static final EntityType<CrossbowArrowEntity> crossbow_arrow;
    public static final EntityType<DarkBloodProjectileEntity> dark_blood_projectile;
    public static final EntityType<DummyBittenAnimalEntity> dummy_creature;
    public static final EntityType<HunterTrainerEntity> hunter_trainer;
    public static final EntityType<DummyHunterTrainerEntity> hunter_trainer_dummy;
    public static final EntityType<AreaParticleCloudEntity> particle_cloud;
    public static final EntityType<SoulOrbEntity> soul_orb;
    public static final EntityType<ThrowableItemEntity> throwable_item;
    public static final EntityType<BasicVampireEntity> vampire;
    public static final EntityType<BasicVampireEntity.IMob> vampire_imob;
    public static final EntityType<VampireBaronEntity> vampire_baron;
    public static final EntityType<BasicHunterEntity> hunter;
    public static final EntityType<BasicHunterEntity.IMob> hunter_imob;
    public static final EntityType<AggressiveVillagerEntity> villager_angry;
    public static final EntityType<ConvertedVillagerEntity> villager_converted;
    public static final EntityType<VampireMinionEntity> vampire_minion;
    public static final EntityType<HunterMinionEntity> hunter_minion;
    public static final EntityType<VampireTaskMasterEntity> task_master_vampire;
    public static final EntityType<HunterTaskMasterEntity> task_master_hunter;
    private static final Set<EntityType<?>> ALL_ENTITIES;

    static void registerCustomExtendedCreatures() {
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
    }

    static void registerConvertibles() {
        Function<String, ResourceLocation> overlay = name -> new ResourceLocation("vampirism", String.format("textures/entity/vanilla/%s_overlay.png", name));
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200796_j, overlay.apply("cow"), new ConvertedCowEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200769_I, overlay.apply("llama"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200781_U, overlay.apply("cat"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_220353_aa, overlay.apply("panda"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200784_X, overlay.apply("pig"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200786_Z, overlay.apply("polarbear"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200736_ab, overlay.apply("rabbit"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200737_ac, overlay.apply("sheep"), new ConvertedSheepEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200756_av, null, new ConvertedVillagerEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200762_B, overlay.apply("horse"), new SpecialConvertingHandler(converted_horse));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200798_l, overlay.apply("horse"), new SpecialConvertingHandler(converted_donkey));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200779_S, overlay.apply("horse"), new SpecialConvertingHandler(converted_mule));
    }

    static void registerEntities(IForgeRegistry<EntityType<?>> registry) {
        registry.register(advanced_hunter);
        registry.register(ModEntities.prepareEntityType("advanced_hunter_imob", EntityType.Builder.func_220322_a(AdvancedHunterEntity.IMob::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
        registry.register(advanced_vampire);
        registry.register(ModEntities.prepareEntityType("advanced_vampire_imob", EntityType.Builder.func_220322_a(AdvancedVampireEntity.IMob::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
        registry.register(blinding_bat);
        registry.register(converted_creature);
        registry.register(ModEntities.prepareEntityType("converted_creature_imob", EntityType.Builder.func_220322_a(ConvertedCreatureEntity.IMob::new, (EntityClassification)EntityClassification.CREATURE), false));
        registry.register(ModEntities.prepareEntityType("converted_sheep", EntityType.Builder.func_220322_a(ConvertedSheepEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.3f), false));
        registry.register(ModEntities.prepareEntityType("converted_cow", EntityType.Builder.func_220322_a(ConvertedCowEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f), false));
        registry.register(ModEntities.prepareEntityType("crossbow_arrow", EntityType.Builder.func_220322_a(CrossbowArrowEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory((spawnEntity, world) -> new CrossbowArrowEntity((EntityType<? extends CrossbowArrowEntity>)crossbow_arrow, (World)world)), false));
        registry.register(ModEntities.prepareEntityType("dark_blood_projectile", EntityType.Builder.func_220322_a(DarkBloodProjectileEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.95f).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new DarkBloodProjectileEntity((EntityType<? extends DarkBloodProjectileEntity>)dark_blood_projectile, (World)world)), false));
        registry.register(dummy_creature);
        registry.register(hunter_trainer);
        registry.register(ModEntities.prepareEntityType("hunter_trainer_dummy", EntityType.Builder.func_220322_a(DummyHunterTrainerEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.95f), true));
        registry.register(ModEntities.prepareEntityType("particle_cloud", EntityType.Builder.func_220322_a(AreaParticleCloudEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(6.0f, 0.5f).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new AreaParticleCloudEntity((EntityType<? extends AreaParticleCloudEntity>)particle_cloud, (World)world)), false));
        registry.register(ModEntities.prepareEntityType("soul_orb", EntityType.Builder.func_220322_a(SoulOrbEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new SoulOrbEntity((EntityType<? extends SoulOrbEntity>)soul_orb, (World)world)), false));
        registry.register(ModEntities.prepareEntityType("throwable_item", EntityType.Builder.func_220322_a(ThrowableItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setCustomClientFactory((spawnEntity, world) -> new ThrowableItemEntity((EntityType<? extends ThrowableItemEntity>)throwable_item, (World)world)), false));
        registry.register(vampire);
        registry.register(ModEntities.prepareEntityType("vampire_imob", EntityType.Builder.func_220322_a(BasicVampireEntity.IMob::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
        registry.register(vampire_baron);
        registry.register(hunter);
        registry.register(ModEntities.prepareEntityType("hunter_imob", EntityType.Builder.func_220322_a(BasicHunterEntity.IMob::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("villager_angry", EntityType.Builder.func_220322_a(AggressiveVillagerEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("villager_converted", EntityType.Builder.func_220322_a(ConvertedVillagerEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("converted_horse", EntityType.Builder.func_220322_a(ConvertedHorseEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f), false));
        registry.register(ModEntities.prepareEntityType("vampire_minion", EntityType.Builder.func_220322_a(VampireMinionEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("converted_donkey", EntityType.Builder.func_220322_a(ConvertedDonkeyEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.5f), false));
        registry.register(ModEntities.prepareEntityType("converted_mule", EntityType.Builder.func_220322_a(ConvertedMuleEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.5f), false));
        VampireMinionEntity.init();
        HunterMinionEntity.init();
        registry.register(ModEntities.prepareEntityType("hunter_minion", EntityType.Builder.func_220322_a(HunterMinionEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f), false));
        registry.register(ModEntities.prepareEntityType("task_master_vampire", EntityType.Builder.func_220322_a(VampireTaskMasterEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
        registry.register(ModEntities.prepareEntityType("task_master_hunter", EntityType.Builder.func_220322_a(HunterTaskMasterEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    }

    static void registerSpawns() {
        EntitySpawnPlacementRegistry.func_209343_a(advanced_hunter, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter);
        EntitySpawnPlacementRegistry.func_209343_a(advanced_vampire, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire);
        EntitySpawnPlacementRegistry.func_209343_a(blinding_bat, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BlindingBatEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a(dummy_creature, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DummyBittenAnimalEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a(converted_creature, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a(converted_sheep, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a(converted_cow, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a(hunter_trainer, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(hunter_trainer_dummy, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(vampire, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire);
        EntitySpawnPlacementRegistry.func_209343_a(vampire_baron, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VampireBaronEntity::spawnPredicateBaron);
        EntitySpawnPlacementRegistry.func_209343_a(hunter, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter);
        EntitySpawnPlacementRegistry.func_209343_a(villager_angry, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(villager_converted, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    static void onRegisterEntityTypeAttributes(EntityAttributeCreationEvent event) {
        event.put(advanced_hunter, AdvancedHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put(advanced_hunter_imob, AdvancedHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put(advanced_vampire, AdvancedVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(advanced_vampire_imob, AdvancedVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(blinding_bat, BatEntity.func_234175_m_().func_233813_a_());
        event.put(converted_creature, BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(converted_creature_imob, BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(converted_horse, ConvertedHorseEntity.getAttributeBuilder().func_233813_a_());
        event.put(converted_sheep, BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(converted_cow, BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(converted_donkey, ConvertedDonkeyEntity.getAttributeBuilder().func_233813_a_());
        event.put(converted_mule, ConvertedMuleEntity.getAttributeBuilder().func_233813_a_());
        event.put(dummy_creature, BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(hunter, BasicHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put(hunter_imob, BasicHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put(hunter_trainer, HunterTrainerEntity.getAttributeBuilder().func_233813_a_());
        event.put(hunter_trainer_dummy, HunterTrainerEntity.getAttributeBuilder().func_233813_a_());
        event.put(vampire, BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(vampire_imob, BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put(vampire_baron, VampireBaronEntity.getAttributeBuilder().func_233813_a_());
        event.put(villager_angry, AggressiveVillagerEntity.getAttributeBuilder().func_233813_a_());
        event.put(villager_converted, ConvertedVillagerEntity.getAttributeBuilder().func_233813_a_());
        event.put(hunter_minion, HunterMinionEntity.getAttributeBuilder().func_233813_a_());
        event.put(vampire_minion, VampireMinionEntity.getAttributeBuilder().func_233813_a_());
        event.put(task_master_hunter, HunterTaskMasterEntity.getAttributeBuilder().func_233813_a_());
        event.put(task_master_vampire, VampireTaskMasterEntity.getAttributeBuilder().func_233813_a_());
    }

    static void onModifyEntityTypeAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.sundamage);
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.blood_exhaustion);
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.bite_damage);
    }

    private static <T extends Entity> EntityType<T> prepareEntityType(String id, EntityType.Builder<T> builder, boolean spawnable) {
        EntityType.Builder type = builder.setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
        if (!spawnable) {
            type.func_200705_b();
        }
        EntityType entry = type.func_206830_a("vampirism:" + id);
        entry.setRegistryName("vampirism", id);
        if (VampirismMod.inDataGen) {
            ALL_ENTITIES.add(entry);
        }
        return entry;
    }

    static void fixMapping(RegistryEvent.MissingMappings<EntityType<?>> missingMappings) {
        missingMappings.getAllMappings().forEach(mapping -> {
            if (mapping.key.equals((Object)new ResourceLocation("vampirism:vampire_hunter"))) {
                mapping.remap(hunter);
            } else if (mapping.key.equals((Object)new ResourceLocation("vampirism:vampire_hunter_imob"))) {
                mapping.remap(hunter_imob);
            }
        });
    }

    public static Set<EntityType<?>> getAllEntities() {
        return ImmutableSet.copyOf(ALL_ENTITIES);
    }

    static {
        advanced_hunter_imob = (EntityType)UtilLib.getNull();
        advanced_vampire_imob = (EntityType)UtilLib.getNull();
        converted_creature_imob = (EntityType)UtilLib.getNull();
        converted_sheep = (EntityType)UtilLib.getNull();
        converted_cow = (EntityType)UtilLib.getNull();
        converted_donkey = (EntityType)UtilLib.getNull();
        converted_mule = (EntityType)UtilLib.getNull();
        converted_horse = (EntityType)UtilLib.getNull();
        crossbow_arrow = (EntityType)UtilLib.getNull();
        dark_blood_projectile = (EntityType)UtilLib.getNull();
        hunter_trainer_dummy = (EntityType)UtilLib.getNull();
        particle_cloud = (EntityType)UtilLib.getNull();
        soul_orb = (EntityType)UtilLib.getNull();
        throwable_item = (EntityType)UtilLib.getNull();
        vampire_imob = (EntityType)UtilLib.getNull();
        hunter_imob = (EntityType)UtilLib.getNull();
        villager_angry = (EntityType)UtilLib.getNull();
        villager_converted = (EntityType)UtilLib.getNull();
        vampire_minion = (EntityType)UtilLib.getNull();
        hunter_minion = (EntityType)UtilLib.getNull();
        task_master_vampire = (EntityType)UtilLib.getNull();
        task_master_hunter = (EntityType)UtilLib.getNull();
        ALL_ENTITIES = Sets.newHashSet();
        hunter = ModEntities.prepareEntityType("hunter", EntityType.Builder.func_220322_a(BasicHunterEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true);
        hunter_trainer = ModEntities.prepareEntityType("hunter_trainer", EntityType.Builder.func_220322_a(HunterTrainerEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true);
        advanced_hunter = ModEntities.prepareEntityType("advanced_hunter", EntityType.Builder.func_220322_a(AdvancedHunterEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true);
        vampire_baron = ModEntities.prepareEntityType("vampire_baron", EntityType.Builder.func_220322_a(VampireBaronEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true);
        vampire = ModEntities.prepareEntityType("vampire", EntityType.Builder.func_220322_a(BasicVampireEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true);
        advanced_vampire = ModEntities.prepareEntityType("advanced_vampire", EntityType.Builder.func_220322_a(AdvancedVampireEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true);
        converted_creature = ModEntities.prepareEntityType("converted_creature", EntityType.Builder.func_220322_a(ConvertedCreatureEntity::new, (EntityClassification)EntityClassification.CREATURE), false);
        dummy_creature = ModEntities.prepareEntityType("dummy_creature", EntityType.Builder.func_220322_a(DummyBittenAnimalEntity::new, (EntityClassification)EntityClassification.CREATURE), true);
        blinding_bat = ModEntities.prepareEntityType("blinding_bat", EntityType.Builder.func_220322_a(BlindingBatEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.5f, 0.9f), true);
    }
}

