/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;

public abstract class BadOmenEffect
extends Effect {
    public static void handlePotentialBannerKill(@Nullable Entity offender, IFactionEntity victim) {
        if (offender instanceof PlayerEntity) {
            Effect badOmen;
            IPlayableFaction<? extends IFactionPlayer<?>> playerFaction;
            PlayerEntity player = (PlayerEntity)offender;
            IFaction faction = victim.getFaction();
            if (faction.getVillageData().isBanner(victim.getRepresentingEntity().func_184582_a(EquipmentSlotType.HEAD)) && (playerFaction = VampirismPlayerAttributes.get((PlayerEntity)player).faction) != null && playerFaction != faction && (badOmen = faction.getVillageData().getBadOmenEffect()) != null) {
                int i;
                EffectInstance inst = player.func_70660_b(badOmen);
                int n = i = inst != null ? Math.min(inst.func_76458_c() + 1, 4) : 0;
                if (inst != null) {
                    player.func_184596_c(badOmen);
                }
                player.func_195064_c(new EffectInstance(badOmen, 120000, i, false, false, true));
            }
        }
    }

    public BadOmenEffect(String modID, ResourceLocation faction) {
        super(EffectType.NEUTRAL, 745784);
        this.setRegistryName(modID, "bad_omen_" + faction.func_110623_a());
    }

    public abstract IFaction<?> getFaction();

    public void func_76394_a(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof ServerPlayerEntity && !entityLivingBaseIn.func_175149_v()) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)entityLivingBaseIn;
            ServerWorld serverWorld = playerEntity.func_71121_q();
            if (serverWorld.func_175659_aa() == Difficulty.PEACEFUL) {
                return;
            }
            TotemHelper.getTotemNearPos(serverWorld, entityLivingBaseIn.func_233580_cy_(), true).ifPresent(totem -> {
                if (totem.getControllingFaction() != this.getFaction()) {
                    int level = Math.min(amplifier, 4);
                    if (totem.initiateCaptureOrIncreaseBadOmenLevel(this.getFaction(), null, level + 1, 0.0f)) {
                        entityLivingBaseIn.func_195063_d((Effect)this);
                    }
                }
            });
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }
}

