/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffectInstance;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SanguinareEffect
extends VampirismEffect {
    public static void addRandom(LivingEntity entity, boolean player) {
        int avgDuration = 20 * (player ? (Integer)VampirismConfig.BALANCE.vpSanguinareAverageDuration.get() : BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        int duration = (int)((entity.func_70681_au().nextFloat() + 0.5f) * (float)avgDuration);
        SanguinareEffectInstance effect = new SanguinareEffectInstance(duration);
        Preconditions.checkNotNull((Object)((Object)effect));
        if (!((Boolean)VampirismConfig.BALANCE.canCancelSanguinare.get()).booleanValue()) {
            effect.setCurativeItems(new ArrayList());
        }
        entity.func_195064_c((EffectInstance)effect);
    }

    public SanguinareEffect(String name, EffectType effectType, int potionColor) {
        super(name, effectType, potionColor);
        this.func_220304_a(Attributes.field_233823_f_, "22663B89-116E-49DC-9B6B-9971489B5BE5", 2.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public List<ItemStack> getCurativeItems() {
        List<ItemStack> l = super.getCurativeItems();
        l.add(new ItemStack((IItemProvider)ModItems.garlic_bread));
        return l;
    }

    @Override
    public void func_76394_a(LivingEntity entity, int amplifier) {
        if (entity.field_70170_p.field_72995_K || !entity.func_70089_S()) {
            return;
        }
        if (entity instanceof CreatureEntity) {
            ExtendedCreature.getSafe((Entity)entity).ifPresent(IExtendedCreatureVampirism::makeVampire);
        }
        if (entity instanceof PlayerEntity) {
            VampirePlayer.getOpt((PlayerEntity)entity).ifPresent(VampirePlayer::onSanguinareFinished);
        }
    }

    @Override
    public boolean func_76397_a(int duration, int amplifier) {
        return duration == 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack mStack, int x, int y, float z) {
        String s = UtilLib.translate(effect.func_188419_a().func_76393_a(), new Object[0]);
        gui.field_230712_o_.func_238405_a_(mStack, s, (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderInvText(EffectInstance effect) {
        return false;
    }
}

