/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.Helper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SundamageRegistry
implements ISundamageRegistry {
    private static final Logger LOGGER = LogManager.getLogger(SundamageRegistry.class);
    private final HashMap<RegistryKey<World>, Boolean> sundamageDims = new HashMap();
    private final HashMap<RegistryKey<World>, Boolean> sundamageConfiguredDims = new HashMap();
    private final Set<ResourceLocation> noSundamageBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();
    private final Set<ResourceLocation> noSundamageConfiguredBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();

    public SundamageRegistry() {
        this.sundamageDims.put((RegistryKey<World>)World.field_234918_g_, true);
        this.sundamageDims.put((RegistryKey<World>)World.field_234919_h_, false);
        this.sundamageDims.put((RegistryKey<World>)World.field_234920_i_, false);
    }

    public void addNoSundamageBiomeConfigured(ResourceLocation id) {
        this.noSundamageConfiguredBiomesIDs.add(id);
    }

    @Override
    public void addNoSundamageBiomes(ResourceLocation ... biomes) {
        this.noSundamageBiomesIDs.addAll(Arrays.asList(biomes));
    }

    @Override
    @Deprecated
    public boolean getSundamageInBiome(ResourceLocation registryName) {
        return !this.noSundamageBiomesIDs.contains(registryName) && !this.noSundamageConfiguredBiomesIDs.contains(registryName);
    }

    @Override
    public boolean getSundamageInDim(RegistryKey<World> dim) {
        Boolean r = this.sundamageConfiguredDims.get(dim);
        if (r == null) {
            r = this.sundamageDims.get(dim);
        }
        return r == null ? ((Boolean)VampirismConfig.SERVER.sundamageUnknownDimension.get()).booleanValue() : r.booleanValue();
    }

    @Override
    public boolean isGettingSundamage(LivingEntity entity, IWorld world) {
        return Helper.gettingSundamge(entity, world, null);
    }

    public void reloadConfiguration() {
        this.sundamageConfiguredDims.clear();
        List negative = (List)VampirismConfig.SERVER.sundamageDimensionsOverrideNegative.get();
        for (Object s : negative) {
            ResourceLocation id = new ResourceLocation((String)s);
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)id);
            this.sundamageConfiguredDims.put((RegistryKey<World>)key, false);
        }
        List positive = (List)VampirismConfig.SERVER.sundamageDimensionsOverridePositive.get();
        for (String s : positive) {
            ResourceLocation id = new ResourceLocation(s);
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)id);
            this.sundamageConfiguredDims.put((RegistryKey<World>)key, true);
        }
        this.noSundamageConfiguredBiomesIDs.clear();
        List biomes = (List)VampirismConfig.SERVER.sundamageDisabledBiomes.get();
        for (String s : biomes) {
            ResourceLocation id = new ResourceLocation(s);
            this.noSundamageConfiguredBiomesIDs.add(id);
        }
    }

    public void specifyConfiguredSundamageForDim(RegistryKey<World> dimension, boolean sundamage) {
        this.sundamageConfiguredDims.put(dimension, sundamage);
    }

    @Override
    public void specifySundamageForDim(RegistryKey<World> dimension, boolean sundamage) {
        this.sundamageDims.put(dimension, sundamage);
    }
}

