/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.VillagerTasks;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ConvertedVillagerEntity
extends VampirismVillagerEntity
implements ICurableConvertedCreature<VillagerEntity> {
    public static final List<SensorType<? extends Sensor<? super VillagerEntity>>> SENSOR_TYPES;
    private static final DataParameter<Boolean> CONVERTING;
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;
    private int conversionTime;
    private UUID conversationStarter;

    public ConvertedVillagerEntity(EntityType<? extends ConvertedVillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ConversionTime", this.isConverting((CreatureEntity)this) ? this.conversionTime : -1);
        if (this.conversationStarter != null) {
            compound.func_186854_a("ConversionPlayer", this.conversationStarter);
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.isConverting((CreatureEntity)this)) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.field_200756_av, timer -> {
                this.conversionTime = timer;
            })) {
                this.cureEntity((ServerWorld)this.field_70170_p, (CreatureEntity)this, (EntityType<VillagerEntity>)EntityType.field_200756_av);
            }
        }
        if (this.field_70173_aa % 40 == 1) {
            this.isGettingGarlicDamage((IWorld)this.field_70170_p, true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage((IWorld)this.field_70170_p, true);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isGettingSundamage((IWorld)this.field_70170_p) && this.field_70173_aa % 40 == 11) {
                this.func_195064_c(new EffectInstance(Effects.field_76437_t, 42));
            }
            if (this.isGettingGarlicDamage((IWorld)this.field_70170_p) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)this.field_70170_p), this.field_70173_aa);
            }
        }
        ++this.bloodTimer;
        super.func_70636_d();
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public VillagerEntity cureEntity(ServerWorld world, CreatureEntity entity, EntityType<VillagerEntity> newType) {
        PlayerEntity playerentity;
        VillagerEntity villager = ICurableConvertedCreature.super.cureEntity(world, entity, newType);
        villager.func_213753_a(this.func_213700_eh());
        villager.func_223716_a((INBT)this.func_223722_es().func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
        villager.func_213768_b(this.func_213706_dY());
        villager.func_213761_t(this.func_213708_dV());
        if (this.conversationStarter != null && (playerentity = world.func_217371_b(this.conversationStarter)) instanceof ServerPlayerEntity) {
            ModAdvancements.TRIGGER_CURED_VAMPIRE_VILLAGER.trigger((ServerPlayerEntity)playerentity, this, villager);
            world.func_217489_a(IReputationType.field_221029_a, (Entity)playerentity, (IReputationTracking)villager);
        }
        return villager;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.wantsBlood() && entity instanceof PlayerEntity && !Helper.isHunter(entity) && !UtilLib.canReallySee((LivingEntity)entity, (LivingEntity)this, true)) {
            int amt = VampirePlayer.getOpt((PlayerEntity)entity).map(vampire -> vampire.onBite(this)).orElse(0);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        return super.func_70652_k(entity);
    }

    @Override
    public DataParameter<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, amt * 20));
        this.bloodTimer = -1200 - this.field_70146_Z.nextInt(1200);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    protected ITextComponent func_225513_by_() {
        ResourceLocation profName = this.func_213700_eh().func_221130_b().getRegistryName();
        return new TranslationTextComponent(EntityType.field_200756_av.func_210760_d() + '.' + (!"minecraft".equals(profName.func_110624_b()) ? profName.func_110624_b() + '.' : "") + profName.func_110623_a());
    }

    public void func_70103_a(byte id) {
        if (!this.handleSound(id, (CreatureEntity)this)) {
            super.func_70103_a(id);
        }
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.field_70170_p.func_217381_Z());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Nonnull
    public ActionResultType func_230254_b_(PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() != ModItems.cure_apple) {
            return super.func_230254_b_(player, hand);
        }
        return this.interactWithCureItem(player, stack, (CreatureEntity)this);
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ConversionTime", 99) && compound.func_74762_e("ConversionTime") > -1) {
            this.startConverting(compound.func_186855_b("ConversionPlayer") ? compound.func_186857_a("ConversionPlayer") : null, compound.func_74762_e("ConversionTime"), (CreatureEntity)this);
        }
    }

    @Override
    public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, CreatureEntity entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        this.conversationStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
    }

    public void func_213744_a(@Nonnull Brain<VillagerEntity> brain) {
        VillagerProfession villagerprofession = this.func_213700_eh().func_221130_b();
        float f = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        if (this.func_70631_g_()) {
            brain.func_218203_a(Schedule.field_221385_c);
            brain.func_218208_a(Activity.field_221368_d, VillagerTasks.func_220645_a((float)f));
        } else {
            brain.func_218203_a(ModVillage.converted_default);
            brain.func_233700_a_(Activity.field_221367_c, VillagerTasks.func_220639_b((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        }
        brain.func_218208_a(Activity.field_221365_a, VillagerTasks.func_220638_a((VillagerProfession)villagerprofession, (float)f));
        brain.func_233700_a_(Activity.field_221370_f, VillagerTasks.func_220637_d((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        brain.func_218208_a(Activity.field_221369_e, VillagerTasks.func_220635_c((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221366_b, VillagerTasks.func_220641_e((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221371_g, VillagerTasks.func_220636_f((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221373_i, VillagerTasks.func_220642_g((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221372_h, VillagerTasks.func_220640_h((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221374_j, VillagerTasks.func_220644_i((VillagerProfession)villagerprofession, (float)f));
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        brain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_195064_c(new EffectInstance(Effects.field_76437_t, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.registerConvertingData((CreatureEntity)this);
    }

    @Nonnull
    protected Brain<?> func_213364_a(@Nonnull Dynamic<?> dynamicIn) {
        Brain brain = Brain.func_233705_a_((Collection)field_213786_bQ, SENSOR_TYPES).func_233748_a_(dynamicIn);
        this.func_213744_a((Brain<VillagerEntity>)brain);
        return brain;
    }

    protected void func_213712_ef() {
        super.func_213712_ef();
        if (!this.func_213706_dY().isEmpty() && this.func_70681_au().nextInt(3) == 0) {
            this.func_213717_a(this.func_213706_dY(), Trades.converted_trades, 1);
        }
    }

    static {
        CONVERTING = EntityDataManager.func_187226_a(ConvertedVillagerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        SENSOR_TYPES = Lists.newArrayList((Iterable)VillagerEntity.field_213787_bR);
        SENSOR_TYPES.remove(SensorType.field_221003_g);
        SENSOR_TYPES.add(ModVillage.vampire_villager_hostiles);
    }

    public static class ConvertingHandler
    implements IConvertingHandler<VillagerEntity> {
        @Override
        public IConvertedCreature<VillagerEntity> createFrom(VillagerEntity entity) {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_189511_e(nbt);
            ConvertedVillagerEntity converted = (ConvertedVillagerEntity)ModEntities.villager_converted.func_200721_a(entity.field_70170_p);
            converted.func_70020_e(nbt);
            converted.func_184221_a(MathHelper.func_180182_a((Random)converted.field_70146_Z));
            converted.field_70761_aq = entity.field_70761_aq;
            converted.field_70759_as = entity.field_70759_as;
            return converted;
        }
    }
}

