/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public interface CurableConvertedCreature<T extends CreatureEntity, Z extends CreatureEntity>
extends ICurableConvertedCreature<T> {
    public Data<T> data();

    default public boolean hurtC(DamageSource damageSource, float amount) {
        CreatureEntity entity = (CreatureEntity)this;
        if (this.data().vulnerableToFire) {
            if (DamageSource.field_76372_a.equals(damageSource)) {
                return entity.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.field_76370_b.equals(damageSource)) {
                return entity.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return this.hurtSuper(damageSource, amount);
    }

    default public ActionResultType mobInteractC(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() != ModItems.cure_apple) {
            return this.mobInteractSuper(player, hand);
        }
        return this.interactWithCureItem(player, stack, (CreatureEntity)this);
    }

    @Override
    default public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        ((CreatureEntity)this).func_195064_c(new EffectInstance(Effects.field_76428_l, amt * 20));
    }

    default public ITextComponent getNameC(Supplier<ITextComponent> baseName) {
        if (this.data().name == null) {
            this.data().name = new TranslationTextComponent("entity.vampirism.vampire").func_230529_a_(baseName.get());
        }
        return this.data().name;
    }

    default public void handleEntityEventC(byte id) {
        if (!this.handleSound(id, (CreatureEntity)this)) {
            this.handleEntityEventSuper(id);
        }
    }

    @Override
    default public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(EnumStrength.NONE);
    }

    @Override
    @Nonnull
    default public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.data().garlicCache = Helper.getGarlicStrength((Entity)((CreatureEntity)this), iWorld);
        }
        return this.data().garlicCache;
    }

    @Override
    default public boolean isGettingSundamage(IWorld iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.data().sundamageCache;
        }
        this.data().sundamageCache = Helper.gettingSundamge((LivingEntity)((CreatureEntity)this), iWorld, ((CreatureEntity)this).field_70170_p.func_217381_Z());
        return this.data().sundamageCache;
    }

    @Override
    default public boolean isIgnoringSundamage() {
        return ((CreatureEntity)this).func_70644_a(ModEffects.sunscreen);
    }

    default public void aiStepC(EntityType<T> originalType) {
        CreatureEntity entity = (CreatureEntity)this;
        if (!entity.field_70170_p.field_72995_K && entity.func_70089_S() && this.isConverting(entity)) {
            --this.data().conversionTime;
            if (this.data().conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)entity, originalType, timer -> {
                this.data().conversionTime = timer;
            })) {
                this.cureEntity((ServerWorld)entity.field_70170_p, entity, originalType);
            }
        }
        if (entity.field_70173_aa % 40 == 1) {
            this.isGettingGarlicDamage((IWorld)entity.field_70170_p, true);
        }
        if (entity.field_70173_aa % 8 == 2) {
            this.isGettingSundamage((IWorld)entity.field_70170_p, true);
        }
        if (!entity.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage((IWorld)entity.field_70170_p) && entity.field_70173_aa % 40 == 11 && (dmg = entity.func_110148_a((Attribute)ModAttributes.sundamage).func_111126_e()) > 0.0) {
                entity.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage((IWorld)entity.field_70170_p) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)entity.field_70170_p), entity.field_70173_aa);
            }
            if (entity.func_70089_S() && entity.func_70090_H()) {
                entity.func_70050_g(300);
                if (entity.field_70173_aa % 16 == 4) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
                }
            }
        }
    }

    default public void dieC(DamageSource cause) {
        if (cause.func_76364_f() instanceof CrossbowArrowEntity && Helper.isHunter(cause.func_76346_g())) {
            this.data().dropSoul = true;
        } else if (cause.func_76364_f() instanceof PlayerEntity && Helper.isHunter(cause.func_76364_f())) {
            ItemStack weapon = ((PlayerEntity)cause.func_76364_f()).func_184614_ca();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof IVampireFinisher) {
                this.data().dropSoul = true;
            }
        } else {
            this.data().dropSoul = false;
        }
    }

    default public void readAdditionalSaveDataC(@Nonnull CompoundNBT compound) {
        if (compound.func_150297_b("ConversionTime", 99) && compound.func_74762_e("ConversionTime") > -1) {
            this.startConverting(compound.func_186855_b("ConversionPlayer") ? compound.func_186857_a("ConversionPlayer") : null, compound.func_74762_e("ConversionTime"), (CreatureEntity)this);
        }
    }

    default public void addAdditionalSaveDataC(@Nonnull CompoundNBT compound) {
        compound.func_74768_a("ConversionTime", this.isConverting((CreatureEntity)this) ? this.data().conversionTime : -1);
        if (this.data().conversationStarter != null) {
            compound.func_186854_a("ConversionPlayer", this.data().conversationStarter);
        }
    }

    @Override
    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @Nonnull CreatureEntity entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        this.data().conversationStarter = conversionStarterIn;
        this.data().conversionTime = conversionTimeIn;
    }

    @Override
    default public boolean useBlood(int amt, boolean allowPartial) {
        ((CreatureEntity)this).func_195064_c(new EffectInstance(Effects.field_76437_t, amt * 20));
        return true;
    }

    @Override
    default public boolean wantsBlood() {
        return false;
    }

    default public float calculateFireDamage(float amount) {
        return amount;
    }

    default public void tickDeathC() {
        CreatureEntity entity = (CreatureEntity)this;
        if (entity.field_70725_aQ == 19 && !entity.field_70170_p.field_72995_K && this.data().dropSoul && entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            entity.field_70170_p.func_217376_c((Entity)new SoulOrbEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
    }

    default public void registerGoalsC() {
        CreatureEntity entity = (CreatureEntity)this;
        entity.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(entity, CreatureEntity.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        entity.field_70714_bg.func_75776_a(4, (Goal)new RestrictSunGoal(entity));
        entity.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
        entity.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        entity.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, false, false, false, null)));
    }

    @Override
    default public LivingEntity getRepresentingEntity() {
        return (CreatureEntity)this;
    }

    public void handleEntityEventSuper(byte var1);

    public ActionResultType mobInteractSuper(@Nonnull PlayerEntity var1, @Nonnull Hand var2);

    public boolean hurtSuper(DamageSource var1, float var2);

    public static <T extends CreatureEntity, Z extends CreatureEntity> void createFrom() {
    }

    public static class Data<T> {
        public boolean vulnerableToFire = true;
        public EnumStrength garlicCache = EnumStrength.NONE;
        public T entityCreature;
        public boolean sundamageCache;
        public boolean dropSoul = false;
        @Nullable
        public ITextComponent name;
        public int conversionTime;
        public UUID conversationStarter;
    }
}

