/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;

public class DefaultConvertingHandler<T extends CreatureEntity>
implements IConvertingHandler<T> {
    private static final IConvertingHandler.IDefaultHelper defaultHelper = new IConvertingHandler.IDefaultHelper(){

        @Override
        public double getConvertedDMG(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            if (map.func_233809_c_(Attributes.field_233823_f_)) {
                return map.func_233807_b_(Attributes.field_233823_f_) * 1.3;
            }
            return BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG;
        }

        @Override
        public double getConvertedKnockbackResistance(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            return map.func_233807_b_(Attributes.field_233820_c_) * 1.3;
        }

        @Override
        public double getConvertedMaxHealth(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            return map.func_233807_b_(Attributes.field_233818_a_) * 1.5;
        }

        @Override
        public double getConvertedSpeed(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            return Math.min(map.func_233807_b_(Attributes.field_233821_d_) * 1.2, 2.9);
        }
    };
    protected final IConvertingHandler.IDefaultHelper helper;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper) {
        this.helper = helper == null ? defaultHelper : helper;
    }

    @Override
    @Nullable
    public IConvertedCreature<T> createFrom(T entity) {
        return Helper.createEntity(ModEntities.converted_creature, entity.func_130014_f_()).map(convertedCreature -> {
            this.copyImportantStuff((ConvertedCreatureEntity<T>)convertedCreature, entity);
            convertedCreature.func_184221_a(MathHelper.func_180182_a((Random)convertedCreature.func_70681_au()));
            convertedCreature.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 2));
            return convertedCreature;
        }).orElse(null);
    }

    public IConvertingHandler.IDefaultHelper getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(ConvertedCreatureEntity<T> converted, T entity) {
        converted.func_82149_j((Entity)entity);
        converted.setEntityCreature(entity);
        converted.updateEntityAttributes();
        converted.func_70606_j(converted.func_110138_aP() / 3.0f * 2.0f);
        converted.field_70761_aq = ((CreatureEntity)entity).field_70761_aq;
        converted.field_70759_as = ((CreatureEntity)entity).field_70759_as;
    }
}

