/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.goals;

import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class AttackRangedCrossbowGoal<T extends VampirismEntity>
extends Goal {
    private final T entity;
    private final double moveSpeedAmp;
    private final float maxAttackDistance;
    private final int attackCooldown;
    private int seeTime;
    private int strafingTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int attackTime;

    public AttackRangedCrossbowGoal(T entity, double speedAmplifier, int delay, float maxDistance) {
        this.entity = entity;
        this.moveSpeedAmp = speedAmplifier;
        this.attackCooldown = delay;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && ((IAttackWithCrossbow)this.entity).isCrossbowInMainhand();
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null && ((IAttackWithCrossbow)this.entity).isCrossbowInMainhand();
    }

    public void func_75249_e() {
        super.func_75249_e();
        ((IAttackWithCrossbow)this.entity).startTargeting();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.seeTime = 0;
        this.attackTime = -1;
        ((IAttackWithCrossbow)this.entity).stopTargeting();
    }

    public void func_75246_d() {
        LivingEntity entitylivingbase = this.entity.func_70638_az();
        if (entitylivingbase != null) {
            boolean couldSee;
            double d0 = this.entity.func_70092_e(entitylivingbase.func_226277_ct_(), entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.func_226281_cx_());
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)entitylivingbase);
            boolean bl = couldSee = this.seeTime > 0;
            if (canSee != couldSee) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)entitylivingbase, 30.0f, 30.0f);
            } else {
                this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, entitylivingbase.func_174824_e(1.0f));
            }
            if (--this.attackTime <= 0 && this.seeTime >= -30) {
                this.attackWithCrossbow(entitylivingbase);
                this.attackTime = this.attackCooldown;
            }
        }
    }

    protected void attackWithCrossbow(LivingEntity target) {
        ItemStack arrows = ((IAttackWithCrossbow)this.entity).getArrowStackForAttack(target);
        CrossbowArrowEntity entityArrow = CrossbowArrowEntity.createWithShooter(this.entity.func_130014_f_(), this.entity, 0.0, 0.3f, !this.entity.func_184638_cS(), arrows);
        double sx = target.func_226277_ct_() - entityArrow.func_226277_ct_();
        double sy = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - entityArrow.func_226278_cu_();
        double sz = target.func_226281_cx_() - entityArrow.func_226281_cx_();
        double dist = MathHelper.func_76133_a((double)(sx * sx + sz * sz));
        entityArrow.func_70186_c(sx, sy + dist * 0.2, sz, 1.6f, 13 - target.func_130014_f_().func_175659_aa().func_151525_a() * 4);
        this.entity.func_184185_a(ModSounds.crossbow, 0.5f, 1.0f);
        this.entity.func_130014_f_().func_217376_c((Entity)entityArrow);
    }

    public static interface IAttackWithCrossbow {
        @Nonnull
        public ItemStack getArrowStackForAttack(LivingEntity var1);

        public boolean isCrossbowInMainhand();

        public void startTargeting();

        public void stopTargeting();
    }
}

