/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.hunter.IBasicHunter;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.AttackRangedCrossbowGoal;
import de.teamlapen.vampirism.entity.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.container.HunterBasicContainer;
import de.teamlapen.vampirism.items.SimpleCrossbowItem;
import de.teamlapen.vampirism.items.VampirismItemCrossbow;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.util.HunterVillageData;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;

public class BasicHunterEntity
extends HunterBaseEntity
implements IBasicHunter,
ForceLookEntityGoal.TaskOwner,
AttackRangedCrossbowGoal.IAttackWithCrossbow,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(BasicHunterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(BasicHunterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WATCHED_ID = EntityDataManager.func_187226_a(BasicHunterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(BasicHunterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final ITextComponent name = new TranslationTextComponent("container.hunter");
    private final int MAX_LEVEL = 3;
    private final MeleeAttackGoal attackMelee;
    private final AttackRangedCrossbowGoal<BasicHunterEntity> attackRange;
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    private final EntityActionTier entitytier;
    @Nullable
    private PlayerEntity trainee;
    private float targetAngle = 0.0f;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampirismEntity.getAttributeBuilder();
        BalanceMobProps.mobProps.getClass();
        AttributeModifierMap.MutableAttribute mutableAttribute2 = mutableAttribute.func_233815_a_(Attributes.field_233818_a_, 30.0);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute2.func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    public BasicHunterEntity(EntityType<? extends BasicHunterEntity> type, World world) {
        super(type, world, true);
        this.saveHome = true;
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.setDontDropEquipment();
        this.attackMelee = new MeleeAttackGoal((CreatureEntity)this, 1.0, false);
        this.attackRange = new AttackRangedCrossbowGoal<BasicHunterEntity>(this, 0.6, 60, 20.0f);
        this.updateCombatTask();
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.func_70681_au());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicHunterEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74757_a("crossbow", this.isCrossbowInMainhand());
        nbt.func_74757_a("attack", this.attack);
        nbt.func_74768_a("type", this.getEntityTextureType());
        nbt.func_74768_a("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.trainee != null && !(this.trainee.field_71070_bA instanceof HunterBasicContainer)) {
            this.trainee = null;
        }
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity target = this.func_70638_az();
            int id = target == null ? 0 : target.func_145782_y();
            this.updateWatchedId(id);
            if (this.field_70173_aa % 512 == 0 && this.func_70681_au().nextInt(500) == 0) {
                BlockPos randomDestination = new BlockPos(this.func_70681_au().nextInt(30000) - 15000, 100, this.func_70681_au().nextInt(30000) - 15000);
                randomDestination = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, randomDestination);
                this.setHomeArea(randomDestination, 10);
            }
        } else {
            Entity target;
            int id;
            this.targetAngle = 0.0f;
            if (this.isSwingingArms() && (id = this.getWatchedId()) != 0 && (target = this.field_70170_p.func_73045_a(id)) instanceof LivingEntity) {
                double dx = target.func_226277_ct_() - this.func_226277_ct_();
                double dy = target.func_226278_cu_() - this.func_226278_cu_();
                double dz = target.func_226281_cx_() - this.func_226281_cx_();
                float dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                this.targetAngle = (float)Math.atan(dy / (double)dist);
            }
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    public void convertToMinion(PlayerEntity lord) {
        FactionPlayerHandler.getOpt(lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData(lord.field_70170_p).map(w -> w.getOrCreateController((FactionPlayerHandler)fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            HunterMinionEntity.HunterMinionData data = new HunterMinionEntity.HunterMinionData("Minion", this.getEntityTextureType(), this.getEntityTextureType() % 4, false);
                            int id = controller.createNewMinionSlot(data, ModEntities.hunter_minion);
                            if (id < 0) {
                                field_184243_a.error("Failed to get minion slot");
                                return;
                            }
                            HunterMinionEntity minion = (HunterMinionEntity)ModEntities.hunter_minion.func_200721_a(this.field_70170_p);
                            minion.claimMinionSlot(id, (PlayerMinionController)controller);
                            minion.func_82149_j((Entity)this);
                            minion.markAsConverted();
                            controller.activateTask(0, MinionTasks.stay);
                            UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                        } else {
                            field_184243_a.warn("Wrong faction for minion");
                        }
                    } else {
                        field_184243_a.warn("No free slot");
                    }
                });
            } else {
                field_184243_a.error("Can't have minions");
            }
        });
    }

    @Override
    public void defendVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity getActionHandler() {
        return this.entityActionHandler;
    }

    @Override
    @Nonnull
    public ItemStack getArrowStackForAttack(LivingEntity target) {
        return new ItemStack((IItemProvider)ModItems.crossbow_arrow_normal);
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (this.villageAttributes == null) {
            BadOmenEffect.handlePotentialBannerKill(cause.func_76346_g(), this);
        }
        super.func_70645_a(cause);
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    @Nonnull
    public Optional<PlayerEntity> getForceLookTarget() {
        return Optional.ofNullable(this.trainee);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && this.func_184614_ca().func_190926_b()) {
            this.func_184609_a(Hand.MAIN_HAND);
        }
        return flag;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason != SpawnReason.SPAWN_EGG && reason != SpawnReason.BUCKET && reason != SpawnReason.CONVERSION && reason != SpawnReason.COMMAND && this.func_70681_au().nextInt(50) == 0) {
            this.func_184201_a(EquipmentSlotType.HEAD, HunterVillageData.createBanner());
        }
        ILivingEntityData livingData = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.func_70681_au().nextInt(4) == 0) {
            this.func_184641_n(true);
            SimpleCrossbowItem crossBow = this.getLevel() > 1 ? ModItems.enhanced_crossbow : ModItems.basic_crossbow;
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)crossBow));
        } else {
            this.func_184641_n(false);
        }
        this.updateCombatTask();
        return livingData;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    public float getTargetAngle() {
        return this.targetAngle;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public int getEntityTextureType() {
        return Math.max(0, (Integer)this.func_184212_Q().func_187225_a(TYPE));
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isLookingForHome() {
        return this.getHome() == null;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 3) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 1));
            }
        }
    }

    @Override
    public boolean isCrossbowInMainhand() {
        return !this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() instanceof VampirismItemCrossbow;
    }

    @Override
    public void makeNormalHunter() {
        super.setHome(null);
        this.disableMoveTowardsRestriction();
    }

    @Override
    public void makeVillageHunter(AxisAlignedBB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.func_184212_Q().func_187225_a(SWINGING_ARMS);
    }

    private void setSwingingArms(boolean b) {
        this.func_184212_Q().func_187227_b(SWINGING_ARMS, (Object)b);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(TYPE) == -1) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)this.func_70681_au().nextInt(126));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("crossbow") && tagCompund.func_74767_n("crossbow")) {
            this.func_184641_n(true);
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.basic_crossbow));
        } else {
            this.func_184641_n(false);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
        this.updateCombatTask();
        if (tagCompund.func_74764_b("attack")) {
            this.attack = tagCompund.func_74767_n("attack");
        }
        if (tagCompund.func_74764_b("type")) {
            int t = tagCompund.func_74762_e("type");
            this.func_184212_Q().func_187227_b(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    @Override
    public void startTargeting() {
        this.setSwingingArms(true);
    }

    @Override
    public void stopTargeting() {
        this.setSwingingArms(false);
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_200203_b(null);
        this.villageAttributes = null;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return super.func_213397_c(distanceToClosestPlayer) && this.getHome() != null;
    }

    @Override
    public int suggestLevel(Difficulty d) {
        switch (this.field_70146_Z.nextInt(6)) {
            case 0: {
                return (int)((float)d.minPercLevel / 100.0f * 3.0f);
            }
            case 1: {
                return (int)((float)d.avgPercLevel / 100.0f * 3.0f);
            }
            case 2: {
                return (int)((float)d.maxPercLevel / 100.0f * 3.0f);
            }
        }
        return this.field_70146_Z.nextInt(4);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(SWINGING_ARMS, (Object)false);
        this.func_184212_Q().func_187214_a(WATCHED_ID, (Object)0);
        this.func_184212_Q().func_187214_a(TYPE, (Object)-1);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 6 + this.getLevel();
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? ModEntities.hunter_imob : ModEntities.hunter;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND && this.tryCureSanguinare(player)) {
            return ActionResultType.SUCCESS;
        }
        int hunterLevel = VampirismPlayerAttributes.get((PlayerEntity)player).hunterLevel;
        if (this.func_70089_S() && !player.func_225608_bj_() && hand == Hand.MAIN_HAND && !this.field_70170_p.field_72995_K) {
            if (HunterLevelingConf.instance().isLevelValidForBasicHunter(hunterLevel + 1)) {
                if (this.trainee == null) {
                    player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerEntity) -> new HunterBasicContainer(id, playerInventory, this), name));
                    this.trainee = player;
                    this.func_70661_as().func_75499_g();
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.i_am_busy_right_now"), Util.field_240973_b_);
                }
                return ActionResultType.SUCCESS;
            }
            if (hunterLevel > 0) {
                FactionPlayerHandler.getOpt(player).ifPresent(fph -> {
                    if (fph.getMaxMinions() > 0) {
                        ItemStack heldItem = player.func_184586_b(hand);
                        if (this.getLevel() > 0) {
                            if (heldItem.func_77973_b() == ModItems.hunter_minion_equipment) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_hunter.minion.unavailable"), true);
                            }
                        } else {
                            boolean freeSlot = MinionWorldData.getData(player.field_70170_p).map(data -> data.getOrCreateController((FactionPlayerHandler)fph)).map(PlayerMinionController::hasFreeMinionSlot).orElse(false);
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_hunter.minion.available"), false);
                            if (heldItem.func_77973_b() == ModItems.hunter_minion_equipment) {
                                if (!freeSlot) {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_hunter.minion.no_free_slot"), false);
                                } else {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_hunter.minion.start_serving"), false);
                                    this.convertToMinion(player);
                                    if (!player.field_71075_bZ.field_75098_d) {
                                        heldItem.func_190918_g(1);
                                    }
                                }
                            } else if (freeSlot) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_hunter.minion.require_equipment", new Object[]{UtilLib.translate(ModItems.hunter_minion_equipment.func_77658_a(), new Object[0])}), false);
                            }
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.basic_hunter.cannot_train_you_any_further"), false);
                    }
                });
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(3, new ForceLookEntityGoal<BasicHunterEntity>(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, (double)0.7f, false, 300, () -> false));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7, 50));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 13.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, VampireBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AttackVillageGoal<BasicHunterEntity>(this));
        this.field_70715_bh.func_75776_a(2, new DefendVillageGoal<BasicHunterEntity>(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<CreatureEntity>((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double func_111175_f() {
                return super.func_111175_f() / 2.0;
            }
        });
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, true, true));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, Structure.field_236381_q_)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233818_a_);
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance.func_111128_a(30.0 + BalanceMobProps.mobProps.VAMPIRE_HUNTER_MAX_HEALTH_PL * (double)l);
        ModifiableAttributeInstance modifiableAttributeInstance2 = this.func_110148_a(Attributes.field_233823_f_);
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance2.func_111128_a(3.0 + BalanceMobProps.mobProps.VAMPIRE_HUNTER_ATTACK_DAMAGE_PL * (double)l);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    private int getWatchedId() {
        return (Integer)this.func_184212_Q().func_187225_a(WATCHED_ID);
    }

    private void updateCombatTask() {
        this.field_70714_bg.func_85156_a((Goal)this.attackMelee);
        this.field_70714_bg.func_85156_a(this.attackRange);
        ItemStack stack = this.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof VampirismItemCrossbow) {
            this.field_70714_bg.func_75776_a(2, this.attackRange);
        } else {
            this.field_70714_bg.func_75776_a(2, (Goal)this.attackMelee);
        }
    }

    private void updateWatchedId(int id) {
        this.func_184212_Q().func_187227_b(WATCHED_ID, (Object)id);
    }

    public static class IMob
    extends BasicHunterEntity
    implements net.minecraft.entity.monster.IMob {
        public IMob(EntityType<? extends BasicHunterEntity> type, World world) {
            super(type, world);
        }
    }
}

