/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerMinionController
implements INBTSerializable<CompoundNBT> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Random rng = new Random();
    @Nonnull
    private final MinecraftServer server;
    @Nonnull
    private final UUID lordID;
    private int maxMinions;
    @Nullable
    private IPlayableFaction<?> faction;
    @Nonnull
    private MinionInfo[] minions = new MinionInfo[0];
    @Nonnull
    private Optional<Integer>[] minionTokens = new Optional[0];

    public static List<IMinionTask<?, ?>> getAvailableTasks(ILordPlayer player) {
        return ModRegistries.MINION_TASKS.getValues().stream().filter(t -> t.isAvailable(player.getLordFaction(), player)).collect(Collectors.toList());
    }

    public PlayerMinionController(@Nonnull MinecraftServer server, @Nonnull UUID lordID) {
        this.server = server;
        this.lordID = lordID;
    }

    public void activateTask(int minionID, IMinionTask<?, MinionData> task) {
        if (minionID >= this.minions.length) {
            LOGGER.warn("Trying to activate a task for a non-existent minion {}", (Object)minionID);
        } else if (minionID < 0) {
            for (MinionInfo i : this.minions) {
                if (i.data.isTaskLocked()) continue;
                this.activateTask(i, task);
            }
        } else {
            this.activateTask(this.minions[minionID], task);
        }
    }

    public void checkInMinion(int id, int token) {
        MinionInfo i = this.getMinionInfo(id, token);
        if (i != null) {
            i.checkin();
        }
    }

    @Nullable
    public <T extends MinionData> T checkoutMinion(int id, int token, MinionEntity<T> entity) {
        RegistryKey dimension;
        int entityId;
        MinionInfo i = this.getMinionInfo(id, token);
        if (i != null && i.checkout(entityId = entity.func_145782_y(), (RegistryKey<World>)(dimension = entity.field_70170_p.func_234923_W_()))) {
            return (T)i.data;
        }
        return null;
    }

    public Optional<Integer> claimMinionSlot(int id) {
        if (id < this.minionTokens.length && !this.minionTokens[id].isPresent() && !this.minions[id].isStillRecovering()) {
            int t = this.rng.nextInt();
            this.minionTokens[id] = Optional.of(t);
            return this.minionTokens[id];
        }
        return Optional.empty();
    }

    public void contactMinion(int slot, Consumer<MinionEntity<?>> entityConsumer) {
        if (slot < this.minions.length) {
            this.getMinionEntity(this.minions[slot]).ifPresent(entityConsumer);
        }
    }

    public <T> Optional<T> contactMinionData(int id, Function<MinionData, T> function) {
        if (id >= 0 && id < this.minions.length) {
            return Optional.of(function.apply(this.minions[id].data));
        }
        return Optional.empty();
    }

    public void contactMinions(Consumer<MinionEntity<?>> entityConsumer) {
        for (MinionInfo m : this.minions) {
            this.getMinionEntity(m).ifPresent(entityConsumer);
        }
    }

    @Nullable
    public MinionEntity<?> createMinionEntityAtPlayer(int id, PlayerEntity p) {
        assert (id >= 0);
        EntityType<? extends MinionEntity<?>> type = this.minions[id].minionType;
        if (type != null) {
            return Helper.createEntity(type, p.func_130014_f_()).map(m -> {
                if (this.faction == null || this.faction.isEntityOfFaction((CreatureEntity)m)) {
                    LOGGER.warn("Specified minion entity is of wrong faction. This: {} Minion: {}", this.faction, (Object)m.getFaction());
                    m.func_70106_y();
                    return null;
                }
                m.claimMinionSlot(id, this);
                m.func_82149_j((Entity)p);
                p.field_70170_p.func_217376_c((Entity)m);
                this.activateTask(id, MinionTasks.stay);
                return m;
            }).orElse(null);
        }
        LOGGER.warn("Cannot create minion because type does not exist");
        return null;
    }

    public int createNewMinionSlot(MinionData data, EntityType<? extends MinionEntity<?>> minionType) {
        int i = this.minions.length;
        if (i < this.maxMinions) {
            MinionInfo[] n = Arrays.copyOf(this.minions, i + 1);
            Optional<Integer>[] t = Arrays.copyOf(this.minionTokens, i + 1);
            n[i] = new MinionInfo(i, data, minionType);
            t[i] = Optional.empty();
            this.minions = n;
            this.minionTokens = t;
            return i;
        }
        return -1;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        IFaction f = VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(nbt.func_74779_i("faction")));
        if (!(f instanceof IPlayableFaction)) {
            this.maxMinions = 0;
            return;
        }
        this.faction = (IPlayableFaction)f;
        this.maxMinions = nbt.func_74762_e("max_minions");
        ListNBT data = nbt.func_150295_c("data", 10);
        MinionInfo[] infos = new MinionInfo[data.size()];
        Optional[] tokens = new Optional[data.size()];
        for (INBT n : data) {
            CompoundNBT tag = (CompoundNBT)n;
            int id = tag.func_74762_e("id");
            MinionData d = MinionData.fromNBT(tag);
            ResourceLocation entityTypeID = new ResourceLocation(tag.func_74779_i("entity_type"));
            if (!ForgeRegistries.ENTITIES.containsKey(entityTypeID)) {
                LOGGER.warn("Cannot find saved minion type {}. Aborting controller load", (Object)entityTypeID);
                this.minions = new MinionInfo[0];
                this.minionTokens = new Optional[0];
                return;
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(entityTypeID);
            MinionInfo i = new MinionInfo(id, d, type);
            i.deathCooldown = tag.func_74762_e("death_timer");
            infos[id] = i;
            if (tag.func_150297_b("token", 99)) {
                tokens[id] = Optional.of(tag.func_74762_e("token"));
                continue;
            }
            tokens[id] = Optional.empty();
        }
        this.minions = infos;
        this.minionTokens = tokens;
    }

    public Collection<Integer> getCallableMinions() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < this.minions.length; ++i) {
            if (this.minions[i].isStillRecovering()) continue;
            ids.add(i);
        }
        return ids;
    }

    public List<IFormattableTextComponent> getRecoveringMinionNames() {
        return Arrays.stream(this.minions).filter(MinionInfo::isStillRecovering).map(i -> i.data).map(MinionData::getFormattedName).collect(Collectors.toList());
    }

    public UUID getUUID() {
        return this.lordID;
    }

    public Collection<Integer> getUnclaimedMinions() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < this.minionTokens.length; ++i) {
            if (this.minionTokens[i].isPresent() || this.minions[i].isStillRecovering()) continue;
            ids.add(i);
        }
        return ids;
    }

    public boolean hasFreeMinionSlot() {
        return this.minions.length < this.maxMinions;
    }

    public boolean hasMinions() {
        return this.minions.length > 0;
    }

    public void markDeadAndReleaseMinionSlot(int id, int token) {
        MinionInfo i = this.getMinionInfo(id, token);
        if (i != null) {
            i.checkin();
            i.deathCooldown = 20 * (Integer)VampirismConfig.BALANCE.miDeathRecoveryTime.get();
            if (id < this.minionTokens.length) {
                this.minionTokens[id] = Optional.empty();
            }
        }
    }

    public boolean recallMinion(int id) {
        if (id >= 0 && id < this.minions.length) {
            return this.recallMinion(this.minions[id]);
        }
        return false;
    }

    public Collection<Integer> recallMinions(boolean force) {
        ArrayList<Integer> ids = new ArrayList<Integer>(this.minions.length);
        for (MinionInfo minion : this.minions) {
            if (!force && minion.data.isTaskLocked() || !this.recallMinion(minion)) continue;
            ids.add(minion.minionID);
        }
        return ids;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("max_minions", this.maxMinions);
        if (this.faction != null) {
            nbt.func_74778_a("faction", this.faction.getID().toString());
        }
        ListNBT data = new ListNBT();
        for (MinionInfo i : this.minions) {
            CompoundNBT d = i.data.serializeNBT();
            d.func_74768_a("death_timer", i.deathCooldown);
            d.func_74768_a("id", i.minionID);
            if (i.minionType != null) {
                d.func_74778_a("entity_type", i.minionType.getRegistryName().toString());
            }
            this.minionTokens[i.minionID].ifPresent(t -> d.func_74768_a("token", t.intValue()));
            data.add((Object)d);
        }
        nbt.func_218657_a("data", (INBT)data);
        return nbt;
    }

    public void setMaxMinions(@Nullable IPlayableFaction<?> faction, int newCount) {
        assert (newCount >= 0);
        if (this.faction != null && faction != this.faction) {
            LOGGER.warn("Changing player minion controller faction");
            this.contactMinions(MinionEntity::recallMinion);
            this.minions = new MinionInfo[0];
            this.minionTokens = new Optional[0];
            this.faction = faction;
            this.maxMinions = this.faction == null ? 0 : newCount;
        } else {
            this.faction = faction;
            if (newCount >= this.maxMinions) {
                this.maxMinions = newCount;
            } else {
                LOGGER.debug("Reducing minion count from {} to {}", (Object)this.maxMinions, (Object)newCount);
                while (this.minions.length > newCount) {
                    int nL = this.minions.length - 1;
                    this.contactMinion(nL, MinionEntity::recallMinion);
                    MinionInfo[] n = Arrays.copyOf(this.minions, nL);
                    Optional<Integer>[] t = Arrays.copyOf(this.minionTokens, nL);
                    this.minions = n;
                    this.minionTokens = t;
                }
            }
        }
    }

    public void tick() {
        for (MinionInfo i : this.minions) {
            if (i.deathCooldown > 0) {
                --i.deathCooldown;
                if (i.deathCooldown != 0) continue;
                i.data.setHealth(i.data.getMaxHealth());
                this.getLordPlayer().ifPresent(player -> player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.minion.can_respawn", new Object[]{i.data.getFormattedName()}), true));
                continue;
            }
            IMinionTask.IMinionTaskDesc<MinionData> taskDesc = i.data.getCurrentTaskDesc();
            this.tickTask(taskDesc.getTask(), taskDesc, i);
        }
    }

    private void activateTask(MinionInfo info, IMinionTask<?, MinionData> task) {
        Object desc = task.activateTask(this.getLordPlayer().orElse(null), this.getMinionEntity(info).orElse(null), info.data);
        if (desc == null) {
            this.getLordPlayer().ifPresent(player -> player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.minion.could_not_activate"), false));
        } else {
            MinionData d = info.data;
            d.switchTask(d.getCurrentTaskDesc().getTask(), d.getCurrentTaskDesc(), (IMinionTask.IMinionTaskDesc<MinionData>)desc);
            this.contactMinion(info.minionID, MinionEntity::onTaskChanged);
        }
    }

    private Optional<ILordPlayer> getLord() {
        return this.getLordPlayer().map(FactionPlayerHandler::get);
    }

    private Optional<PlayerEntity> getLordPlayer() {
        return Optional.ofNullable(this.server.func_184103_al().func_177451_a(this.lordID));
    }

    private Optional<MinionEntity<?>> getMinionEntity(MinionInfo info) {
        if (info.isActive()) {
            assert (info.dimension != null);
            ServerWorld w = this.server.func_71218_a(info.dimension);
            if (w != null) {
                Entity e = w.func_73045_a(info.entityId);
                if (e instanceof MinionEntity) {
                    return Optional.of((MinionEntity)e);
                }
                LOGGER.warn("Retrieved entity is not a minion entity {}", (Object)e);
            }
        }
        return Optional.empty();
    }

    @Nullable
    private MinionInfo getMinionInfo(int id, int token) {
        assert (this.minions.length == this.minionTokens.length);
        if (id < this.minions.length && this.minionTokens[id].map(t -> t == token).orElse(false).booleanValue()) {
            return this.minions[id];
        }
        return null;
    }

    private boolean recallMinion(MinionInfo i) {
        this.contactMinion(i.minionID, MinionEntity::recallMinion);
        if (i.isActive()) {
            LOGGER.debug("Minion still active after recall");
        }
        this.minionTokens[i.minionID] = Optional.empty();
        return !i.isStillRecovering();
    }

    private <Q extends IMinionTask.IMinionTaskDesc<MinionData>, T extends IMinionTask<Q, MinionData>> void tickTask(T task, IMinionTask.IMinionTaskDesc<MinionData> desc, MinionInfo info) {
        if (info.isActive()) {
            task.tickActive(desc, () -> this.getMinionEntity(info).map(m -> m), (MinionData)info.data);
        } else {
            task.tickBackground(desc, (MinionData)info.data);
        }
    }

    private static class MinionInfo {
        final int minionID;
        @Nonnull
        final MinionData data;
        @Nullable
        final EntityType<? extends MinionEntity<?>> minionType;
        int entityId = -1;
        int deathCooldown = 0;
        @Nullable
        RegistryKey<World> dimension;

        private MinionInfo(int id, @Nonnull MinionData data, @Nullable EntityType<? extends MinionEntity<?>> minionType) {
            this.minionID = id;
            this.data = data;
            this.minionType = minionType;
        }

        void checkin() {
            if (this.entityId == -1) {
                LOGGER.debug("Closing minion data for inactive minion");
            }
            this.entityId = -1;
            this.dimension = null;
        }

        boolean checkout(int entityId, RegistryKey<World> dim) {
            if (this.entityId != -1 || this.isStillRecovering()) {
                return false;
            }
            this.entityId = entityId;
            this.dimension = dim;
            return true;
        }

        boolean isActive() {
            return this.entityId != -1;
        }

        boolean isStillRecovering() {
            return this.deathCooldown > 0;
        }
    }
}

