/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.vampire.IAdvancedVampire;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.goals.FleeGarlicVampireGoal;
import de.teamlapen.vampirism.entity.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import de.teamlapen.vampirism.util.SupporterManager;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedVampireEntity
extends VampireBaseEntity
implements IAdvancedVampire,
IPlayerOverlay,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(AdvancedVampireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(AdvancedVampireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(AdvancedVampireEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(AdvancedVampireEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private final int MAX_LEVEL = 1;
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    private final EntityActionTier entitytier;
    private int followingEntities = 0;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Pair<ResourceLocation, Boolean> skinDetails;
    @Nullable
    private String lootBookId;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampireBaseEntity.getAttributeBuilder().func_233815_a_(Attributes.field_233818_a_, (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        BalanceMobProps.mobProps.getClass();
        AttributeModifierMap.MutableAttribute mutableAttribute2 = mutableAttribute.func_233815_a_(Attributes.field_233823_f_, 7.0);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute2.func_233815_a_(Attributes.field_233821_d_, 0.285).func_233815_a_(Attributes.field_233819_b_, 13.0);
    }

    public AdvancedVampireEntity(EntityType<? extends AdvancedVampireEntity> type, World world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.High;
        this.entityclass = EntityClassType.getRandomClass(this.func_70681_au());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<AdvancedVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getEyeType());
        nbt.func_74778_a("texture", (String)this.func_184212_Q().func_187225_a(TEXTURE));
        nbt.func_74778_a("name", (String)this.func_184212_Q().func_187225_a(NAME));
        nbt.func_74768_a("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
        nbt.func_74757_a("attack", this.attack);
        if (this.lootBookId != null) {
            nbt.func_74778_a("lootBookId", this.lootBookId);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.villageAttributes = totem;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity getActionHandler() {
        return this.entityActionHandler;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    public Optional<String> getBookLootId() {
        return Optional.ofNullable(this.lootBookId);
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public int getEyeType() {
        return (Integer)this.func_184212_Q().func_187225_a(TYPE);
    }

    @Override
    public int getFollowingCount() {
        return this.followingEntities;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 0));
            }
        }
    }

    @Override
    public int getMaxFollowerCount() {
        return BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        String senderName = (String)this.func_184212_Q().func_187225_a(NAME);
        return "none".equals(senderName) ? super.func_200200_C_() : new StringTextComponent(senderName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Optional<Pair<ResourceLocation, Boolean>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            String name = this.getTextureName();
            if (name == null) {
                return Optional.empty();
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerSkinHelper.obtainPlayerSkinPropertiesAsync(new GameProfile(null, name), p -> {
                this.skinDetails = p;
            }));
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.func_184212_Q().func_187225_a(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        boolean flag = super.func_70097_a(damageSource, amount);
        if (flag && damageSource.func_76346_g() instanceof PlayerEntity && this.field_70146_Z.nextInt(4) == 0) {
            this.func_195064_c(new EffectInstance(ModEffects.sunscreen, 150, 2));
        }
        return flag;
    }

    @Override
    public void func_70037_a(CompoundNBT tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("type")) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)tagCompund.func_74762_e("type"));
            this.func_184212_Q().func_187227_b(NAME, (Object)tagCompund.func_74779_i("name"));
            this.func_184212_Q().func_187227_b(TEXTURE, (Object)tagCompund.func_74779_i("texture"));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
        if (tagCompund.func_74764_b("attack")) {
            this.attack = tagCompund.func_74767_n("attack");
        }
        if (tagCompund.func_74764_b("lootBookId")) {
            this.lootBookId = tagCompund.func_74779_i("lootBookId");
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_200203_b(null);
        this.villageAttributes = null;
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Override
    public int suggestLevel(Difficulty d) {
        if (this.field_70146_Z.nextBoolean()) {
            return (int)((float)(d.avgPercLevel * 1) / 100.0f);
        }
        return this.field_70146_Z.nextInt(2);
    }

    @Override
    protected float calculateFireDamage(float amount) {
        double d = amount;
        BalanceMobProps.mobProps.getClass();
        return (float)(d * 3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        SupporterManager.Supporter supporter = SupporterManager.getInstance().getRandomVampire(this.field_70146_Z);
        this.lootBookId = supporter.bookID;
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(TYPE, (Object)supporter.typeId);
        this.func_184212_Q().func_187214_a(NAME, (Object)(supporter.senderName == null ? "none" : supporter.senderName));
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)(supporter.textureName == null ? "none" : supporter.textureName));
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? ModEntities.advanced_vampire_imob : ModEntities.advanced_vampire;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 10 * (1 + this.getLevel());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakDoorGoal((MobEntity)this, difficulty -> difficulty == net.minecraft.world.Difficulty.HARD));
        this.field_70714_bg.func_75776_a(2, new RestrictSunVampireGoal<AdvancedVampireEntity>(this));
        this.field_70714_bg.func_75776_a(3, new FleeSunVampireGoal<AdvancedVampireEntity>(this, 0.9, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeGarlicVampireGoal(this, 0.9, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.9, 25));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 13.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AttackVillageGoal<AdvancedVampireEntity>(this));
        this.field_70715_bh.func_75776_a(2, new DefendVillageGoal<AdvancedVampireEntity>(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, Structure.field_236381_q_)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        Objects.requireNonNull(this.func_110148_a(Attributes.field_233818_a_)).func_111128_a((double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION + BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_HEALTH_PL * (double)l);
        BalanceMobProps.mobProps.getClass();
        Objects.requireNonNull(this.func_110148_a(Attributes.field_233823_f_)).func_111128_a(7.0 + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)l);
    }

    public static class IMob
    extends AdvancedVampireEntity
    implements net.minecraft.entity.monster.IMob {
        public IMob(EntityType<? extends AdvancedVampireEntity> type, World world) {
            super(type, world);
        }
    }
}

