/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.IDefaultTaskMasterEntity;
import de.teamlapen.vampirism.entity.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampireTaskMasterEntity
extends VampireBaseEntity
implements IDefaultTaskMasterEntity {
    private static final DataParameter<String> BIOME_TYPE = EntityDataManager.func_187226_a(VampireTaskMasterEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    @Nullable
    private PlayerEntity interactor;

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampireBaseEntity.getAttributeBuilder();
        BalanceMobProps.mobProps.getClass();
        AttributeModifierMap.MutableAttribute mutableAttribute2 = mutableAttribute.func_233815_a_(Attributes.field_233818_a_, 30.0);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute2.func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, BalanceMobProps.mobProps.VAMPIRE_SPEED);
    }

    public VampireTaskMasterEntity(EntityType<? extends VampireBaseEntity> type, World world) {
        super(type, world, false);
        this.peaceful = true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!(this.interactor == null || this.interactor.func_70089_S() && this.interactor.field_71070_bA instanceof TaskBoardContainer)) {
            this.interactor = null;
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBiomeType(VillagerType.func_242371_a((Optional)worldIn.func_242406_i(this.func_233580_cy_())));
        return data;
    }

    @Override
    public VillagerType getBiomeType() {
        String key = (String)this.field_70180_af.func_187225_a(BIOME_TYPE);
        ResourceLocation id = new ResourceLocation(key);
        return (VillagerType)Registry.field_218369_K.func_82594_a(id);
    }

    protected void setBiomeType(VillagerType type) {
        this.field_70180_af.func_187227_b(BIOME_TYPE, (Object)Registry.field_218369_K.func_177774_c((Object)type).toString());
    }

    @Override
    @Nonnull
    public Optional<PlayerEntity> getForceLookTarget() {
        return Optional.ofNullable(this.interactor);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return Helper.isVampire((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BIOME_TYPE, (Object)Registry.field_218369_K.func_212609_b().toString());
    }

    protected ActionResultType func_230254_b_(@Nonnull PlayerEntity playerEntity, @Nonnull Hand hand) {
        if (this.field_70170_p.field_72995_K) {
            return Helper.isVampire(playerEntity) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        if (Helper.isVampire(playerEntity) && this.interactor == null) {
            if (this.processInteraction(playerEntity, (Entity)this)) {
                this.func_70661_as().func_75499_g();
                this.interactor = playerEntity;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, CreatureEntity.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        this.field_70714_bg.func_75776_a(2, new RestrictSunVampireGoal<VampireTaskMasterEntity>(this));
        this.field_70714_bg.func_75776_a(2, new ForceLookEntityGoal<VampireTaskMasterEntity>(this));
        this.field_70714_bg.func_75776_a(3, new FleeSunVampireGoal<VampireTaskMasterEntity>(this, 0.9, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, true, 600, () -> false));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }
}

