/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.HunterTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.HunterIntelItem;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.IContainerFactory;

public class HunterTableContainer
extends InventoryContainer
implements IInventoryChangedListener {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(Items.field_151122_aG, 15, 28), new InventoryContainer.SelectorInfo(ModItems.vampire_fang, 42, 28), new InventoryContainer.SelectorInfo((ITag<Item>)ModTags.Items.PURE_BLOOD, 69, 28), new InventoryContainer.SelectorInfo(ModItems.vampire_book, 96, 28)};
    private final SlotResult slotResult;
    private final int hunterLevel;
    private final HunterLevelingConf levelingConf = HunterLevelingConf.instance();
    private ItemStack missing = ItemStack.field_190927_a;

    public HunterTableContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super(ModContainer.hunter_table, id, playerInventory, worldPosCallable, (IInventory)new Inventory(SELECTOR_INFOS.length), SELECTOR_INFOS);
        ((Inventory)this.inventory).func_110134_a((IInventoryChangedListener)this);
        this.slotResult = new SlotResult(this, (IInventory)new CraftResultInventory(){

            public int func_70297_j_() {
                return 1;
            }
        }, 4, 146, 28);
        this.func_75146_a(this.slotResult);
        this.hunterLevel = FactionPlayerHandler.get(playerInventory.field_70458_d).getCurrentLevel(VReference.HUNTER_FACTION);
        this.addPlayerSlots(playerInventory);
    }

    public void func_76316_a(IInventory invBasic) {
        this.func_75130_a(invBasic);
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean isLevelValid(boolean considerTier) {
        return considerTier ? this.levelingConf.isLevelValidForTableTier(this.hunterLevel + 1, this.worldPos.func_221484_a((world, blockPos) -> {
            BlockState state = world.func_180495_p(blockPos);
            return state.func_235901_b_(HunterTableBlock.VARIANT) ? ((HunterTableBlock.TABLE_VARIANT)((Object)((Object)state.func_177229_b(HunterTableBlock.VARIANT)))).tier : 0;
        }).orElse(0)) : this.levelingConf.isLevelValidForTable(this.hunterLevel + 1);
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, this.inventory);
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.isLevelValid(true)) {
            int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
            this.missing = this.checkItems(req[0], req[1], req[2], req[3]);
            if (this.missing.func_190926_b()) {
                this.slotResult.field_75224_c.func_70299_a(0, new ItemStack((IItemProvider)HunterIntelItem.getIntelForExactlyLevel(this.hunterLevel + 1)));
            } else {
                this.slotResult.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return HunterTableContainer.func_216963_a((IWorldPosCallable)this.worldPos, (PlayerEntity)playerIn, (Block)ModBlocks.hunter_table);
    }

    protected void onPickupResult() {
        int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
        InventoryHelper.removeItems(this.inventory, new int[]{1, req[0], req[1], req[3]});
    }

    private ItemStack checkItems(int fangs, int blood, int bloodLevel, int par3) {
        return InventoryHelper.checkItems(this.inventory, new Item[]{Items.field_151122_aG, ModItems.vampire_fang, PureBloodItem.getBloodItemForLevel(bloodLevel), ModItems.vampire_book}, new int[]{1, fangs, blood, par3});
    }

    private static class SlotResult
    extends Slot {
        private final HunterTableContainer hunterTableContainer;

        public SlotResult(HunterTableContainer container, IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
            this.hunterTableContainer = container;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(PlayerEntity playerIn, ItemStack stack) {
            this.hunterTableContainer.onPickupResult();
            return stack;
        }
    }

    public static class Factory
    implements IContainerFactory<HunterTableContainer> {
        public HunterTableContainer create(int windowId, PlayerInventory inv, PacketBuffer data) {
            BlockPos pos = data.func_179259_c();
            return new HunterTableContainer(windowId, inv, IWorldPosCallable.func_221488_a((World)inv.field_70458_d.field_70170_p, (BlockPos)pos));
        }
    }
}

