/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.items.HunterIntelItem;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class HunterTrainerContainer
extends InventoryContainer
implements IInventoryChangedListener {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(Items.field_151042_j, 27, 26), new InventoryContainer.SelectorInfo(Items.field_151043_k, 57, 26), new InventoryContainer.SelectorInfo((ITag<Item>)ModTags.Items.HUNTER_INTEL, 86, 26)};
    private final PlayerEntity player;
    @Nullable
    private final HunterTrainerEntity entity;
    private boolean changed = false;
    private ItemStack missing = ItemStack.field_190927_a;

    @Deprecated
    public HunterTrainerContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterTrainerContainer(int id, PlayerInventory playerInventory, @Nullable HunterTrainerEntity trainer) {
        super(ModContainer.hunter_trainer, id, playerInventory, trainer == null ? IWorldPosCallable.field_221489_a : IWorldPosCallable.func_221488_a((World)trainer.field_70170_p, (BlockPos)trainer.func_233580_cy_()), (IInventory)new Inventory(SELECTOR_INFOS.length), SELECTOR_INFOS);
        ((Inventory)this.inventory).func_110134_a((IInventoryChangedListener)this);
        this.player = playerInventory.field_70458_d;
        this.addPlayerSlots(playerInventory);
        this.entity = trainer;
    }

    public void func_76316_a(IInventory iInventory) {
        this.changed = true;
    }

    public boolean canLevelup() {
        int targetLevel = FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION) + 1;
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        if (levelingConf.isLevelValidForTrainer(targetLevel) != 0) {
            return false;
        }
        int[] req = levelingConf.getItemRequirementsForTrainer(targetLevel);
        int level = levelingConf.getHunterIntelMetaForLevel(targetLevel);
        this.missing = InventoryHelper.checkItems(this.inventory, new Item[]{Items.field_151042_j, Items.field_151043_k, HunterIntelItem.getIntelForLevel(level)}, new int[]{req[0], req[1], 1}, (supplied, required) -> supplied.equals(required) || supplied instanceof HunterIntelItem && required instanceof HunterIntelItem && ((HunterIntelItem)((Object)supplied)).getLevel() >= ((HunterIntelItem)((Object)required)).getLevel());
        return this.missing.func_190926_b();
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean hasChanged() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public void onLevelupClicked() {
        if (this.canLevelup()) {
            int old = FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION);
            FactionPlayerHandler.get(this.player).setFactionLevel(VReference.HUNTER_FACTION, old + 1);
            int[] req = HunterLevelingConf.instance().getItemRequirementsForTrainer(old + 1);
            InventoryHelper.removeItems(this.inventory, new int[]{req[0], req[1], 1});
            this.player.func_195064_c(new EffectInstance(ModEffects.saturation, 400, 2));
            this.changed = true;
        }
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            this.func_193327_a(playerIn, playerIn.func_130014_f_(), this.inventory);
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        if (this.entity == null) {
            return false;
        }
        return new Vector3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()).func_72438_d(new Vector3d(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_())) < 5.0;
    }
}

