/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import com.google.common.base.Predicates;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.network.SelectMinionTaskPacket;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.IContainerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinionContainer
extends InventoryContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MinionEntity<?> minionEntity;
    @Nonnull
    private final IMinionTask<?, ?>[] availableTasks;
    @Nullable
    private final IMinionTask<?, ?> previousTask;
    private final boolean previousTaskLocked;
    private final int extraSlots;
    @Nullable
    private IMinionTask<?, ?> taskToActivate;
    private boolean taskLocked;

    @Nullable
    public static MinionContainer create(int id, PlayerInventory playerInventory, MinionEntity<?> minionEntity) {
        Optional<IMinionInventory> minionInv = minionEntity.getInventory();
        return minionInv.map(inv -> new MinionContainer(id, playerInventory, minionEntity, (IInventory)inv, inv.getAvailableSize(), MinionContainer.createSelectors(minionEntity, inv.getAvailableSize()))).orElse(null);
    }

    private static InventoryContainer.SelectorInfo[] createSelectors(MinionEntity<?> minionEntity, int extraSlots) {
        InventoryContainer.SelectorInfo[] slots = new InventoryContainer.SelectorInfo[6 + extraSlots];
        slots[0] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlotType.MAINHAND).and(stack -> stack.canEquip(EquipmentSlotType.MAINHAND, (Entity)minionEntity)), 7, 60, false, 1, null);
        slots[1] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlotType.OFFHAND).and(stack -> stack.canEquip(EquipmentSlotType.OFFHAND, (Entity)minionEntity) || stack.func_77975_n() == UseAction.DRINK || stack.func_77975_n() == UseAction.EAT), 7, 78, false, 5, null);
        slots[2] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlotType.FEET).and(stack -> stack.canEquip(EquipmentSlotType.FEET, (Entity)minionEntity)), 81, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226619_g_));
        slots[3] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlotType.LEGS).and(stack -> stack.canEquip(EquipmentSlotType.LEGS, (Entity)minionEntity)), 63, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226618_f_));
        slots[4] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlotType.CHEST).and(stack -> stack.canEquip(EquipmentSlotType.CHEST, (Entity)minionEntity)), 45, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226617_e_));
        slots[5] = new InventoryContainer.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlotType.HEAD).and(stack -> stack.canEquip(EquipmentSlotType.HEAD, (Entity)minionEntity)), 27, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226616_d_));
        assert (extraSlots == 9 || extraSlots == 12 || extraSlots == 15) : "Minion inventory has unexpected size";
        for (int i = 0; i < extraSlots; ++i) {
            slots[6 + i] = new InventoryContainer.SelectorInfo((Predicate<ItemStack>)Predicates.alwaysTrue(), 27 + 18 * (i / 3), 42 + 18 * (i % 3));
        }
        return slots;
    }

    public MinionContainer(int id, PlayerInventory playerInventory, MinionEntity<?> minionEntity, @Nonnull IInventory inventory, int extraSlots, InventoryContainer.SelectorInfo ... selectorInfos) {
        super(ModContainer.minion, id, playerInventory, IWorldPosCallable.func_221488_a((World)minionEntity.field_70170_p, (BlockPos)minionEntity.func_233580_cy_()), inventory, selectorInfos);
        this.minionEntity = minionEntity;
        this.extraSlots = extraSlots;
        this.availableTasks = this.minionEntity.getAvailableTasks().toArray(new IMinionTask[0]);
        this.minionEntity.setInteractingPlayer(playerInventory.field_70458_d);
        this.addPlayerSlots(playerInventory, 27, 103);
        this.previousTask = this.minionEntity.getCurrentTask().map(IMinionTask.IMinionTaskDesc::getTask).orElse(null);
        this.previousTaskLocked = this.taskLocked = this.minionEntity.isTaskLocked();
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (this.minionEntity.field_70170_p.func_201670_d()) {
            this.sendChanges();
        }
        this.minionEntity.setInteractingPlayer(null);
    }

    @Nonnull
    public IMinionTask<?, ?>[] getAvailableTasks() {
        return this.availableTasks;
    }

    public int getExtraSlots() {
        return this.extraSlots;
    }

    public Optional<IMinionTask<?, ?>> getPreviousTask() {
        return Optional.ofNullable(this.previousTask);
    }

    @Nonnull
    public IMinionTask<?, ?> getSelectedTask() {
        return this.taskToActivate != null ? this.taskToActivate : (this.previousTask != null ? this.previousTask : MinionTasks.stay);
    }

    public boolean isTaskLocked() {
        return this.taskLocked;
    }

    public void setTaskLocked(boolean taskLocked) {
        this.taskLocked = taskLocked;
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.minionEntity.func_70089_S();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openConfigurationScreen() {
        this.minionEntity.openAppearanceScreen();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        this.minionEntity.openStatsScreen();
    }

    public void setTaskToActivate(int id) {
        assert (id >= 0 && id < this.availableTasks.length);
        if (id >= 0 && id < this.availableTasks.length) {
            this.taskToActivate = this.availableTasks[id];
        }
    }

    private void sendChanges() {
        if (this.taskToActivate != null && this.taskToActivate != this.previousTask) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket((int)id, this.taskToActivate.getRegistryName())));
        }
        if (this.previousTaskLocked != this.taskLocked) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.dispatcher.sendToServer(new InputEventPacket("lt", "" + id)));
        }
    }

    public static class Factory
    implements IContainerFactory<MinionContainer> {
        @Nullable
        public MinionContainer create(int windowId, PlayerInventory inv, PacketBuffer data) {
            Entity e;
            if (data == null) {
                return null;
            }
            int entityId = data.func_150792_a();
            Entity entity = e = inv.field_70458_d.field_70170_p == null ? null : inv.field_70458_d.field_70170_p.func_73045_a(entityId);
            if (!(e instanceof MinionEntity)) {
                LOGGER.error("Cannot find related minion entity {}", (Object)entityId);
                return null;
            }
            return MinionContainer.create(windowId, inv, (MinionEntity)e);
        }
    }
}

