/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeartStrikerItem
extends VampirismVampireSword
implements IItemWithTier {
    public static final String regName = "heart_striker";
    private static final int[] DAMAGE_TIER = new int[]{8, 9, 10};
    private static final float[] UNTRAINED_SPEED_TIER = new float[]{-3.8f, -3.7f, -3.6f};
    private static final float[] TRAINED_SPEED_TIER = new float[]{-2.4f, -2.3f, -2.2f};
    private final IItemWithTier.TIER tier;

    public HeartStrikerItem(IItemWithTier.TIER tier) {
        super("heart_striker_" + tier.getName(), ItemTier.IRON, DAMAGE_TIER[tier.ordinal()], UNTRAINED_SPEED_TIER[tier.ordinal()], TRAINED_SPEED_TIER[tier.ordinal()], new Item.Properties().func_200916_a(VampirismMod.creativeTab).func_200918_c(2500));
        this.tier = tier;
        this.setTranslation_key(regName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    public String getBaseRegName() {
        return regName;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ((Object)((Object)(this.getVampirismTier() == IItemWithTier.TIER.NORMAL ? ModItems.blood_infused_iron_ingot : ModItems.blood_infused_enhanced_iron_ingot))).equals(repair.func_77973_b()) || super.func_82789_a(toRepair, repair);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return this.getVampirismTier() == IItemWithTier.TIER.ULTIMATE ? super.getXpRepairRatio(stack) / 2.0f : super.getXpRepairRatio(stack);
    }

    @Override
    protected float getChargeUsage() {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordBloodUsageFactor.get() / 100.0 * (double)(this.getVampirismTier().ordinal() + 2) / 2.0);
    }

    @Override
    protected float getChargingFactor(ItemStack stack) {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordChargingFactor.get() * 2.0 / (double)((float)this.getVampirismTier().ordinal() + 2.0f));
    }
}

