/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class OblivionItem
extends VampirismItem {
    public static void applyEffect(IFactionPlayer<?> factionPlayer) {
        PlayerEntity player = factionPlayer.getRepresentingPlayer();
        FactionPlayerHandler.getOpt(player).ifPresent(fph -> {
            ISkillHandler skillHandler = factionPlayer.getSkillHandler();
            if (((SkillHandler)skillHandler).getRootNode().getChildren().stream().flatMap(a -> Arrays.stream(a.getElements())).noneMatch(skillHandler::isSkillEnabled)) {
                return;
            }
            boolean test = VampirismMod.inDev || VampirismMod.instance.getVersionInfo().getCurrentVersion().isTestVersion();
            player.func_195064_c(new EffectInstance(ModEffects.oblivion, Integer.MAX_VALUE, test ? 100 : 4));
            if (factionPlayer instanceof ISyncable.ISyncableEntityCapabilityInst) {
                HelperLib.sync((ISyncable.ISyncableEntityCapabilityInst)((Object)factionPlayer), (Entity)factionPlayer.getRepresentingPlayer(), false);
            }
        });
    }

    public OblivionItem(String regName, Item.Properties properties) {
        super(regName, properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.oblivion_potion.resets_skills").func_240699_a_(TextFormatting.GRAY));
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, @Nonnull World worldIn, LivingEntity entityLiving) {
        stack.func_190918_g(1);
        if (entityLiving instanceof PlayerEntity) {
            FactionPlayerHandler.getOpt((PlayerEntity)entityLiving).map(FactionPlayerHandler::getCurrentFactionPlayer).orElse(Optional.empty()).ifPresent(OblivionItem::applyEffect);
        }
        if (entityLiving instanceof MinionEntity) {
            ((MinionEntity)entityLiving).getMinionData().ifPresent(d -> d.upgradeStat(-1, (MinionEntity)entityLiving));
        }
        return stack;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return UseAction.DRINK;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull PlayerEntity playerIn, @Nonnull Hand handIn) {
        return DrinkHelper.func_234707_a_((World)worldIn, (PlayerEntity)playerIn, (Hand)handIn);
    }
}

