/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampireClothingItem;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PureBloodItem
extends VampirismItem {
    public static final int COUNT = 5;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String name = "pure_blood";
    private final int level;

    public static Item getBloodItemForLevel(int level) {
        switch (level) {
            case 0: {
                return ModItems.pure_blood_0;
            }
            case 1: {
                return ModItems.pure_blood_1;
            }
            case 2: {
                return ModItems.pure_blood_2;
            }
            case 3: {
                return ModItems.pure_blood_3;
            }
            case 4: {
                return ModItems.pure_blood_4;
            }
        }
        LOGGER.warn("Pure blood of level {} does not exist", (Object)level);
        return ModItems.pure_blood_4;
    }

    public PureBloodItem(int level) {
        super("pure_blood_" + level, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.level = level;
        this.setTranslation_key(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.vampirism.pure_blood.purity").func_230529_a_((ITextComponent)new StringTextComponent(": " + (this.level + 1) + "/" + 5)).func_240699_a_(TextFormatting.RED));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            VampirePlayer.getOpt((PlayerEntity)entityLiving).ifPresent(v -> {
                v.drinkBlood(50, 0.3f, false);
                entityLiving.func_195064_c(new EffectInstance(ModEffects.saturation));
                stack.func_190918_g(1);
                this.checkWingConditions((VampirePlayer)v);
            });
        }
        return stack;
    }

    public int getLevel() {
        return this.level;
    }

    public ITextComponent getCustomName() {
        return new TranslationTextComponent(this.func_195935_o()).func_230529_a_((ITextComponent)new StringTextComponent(" " + (this.level + 1)));
    }

    public int func_77626_a(ItemStack stack) {
        return 30;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        int playerLevel = VampirismAPI.getFactionPlayerHandler(playerIn).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse(0);
        if (VampireLevelingConf.getInstance().isLevelValidForAltarInfusion(playerLevel)) {
            int pureLevel = VampireLevelingConf.getInstance().getAltarInfusionRequirements((int)playerLevel).pureBloodLevel;
            if (this.getLevel() < pureLevel) {
                playerIn.func_184598_c(handIn);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void checkWingConditions(VampirePlayer p) {
        PlayerEntity e = p.getRepresentingPlayer();
        if (!e.field_71075_bZ.field_75098_d && !e.field_70170_p.func_201670_d() && e.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof VampireClothingItem) {
            p.triggerWings();
        }
    }
}

