/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.client.model.armor.ClothingBootsModel;
import de.teamlapen.vampirism.client.model.armor.ClothingCrownModel;
import de.teamlapen.vampirism.client.model.armor.ClothingPantsModel;
import de.teamlapen.vampirism.client.model.armor.DummyClothingModel;
import de.teamlapen.vampirism.client.model.armor.VampireHatModel;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampireClothingItem
extends ArmorItem
implements IFactionExclusiveItem {
    private final String regName;

    public VampireClothingItem(EquipmentSlotType slotType, String regName) {
        super((IArmorMaterial)ArmorMaterial.LEATHER, slotType, new Item.Properties().func_200915_b(ArmorMaterial.IRON.func_200896_a(slotType)).func_200916_a(VampirismMod.creativeTab));
        this.regName = regName;
        this.setRegistryName("vampirism", regName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        PlayerEntity playerEntity = VampirismMod.proxy.getClientPlayer();
        this.addFactionPoisonousToolTip(stack, worldIn, tooltip, flagIn, playerEntity);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        switch (this.regName) {
            case "vampire_clothing_crown": {
                return ClothingCrownModel.getInstance();
            }
            case "vampire_clothing_legs": {
                return ClothingPantsModel.getInstance();
            }
            case "vampire_clothing_boots": {
                return ClothingBootsModel.getInstance();
            }
            case "vampire_clothing_hat": {
                return VampireHatModel.getInstance();
            }
        }
        return DummyClothingModel.getArmorModel();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return String.format("vampirism:textures/models/armor/%s.png", this.regName);
    }

    @Override
    @Nonnull
    public IFaction<?> getExclusiveFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        if (player.field_70173_aa % 16 == 8 && !Helper.isVampire(player)) {
            player.func_195064_c(new EffectInstance(ModEffects.poison, 20, 1));
        }
    }
}

