/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPlayer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.refinements.RefinementSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class VampireRefinementItem
extends Item
implements IRefinementItem {
    public static final int MAX_DAMAGE = 500;
    private static final Random RANDOM = new Random();
    private final IRefinementItem.AccessorySlotType type;

    public static ItemStack getRandomRefinementItem(IFaction<?> faction) {
        ItemStack stack;
        List sets = ModRegistries.REFINEMENT_SETS.getValues().stream().filter(set -> set.getFaction() == faction).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        IRefinementSet s = (IRefinementSet)((WeightedRandomItem)WeightedRandom.func_76271_a((Random)RANDOM, sets)).getItem();
        IRefinementItem.AccessorySlotType t = s.getSlotType().orElseGet(() -> {
            switch (RANDOM.nextInt(3)) {
                case 0: {
                    return IRefinementItem.AccessorySlotType.OBI_BELT;
                }
                case 1: {
                    return IRefinementItem.AccessorySlotType.RING;
                }
            }
            return IRefinementItem.AccessorySlotType.AMULET;
        });
        VampireRefinementItem i = VampireRefinementItem.getItemForType(t);
        if (i.applyRefinementSet(stack = new ItemStack((IItemProvider)i), s)) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static IRefinementSet getRandomRefinementForItem(@Nullable IFaction<?> faction, VampireRefinementItem stack) {
        List sets = ModRegistries.REFINEMENT_SETS.getValues().stream().filter(set -> faction == null || set.getFaction() == faction).filter(set -> set.getSlotType().map(s -> s == stack.getSlotType()).orElse(true)).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return null;
        }
        return (IRefinementSet)((WeightedRandomItem)WeightedRandom.func_76271_a((Random)RANDOM, sets)).getItem();
    }

    public static VampireRefinementItem getItemForType(IRefinementItem.AccessorySlotType type) {
        switch (type) {
            case AMULET: {
                return ModItems.amulet;
            }
            case RING: {
                return ModItems.ring;
            }
        }
        return ModItems.obi_belt;
    }

    public VampireRefinementItem(Item.Properties properties, IRefinementItem.AccessorySlotType type) {
        super(properties.func_200915_b(500).setNoRepair());
        this.type = type;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IRefinementSet set = this.getRefinementSet(stack);
        if (set != null) {
            for (IRefinement refinement : set.getRefinements()) {
                tooltip.add((ITextComponent)new StringTextComponent(" - ").func_230529_a_(refinement.getDescription()).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public boolean applyRefinementSet(ItemStack stack, IRefinementSet set) {
        if (set.getSlotType().map(t -> t == this.type).orElse(true).booleanValue()) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74778_a("refinement_set", set.getRegistryName().toString());
            return true;
        }
        return false;
    }

    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        IRefinementSet set = this.getRefinementSet(stack);
        if (set == null) {
            return super.func_200295_i(stack);
        }
        return new TranslationTextComponent(this.func_77658_a()).func_240702_b_(" ").func_230529_a_(set.getName()).func_240699_a_(set.getRarity().color);
    }

    @Override
    @Nullable
    public IRefinementSet getRefinementSet(ItemStack stack) {
        String refinementsNBT = stack.func_196082_o().func_74779_i("refinement_set");
        return (IRefinementSet)ModRegistries.REFINEMENT_SETS.getValue(new ResourceLocation(refinementsNBT));
    }

    @Override
    public IRefinementItem.AccessorySlotType getSlotType() {
        return this.type;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.func_201670_d()) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            if (FactionPlayerHandler.getOpt(playerIn).map(v -> v).flatMap(FactionPlayerHandler::getCurrentFactionPlayer).map(ISkillPlayer::getSkillHandler).map(sh -> sh.equipRefinementItem(stack)).orElse(false).booleanValue()) {
                return ActionResult.func_226249_b_((Object)ItemStack.field_190927_a);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

