/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;

public class JEIPotionMix {
    private final List<List<ItemStack>> inputs;
    private final ItemStack potionOutput;
    private final ExtendedPotionMix original;

    public static Collection<JEIPotionMix> createFromMix(ExtendedPotionMix mix) {
        List<ItemStack> in1 = mix.reagent1.map(Ingredient::func_193365_a).map(Arrays::stream).orElse(Stream.empty()).map(ItemStack::func_77946_l).peek(s -> s.func_190920_e(mix.reagent1Count)).filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        List<ItemStack> in2 = mix.reagent2.map(Ingredient::func_193365_a).map(Arrays::stream).orElse(Stream.empty()).map(ItemStack::func_77946_l).peek(s -> s.func_190920_e(mix.reagent2Count)).filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        ArrayList<JEIPotionMix> recipes = new ArrayList<JEIPotionMix>(3);
        recipes.add(JEIPotionMix.build(mix, Items.field_151068_bn, (Potion)mix.input.get(), (Potion)mix.output.get(), in1, in2));
        if (((Potion)mix.output.get()).func_185170_a().stream().noneMatch(s -> s.func_188419_a().func_220303_e() != EffectType.HARMFUL)) {
            recipes.add(JEIPotionMix.build(mix, Items.field_185156_bI, (Potion)mix.input.get(), (Potion)mix.output.get(), in1, in2));
            recipes.add(JEIPotionMix.build(mix, Items.field_185155_bH, (Potion)mix.input.get(), (Potion)mix.output.get(), in1, in2));
        }
        return recipes;
    }

    private static JEIPotionMix build(ExtendedPotionMix mix, Item base, Potion in, Potion out, List<ItemStack> in1, List<ItemStack> in2) {
        ArrayList<List<ItemStack>> ingredientList = new ArrayList<List<ItemStack>>();
        ItemStack potionIn = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)base), (Potion)in);
        ItemStack potionOut = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)base), (Potion)out);
        List<ItemStack> potionInList = Collections.singletonList(potionIn);
        ingredientList.add(potionInList);
        ingredientList.add(potionInList);
        ingredientList.add(potionInList);
        ingredientList.add(in1);
        ingredientList.add(in2);
        return new JEIPotionMix(mix, ingredientList, potionOut);
    }

    private JEIPotionMix(ExtendedPotionMix original, List<List<ItemStack>> inputs, ItemStack potionOutput) {
        this.inputs = inputs;
        this.potionOutput = potionOutput;
        this.original = original;
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public ExtendedPotionMix getOriginal() {
        return this.original;
    }

    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }
}

