/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.client.gui.AlchemicalCauldronScreen;
import de.teamlapen.vampirism.client.gui.WeaponTableScreen;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.inventory.container.AlchemicalCauldronContainer;
import de.teamlapen.vampirism.inventory.container.WeaponTableContainer;
import de.teamlapen.vampirism.modcompat.jei.AlchemicalCauldronRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.PotionTableRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.TaskRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.WeaponTableRecipeCategory;
import de.teamlapen.vampirism.player.tasks.TaskUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

@JeiPlugin
public class VampirismJEIPlugin
implements IModPlugin {
    static final ResourceLocation WEAPON_TABLE_RECIPE_ID = new ResourceLocation("vampirism", "hunter_weapon");
    static final ResourceLocation ALCHEMICAL_CAULDRON_RECIPE_UID = new ResourceLocation("vampirism", "alchemical_cauldron");
    static final ResourceLocation TASK_RECIPE_UID = new ResourceLocation("vampirism", "task");
    static final ResourceLocation POTION_RECIPE_UID = new ResourceLocation("vampirism", "potion");
    private static final ResourceLocation ID = new ResourceLocation("vampirism", "plugin");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemicalCauldronRecipeCategory(helper), new WeaponTableRecipeCategory(helper), new TaskRecipeCategory(helper), new PotionTableRecipeCategory(helper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AlchemicalCauldronScreen.class, 80, 34, 20, 15, new ResourceLocation[]{ALCHEMICAL_CAULDRON_RECIPE_UID});
        registration.addRecipeClickArea(WeaponTableScreen.class, 114, 46, 20, 15, new ResourceLocation[]{WEAPON_TABLE_RECIPE_ID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AlchemicalCauldronContainer.class, ALCHEMICAL_CAULDRON_RECIPE_UID, 0, 2, 4, 36);
        registration.addRecipeTransferHandler(AlchemicalCauldronContainer.class, VanillaRecipeCategoryUid.FUEL, 3, 1, 4, 36);
        registration.addRecipeTransferHandler(WeaponTableContainer.class, WEAPON_TABLE_RECIPE_ID, 1, 16, 17, 36);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        registration.addRecipes(recipeManager.func_215366_a(ModRecipes.ALCHEMICAL_CAULDRON_TYPE).values(), ALCHEMICAL_CAULDRON_RECIPE_UID);
        registration.addRecipes(recipeManager.func_215366_a(ModRecipes.WEAPONTABLE_CRAFTING_TYPE).values(), WEAPON_TABLE_RECIPE_ID);
        registration.addRecipes(TaskUtil.getItemRewardTasks(), TASK_RECIPE_UID);
        registration.addRecipes((Collection)VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().map(JEIPotionMix::createFromMix).flatMap(Collection::stream).collect(Collectors.toList()), POTION_RECIPE_UID);
        registration.addRecipes(this.getRepairRecipes(registration.getVanillaRecipeFactory()), VanillaRecipeCategoryUid.ANVIL);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    private Collection<Object> getRepairRecipes(IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        HashMap items = Maps.newHashMap();
        Ingredient ironIngredient = ItemTier.IRON.func_200924_f();
        items.put(ironIngredient, Lists.newArrayList((Object[])new Item[]{ModItems.hunter_axe_normal, ModItems.hunter_axe_enhanced, ModItems.hunter_axe_ultimate, ModItems.basic_tech_crossbow, ModItems.enhanced_tech_crossbow, ModItems.hunter_coat_chest_normal, ModItems.hunter_coat_chest_enhanced, ModItems.hunter_coat_chest_ultimate, ModItems.hunter_coat_head_normal, ModItems.hunter_coat_head_enhanced, ModItems.hunter_coat_head_ultimate, ModItems.hunter_coat_legs_normal, ModItems.hunter_coat_legs_enhanced, ModItems.hunter_coat_legs_ultimate, ModItems.hunter_coat_feet_normal, ModItems.hunter_coat_feet_enhanced, ModItems.hunter_coat_feet_ultimate}));
        Ingredient stringIngredient = Ingredient.func_199805_a((ITag)Tags.Items.STRING);
        items.put(stringIngredient, Lists.newArrayList((Object[])new Item[]{ModItems.basic_crossbow, ModItems.basic_double_crossbow, ModItems.enhanced_crossbow, ModItems.enhanced_double_crossbow}));
        Ingredient obsidianIngredient = Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN);
        items.put(obsidianIngredient, Lists.newArrayList((Object[])new Item[]{ModItems.obsidian_armor_chest_normal, ModItems.obsidian_armor_chest_enhanced, ModItems.obsidian_armor_chest_ultimate, ModItems.obsidian_armor_head_normal, ModItems.obsidian_armor_head_enhanced, ModItems.obsidian_armor_head_ultimate, ModItems.obsidian_armor_legs_normal, ModItems.obsidian_armor_legs_enhanced, ModItems.obsidian_armor_legs_ultimate, ModItems.obsidian_armor_feet_normal, ModItems.obsidian_armor_feet_enhanced, ModItems.obsidian_armor_feet_ultimate}));
        Ingredient leather = Ingredient.func_199805_a((ITag)Tags.Items.LEATHER);
        items.put(leather, Lists.newArrayList((Object[])new Item[]{ModItems.armor_of_swiftness_chest_normal, ModItems.armor_of_swiftness_chest_enhanced, ModItems.armor_of_swiftness_chest_ultimate, ModItems.armor_of_swiftness_head_normal, ModItems.armor_of_swiftness_head_enhanced, ModItems.armor_of_swiftness_head_ultimate, ModItems.armor_of_swiftness_legs_normal, ModItems.armor_of_swiftness_legs_enhanced, ModItems.armor_of_swiftness_legs_ultimate, ModItems.armor_of_swiftness_feet_normal, ModItems.armor_of_swiftness_feet_enhanced, ModItems.armor_of_swiftness_feet_ultimate}));
        Ingredient bloodIngot = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.blood_infused_iron_ingot});
        items.put(bloodIngot, Lists.newArrayList((Object[])new Item[]{ModItems.heart_seeker_normal, ModItems.heart_striker_normal}));
        Ingredient enhancedBloodIngot = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.blood_infused_enhanced_iron_ingot});
        items.put(enhancedBloodIngot, Lists.newArrayList((Object[])new Item[]{ModItems.heart_seeker_enhanced, ModItems.heart_seeker_ultimate, ModItems.heart_striker_enhanced, ModItems.heart_striker_ultimate}));
        for (Map.Entry entry : items.entrySet()) {
            ArrayList repairMaterials = Lists.newArrayList((Object[])((Ingredient)entry.getKey()).func_193365_a());
            for (Item ingredientItem : (List)entry.getValue()) {
                ItemStack ingredient = new ItemStack((IItemProvider)ingredientItem);
                ItemStack damaged1 = ingredient.func_77946_l();
                damaged1.func_196085_b(damaged1.func_77958_k());
                ItemStack damaged2 = ingredient.func_77946_l();
                damaged2.func_196085_b(damaged2.func_77958_k() * 3 / 4);
                ItemStack damaged3 = ingredient.func_77946_l();
                damaged3.func_196085_b(damaged3.func_77958_k() * 2 / 4);
                if (!repairMaterials.isEmpty()) {
                    Object repairWithMaterial = factory.createAnvilRecipe(damaged1, (List)repairMaterials, Collections.singletonList(damaged2));
                    recipes.add(repairWithMaterial);
                }
                Object repairWithSame = factory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3));
                recipes.add(repairWithSame);
            }
        }
        return recipes;
    }
}

