/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.inventory.container.HunterBasicContainer;
import de.teamlapen.vampirism.inventory.container.HunterTrainerContainer;
import de.teamlapen.vampirism.inventory.container.VampirismContainer;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.network.RequestMinionSelectPacket;
import de.teamlapen.vampirism.network.SelectMinionTaskPacket;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InputEventPacket
implements IMessage {
    public static final String SUCKBLOOD = "sb";
    public static final String ENDSUCKBLOOD = "esb";
    public static final String TOGGLEACTION = "ta";
    public static final String UNLOCKSKILL = "us";
    public static final String RESETSKILL = "rs";
    public static final String TRAINERLEVELUP = "tl";
    public static final String REVERTBACK = "rb";
    public static final String VAMPIRE_VISION_TOGGLE = "vvt";
    public static final String BASICHUNTERLEVELUP = "bl";
    public static final String DRINK_BLOOD_BLOCK = "db";
    public static final String NAME_ITEM = "ni";
    public static final String SELECT_CALL_MINION = "sm";
    public static final String TOGGLE_LOCK_MINION_TASK = "lt";
    public static final String RESURRECT = "rst";
    public static final String DIE = "die";
    public static final String OPEN_VAMPIRISM_MENU = "ovm";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SPLIT = "&";
    private String param;
    private String action;

    static void encode(InputEventPacket msg, PacketBuffer buf) {
        buf.func_180714_a(msg.action + SPLIT + msg.param);
    }

    static InputEventPacket decode(PacketBuffer buf) {
        String[] s = buf.func_150789_c(50).split(SPLIT);
        InputEventPacket msg = new InputEventPacket();
        msg.action = s[0];
        msg.param = s.length > 1 ? s[1] : "";
        return msg;
    }

    public static void handle(InputEventPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        Validate.notNull((Object)msg.action);
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional<IFactionPlayer> factionPlayerOpt = FactionPlayerHandler.getOpt((PlayerEntity)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElse(Optional.empty());
            switch (msg.action) {
                case "sb": {
                    try {
                        int id = Integer.parseInt(msg.param);
                        if (id == 0) break;
                        VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vampire -> vampire.biteEntity(id));
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Receiving invalid param {} for {}", (Object)msg.param, (Object)msg.action);
                    }
                    break;
                }
                case "esb": {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vampire -> vampire.endFeeding(true));
                    break;
                }
                case "ta": {
                    ResourceLocation id = new ResourceLocation(msg.param);
                    factionPlayerOpt.ifPresent(factionPlayer -> {
                        IActionHandler actionHandler = factionPlayer.getActionHandler();
                        IAction action = (IAction)ModRegistries.ACTIONS.getValue(id);
                        if (action != null) {
                            IAction.PERM r = actionHandler.toggleAction(action);
                            switch (r) {
                                case NOT_UNLOCKED: {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.not_unlocked"), true);
                                    break;
                                }
                                case DISABLED: {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.deactivated_by_serveradmin"), false);
                                    break;
                                }
                                case COOLDOWN: {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.cooldown_not_over"), true);
                                    break;
                                }
                                case DISALLOWED: {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.disallowed"), true);
                                }
                            }
                        } else {
                            LOGGER.error("Failed to find action with id {}", (Object)id);
                        }
                    });
                    break;
                }
                case "db": {
                    String[] coords = msg.param.split(":");
                    if (coords.length == 3) {
                        BlockPos pos = new BlockPos(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
                        VampirePlayer.getOpt((PlayerEntity)player).ifPresent(v -> v.biteBlock(pos));
                        break;
                    }
                    LOGGER.warn("Received invalid {} parameter", (Object)DRINK_BLOOD_BLOCK);
                    break;
                }
                case "us": {
                    factionPlayerOpt.ifPresent(factionPlayer -> {
                        ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(msg.param));
                        if (skill != null) {
                            ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                            ISkillHandler.Result result = skillHandler.canSkillBeEnabled(skill);
                            if (result == ISkillHandler.Result.OK) {
                                skillHandler.enableSkill(skill);
                                if (factionPlayer instanceof ISyncable.ISyncableEntityCapabilityInst && skillHandler instanceof SkillHandler) {
                                    CompoundNBT sync = new CompoundNBT();
                                    ((SkillHandler)skillHandler).writeUpdateForClient(sync);
                                    HelperLib.sync((ISyncable.ISyncableEntityCapabilityInst)((Object)factionPlayer), sync, (Entity)factionPlayer.getRepresentingPlayer(), false);
                                }
                            } else {
                                LOGGER.warn("Skill {} cannot be activated for {} ({})", (Object)skill, (Object)player, (Object)result);
                            }
                        } else {
                            LOGGER.warn("Skill {} was not found so {} cannot activate it", (Object)msg.param, (Object)player);
                        }
                    });
                    break;
                }
                case "rs": {
                    InventoryHelper.removeItemFromInventory((IInventory)player.field_71071_by, new ItemStack((IItemProvider)ModItems.oblivion_potion));
                    factionPlayerOpt.ifPresent(OblivionItem::applyEffect);
                    break;
                }
                case "tl": {
                    if (!(player.field_71070_bA instanceof HunterTrainerContainer)) break;
                    ((HunterTrainerContainer)player.field_71070_bA).onLevelupClicked();
                    break;
                }
                case "rb": {
                    FactionPlayerHandler.get((PlayerEntity)player).setFactionAndLevel(null, 0);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("command.vampirism.base.level.successful", new Object[]{player.func_200200_C_(), VReference.VAMPIRE_FACTION.getName(), 0}), true);
                    LOGGER.debug("Player {} left faction", (Object)player);
                    if (ServerLifecycleHooks.getCurrentServer().func_71199_h()) break;
                    player.func_70097_a(DamageSource.field_76376_m, 1000.0f);
                    break;
                }
                case "vvt": {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(VampirePlayer::switchVision);
                    break;
                }
                case "bl": {
                    if (!(player.field_71070_bA instanceof HunterBasicContainer)) break;
                    ((HunterBasicContainer)player.field_71070_bA).onLevelUpClicked();
                    break;
                }
                case "ni": {
                    String name = msg.param;
                    if ("DO_NOT_NAME".equals(name)) {
                        ItemStack stack = player.func_184614_ca();
                        if (!(stack.func_77973_b() instanceof VampirismVampireSword)) break;
                        ((VampirismVampireSword)stack.func_77973_b()).doNotName(stack);
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)name)) break;
                    ItemStack stack = player.func_184614_ca();
                    stack.func_200302_a((ITextComponent)new StringTextComponent(name).func_240699_a_(TextFormatting.AQUA));
                    break;
                }
                case "sm": {
                    FactionPlayerHandler.getOpt((PlayerEntity)ctx.getSender()).ifPresent(fp -> {
                        PlayerMinionController controller = MinionWorldData.getData(ctx.getSender().field_71133_b).getOrCreateController((FactionPlayerHandler)fp);
                        Collection<Integer> ids = controller.getCallableMinions();
                        if (ids.size() > 0) {
                            ArrayList<Pair<Integer, ITextComponent>> minions = new ArrayList<Pair<Integer, ITextComponent>>(ids.size());
                            ids.forEach(id -> controller.contactMinionData((int)id, data -> data.getFormattedName().func_230532_e_()).ifPresent(n -> minions.add(Pair.of((Object)id, (Object)n))));
                            VampirismMod.dispatcher.sendTo(new RequestMinionSelectPacket(RequestMinionSelectPacket.Action.CALL, minions), ctx.getSender());
                        } else {
                            SelectMinionTaskPacket.printRecoveringMinions(ctx.getSender(), controller.getRecoveringMinionNames());
                        }
                    });
                    break;
                }
                case "lt": {
                    try {
                        int id = Integer.parseInt(msg.param);
                        FactionPlayerHandler.getOpt((PlayerEntity)ctx.getSender()).ifPresent(fp -> {
                            PlayerMinionController controller = MinionWorldData.getData(ctx.getSender().field_71133_b).getOrCreateController((FactionPlayerHandler)fp);
                            controller.contactMinionData(id, data -> data.setTaskLocked(!data.isTaskLocked()));
                            controller.contactMinion(id, MinionEntity::onTaskChanged);
                        });
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Receiving invalid param {} for {}", (Object)msg.param, (Object)msg.action);
                    }
                    break;
                }
                case "ovm": {
                    factionPlayerOpt.ifPresent(fPlayer -> {
                        if (player.func_70089_S()) {
                            player.func_213829_a(new INamedContainerProvider(){

                                @Nonnull
                                public Container createMenu(int i, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
                                    return new VampirismContainer(i, playerInventory);
                                }

                                @Nonnull
                                public ITextComponent func_145748_c_() {
                                    return new TranslationTextComponent("");
                                }
                            });
                            fPlayer.getTaskManager().openVampirismMenu();
                        }
                    });
                    break;
                }
                case "rst": {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(VampirePlayer::tryResurrect);
                    break;
                }
                case "die": {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(VampirePlayer::giveUpDBNO);
                }
            }
            ctx.setPacketHandled(true);
        });
    }

    public InputEventPacket(String action, String param) {
        this.action = action;
        this.param = param;
    }

    private InputEventPacket() {
    }
}

