/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.player.TaskManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class TaskPacket
implements IMessage {
    public final int containerId;
    public final Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements;
    public final Map<UUID, Set<UUID>> completableTasks;
    public final Map<UUID, TaskManager.TaskWrapper> taskWrappers;

    public static void encode(TaskPacket msg, PacketBuffer buffer) {
        buffer.func_150787_b(msg.containerId);
        buffer.func_150787_b(msg.completableTasks.size());
        buffer.func_150787_b(msg.completedRequirements.size());
        buffer.func_150787_b(msg.taskWrappers.size());
        msg.completableTasks.forEach((uuid, tasks) -> {
            buffer.func_179252_a(uuid);
            buffer.func_150787_b(tasks.size());
            tasks.forEach(arg_0 -> ((PacketBuffer)buffer).func_179252_a(arg_0));
        });
        msg.completedRequirements.forEach((uuid, taskMapMap) -> {
            buffer.func_179252_a(uuid);
            buffer.func_150787_b(taskMapMap.size());
            taskMapMap.forEach((task, data) -> {
                buffer.func_179252_a(task);
                buffer.func_150787_b(data.size());
                data.forEach((loc, val) -> {
                    buffer.func_192572_a(loc);
                    buffer.func_150787_b(val.intValue());
                });
            });
        });
        msg.taskWrappers.forEach((id, taskWrapper) -> taskWrapper.encode(buffer));
    }

    public static TaskPacket decode(PacketBuffer buffer) {
        int containerId = buffer.func_150792_a();
        int completableSize = buffer.func_150792_a();
        int statSize = buffer.func_150792_a();
        int taskWrapperSIze = buffer.func_150792_a();
        HashMap<UUID, Set<UUID>> completableTasks = new HashMap<UUID, Set<UUID>>();
        for (int i = 0; i < completableSize; ++i) {
            UUID uuid = buffer.func_179253_g();
            HashSet<UUID> task = new HashSet<UUID>();
            int taskSize = buffer.func_150792_a();
            for (int i1 = 0; i1 < taskSize; ++i1) {
                task.add(buffer.func_179253_g());
            }
            completableTasks.put(uuid, task);
        }
        HashMap<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements = new HashMap<UUID, Map<UUID, Map<ResourceLocation, Integer>>>();
        for (int i = 0; i < statSize; ++i) {
            UUID uuid = buffer.func_179253_g();
            HashMap taskRequirements = new HashMap();
            int taskRequirementSize = buffer.func_150792_a();
            for (int i1 = 0; i1 < taskRequirementSize; ++i1) {
                UUID task = buffer.func_179253_g();
                int requirementSize = buffer.func_150792_a();
                HashMap<ResourceLocation, Integer> requirements = new HashMap<ResourceLocation, Integer>();
                for (int i2 = 0; i2 < requirementSize; ++i2) {
                    requirements.put(buffer.func_192575_l(), buffer.func_150792_a());
                }
                taskRequirements.put(task, requirements);
            }
            completedRequirements.put(uuid, taskRequirements);
        }
        HashMap<UUID, TaskManager.TaskWrapper> taskWrapper = new HashMap<UUID, TaskManager.TaskWrapper>();
        for (int i = 0; i < taskWrapperSIze; ++i) {
            TaskManager.TaskWrapper wrapper = TaskManager.TaskWrapper.decode(buffer);
            taskWrapper.put(wrapper.getId(), wrapper);
        }
        return new TaskPacket(containerId, taskWrapper, completableTasks, completedRequirements);
    }

    public static void handle(TaskPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleTaskPacket(msg));
        ctx.setPacketHandled(true);
    }

    public TaskPacket(int containerId, Map<UUID, TaskManager.TaskWrapper> taskWrappers, Map<UUID, Set<UUID>> completableTasks, Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements) {
        this.containerId = containerId;
        this.taskWrappers = taskWrappers;
        this.completedRequirements = completedRequirements;
        this.completableTasks = completableTasks;
    }
}

