/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.player.tasks.TaskInstance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class TaskStatusPacket
implements IMessage {
    public final int containerId;
    public final UUID taskBoardId;
    public final Set<ITaskInstance> available;
    public final Set<UUID> completableTasks;
    public final Map<UUID, Map<ResourceLocation, Integer>> completedRequirements;

    static void encode(@Nonnull TaskStatusPacket msg, @Nonnull PacketBuffer buf) {
        buf.func_180714_a(msg.taskBoardId.toString());
        buf.func_150787_b(msg.containerId);
        buf.func_150787_b(msg.completableTasks.size());
        msg.completableTasks.forEach(arg_0 -> ((PacketBuffer)buf).func_179252_a(arg_0));
        buf.func_150787_b(msg.available.size());
        msg.available.forEach(ins -> ins.encode(buf));
        buf.func_150787_b(msg.completedRequirements.size());
        msg.completedRequirements.forEach((id, resourceLocations) -> {
            buf.func_150787_b(resourceLocations.size());
            buf.func_179252_a(id);
            resourceLocations.forEach((loc, val) -> {
                buf.func_192572_a(loc);
                buf.func_150787_b(val.intValue());
            });
        });
    }

    static TaskStatusPacket decode(@Nonnull PacketBuffer buf) {
        UUID taskBoardId = UUID.fromString(buf.func_218666_n());
        int containerId = buf.func_150792_a();
        int completableTaskSize = buf.func_150792_a();
        HashSet completableTasks = Sets.newHashSetWithExpectedSize((int)completableTaskSize);
        for (int i = 0; i < completableTaskSize; ++i) {
            completableTasks.add(buf.func_179253_g());
        }
        int taskSize = buf.func_150792_a();
        HashSet taskInstances = Sets.newHashSetWithExpectedSize((int)taskSize);
        for (int i = 0; i < taskSize; ++i) {
            taskInstances.add(TaskInstance.decode(buf));
        }
        int completedReqSize = buf.func_150792_a();
        HashMap completedRequirements = Maps.newHashMapWithExpectedSize((int)completedReqSize);
        for (int i = 0; i < completedReqSize; ++i) {
            int l;
            UUID id = buf.func_179253_g();
            HashMap req = Maps.newHashMapWithExpectedSize((int)l);
            for (l = buf.func_150792_a(); l > 0; --l) {
                req.put(buf.func_192575_l(), buf.func_150792_a());
            }
            completedRequirements.put(id, req);
        }
        return new TaskStatusPacket(taskInstances, completableTasks, completedRequirements, containerId, taskBoardId);
    }

    public static void handle(TaskStatusPacket msg, @Nonnull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleTaskStatusPacket(msg));
        ctx.setPacketHandled(true);
    }

    public TaskStatusPacket(@Nonnull Set<ITaskInstance> available, Set<UUID> completableTasks, @Nonnull Map<UUID, Map<ResourceLocation, Integer>> completedRequirements, int containerId, UUID taskBoardId) {
        this.available = available;
        this.completableTasks = completableTasks;
        this.completedRequirements = completedRequirements;
        this.containerId = containerId;
        this.taskBoardId = taskBoardId;
    }
}

