/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModParticles;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class FlyingBloodEntityParticleData
implements IParticleData {
    public static final Codec<FlyingBloodEntityParticleData> CODEC = RecordCodecBuilder.create(p_239803_0_ -> p_239803_0_.group((App)Codec.INT.fieldOf("e").forGetter(p_239807_0_ -> p_239807_0_.entity), (App)Codec.BOOL.fieldOf("d").forGetter(p_239806_0_ -> p_239806_0_.direct)).apply((Applicative)p_239803_0_, (e, d) -> new FlyingBloodEntityParticleData(ModParticles.flying_blood_entity, (int)e, (boolean)d)));
    public static final IParticleData.IDeserializer<FlyingBloodEntityParticleData> DESERIALIZER = new IParticleData.IDeserializer<FlyingBloodEntityParticleData>(){

        public FlyingBloodEntityParticleData fromCommand(ParticleType<FlyingBloodEntityParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new FlyingBloodEntityParticleData(particleTypeIn, reader.readInt(), reader.readBoolean());
        }

        public FlyingBloodEntityParticleData fromNetwork(ParticleType<FlyingBloodEntityParticleData> particleTypeIn, PacketBuffer buffer) {
            return new FlyingBloodEntityParticleData(particleTypeIn, buffer.func_150792_a(), buffer.readBoolean());
        }
    };
    private final int entity;
    private final boolean direct;
    private final ParticleType<FlyingBloodEntityParticleData> particleType;

    public FlyingBloodEntityParticleData(ParticleType<FlyingBloodEntityParticleData> particleTypeIn, int entityID, boolean directIn) {
        this.particleType = particleTypeIn;
        this.entity = entityID;
        this.direct = directIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getDirect() {
        return this.direct;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEntityID() {
        return this.entity;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.func_150787_b(this.entity);
        buffer.writeBoolean(this.direct);
    }

    public ParticleType<?> func_197554_b() {
        return this.particleType;
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()) + " " + this.entity + "" + this.direct;
    }
}

