/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModParticles;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class FlyingBloodParticleData
implements IParticleData {
    public static final Codec<FlyingBloodParticleData> CODEC = RecordCodecBuilder.create(p_239803_0_ -> p_239803_0_.group((App)Codec.INT.fieldOf("a").forGetter(p_239807_0_ -> p_239807_0_.maxAge), (App)Codec.BOOL.fieldOf("d").forGetter(p_239806_0_ -> p_239806_0_.direct), (App)Codec.DOUBLE.fieldOf("x").forGetter(p_239805_0_ -> p_239805_0_.targetX), (App)Codec.DOUBLE.fieldOf("y").forGetter(p_239804_0_ -> p_239804_0_.targetY), (App)Codec.DOUBLE.fieldOf("z").forGetter(p_239804_0_ -> p_239804_0_.targetZ), (App)Codec.STRING.fieldOf("t").forGetter(p_239804_0_ -> p_239804_0_.texture.toString())).apply((Applicative)p_239803_0_, (a, d, x, y, z, t) -> new FlyingBloodParticleData(ModParticles.flying_blood, (int)a, (boolean)d, (double)x, (double)y, (double)z, new ResourceLocation(t))));
    public static final IParticleData.IDeserializer<FlyingBloodParticleData> DESERIALIZER = new IParticleData.IDeserializer<FlyingBloodParticleData>(){

        public FlyingBloodParticleData fromCommand(ParticleType<FlyingBloodParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new FlyingBloodParticleData(particleTypeIn, reader.readInt(), reader.readBoolean(), reader.readDouble(), reader.readDouble(), reader.readDouble(), ResourceLocation.func_195826_a((StringReader)reader));
        }

        public FlyingBloodParticleData fromNetwork(ParticleType<FlyingBloodParticleData> particleTypeIn, PacketBuffer buffer) {
            return new FlyingBloodParticleData(particleTypeIn, buffer.func_150792_a(), buffer.readBoolean(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.func_192575_l());
        }
    };
    private final int maxAge;
    private final ResourceLocation texture;
    private final boolean direct;
    private final double targetX;
    private final double targetY;
    private final double targetZ;
    private final ParticleType<FlyingBloodParticleData> particleType;

    public FlyingBloodParticleData(ParticleType<FlyingBloodParticleData> particleTypeIn, int maxAgeIn, boolean direct, double targetX, double targetY, double targetZ, ResourceLocation textureIn) {
        this.particleType = particleTypeIn;
        this.maxAge = maxAgeIn;
        this.texture = textureIn;
        this.direct = direct;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
    }

    public FlyingBloodParticleData(ParticleType<FlyingBloodParticleData> particleTypeIn, int maxAgeIn, boolean direct, double targetX, double targetY, double targetZ) {
        this(particleTypeIn, maxAgeIn, direct, targetX, targetY, targetZ, new ResourceLocation("minecraft", "critical_hit"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxAge() {
        return this.maxAge;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.func_150787_b(this.maxAge);
        buffer.writeBoolean(this.direct);
        buffer.writeDouble(this.targetX);
        buffer.writeDouble(this.targetY);
        buffer.writeDouble(this.targetZ);
        buffer.func_192572_a(this.texture);
    }

    public double getTargetX() {
        return this.targetX;
    }

    public double getTargetY() {
        return this.targetY;
    }

    public double getTargetZ() {
        return this.targetZ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexturePos() {
        return this.texture;
    }

    public ParticleType<?> func_197554_b() {
        return this.particleType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isDirect() {
        return this.direct;
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()) + " " + this.maxAge + " " + this.texture;
    }
}

