/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.blocks.AltarInspirationBlock;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.VampirismPoisonEffect;
import de.teamlapen.vampirism.effects.VampirismPotion;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.GarlicBreadItem;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.BatVampireAction;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ThrowablePotionItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModPlayerEventHandler.class);

    @SubscribeEvent
    public void blockDestroyed(BlockEvent.BreakEvent event) {
        TileEntity totem;
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        BlockPos totemPos = TotemHelper.getTotemPosition((RegistryKey<World>)((World)event.getWorld()).func_234923_W_(), event.getPos());
        Block block = event.getState().func_177230_c();
        ImmutableList validStates = block.func_176194_O().func_177619_a();
        if (validStates.size() > 1) {
            if (PointOfInterestType.field_234167_x_.stream().anyMatch(arg_0 -> ((ImmutableList)validStates).contains(arg_0))) {
                for (int x = event.getPos().func_177958_n() - 1; x <= event.getPos().func_177958_n() + 1; ++x) {
                    for (int z = event.getPos().func_177952_p() - 1; z <= event.getPos().func_177952_p() + 1; ++z) {
                        for (double y = (double)(event.getPos().func_177956_o() - 1); y <= (double)(event.getPos().func_177956_o() + 1); y += 1.0) {
                            BlockPos pos1 = new BlockPos((double)x, y, (double)z);
                            if (!event.getWorld().func_72863_F().func_222865_a(new ChunkPos(pos1)) || event.getWorld().func_180495_p(pos1).func_177230_c() != block) continue;
                            BlockPos totemPos1 = TotemHelper.getTotemPosition(pos1);
                            if (totemPos1 != null && totemPos == null) {
                                totemPos = totemPos1;
                            }
                            positions.add(pos1);
                        }
                    }
                }
            }
        }
        if (totemPos != null && event.getWorld().func_175667_e(totemPos) && (totem = event.getWorld().func_175625_s(totemPos)) instanceof TotemTileEntity && ((TotemTileEntity)totem).getControllingFaction() != null && VampirismPlayerAttributes.get((PlayerEntity)event.getPlayer()).faction != ((TotemTileEntity)totem).getControllingFaction()) {
            event.setCanceled(true);
            event.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.totem_destroy.fail_totem_faction"), true);
            if (!positions.isEmpty() && event.getPlayer() instanceof ServerPlayerEntity) {
                ServerPlayerEntity playerMP = (ServerPlayerEntity)event.getPlayer();
                positions.forEach(pos -> {
                    SUpdateTileEntityPacket pkt;
                    playerMP.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)event.getWorld(), pos));
                    TileEntity tileentity = event.getWorld().func_175625_s(pos);
                    if (tileentity != null && (pkt = tileentity.func_189518_D_()) != null) {
                        playerMP.field_71135_a.func_147359_a((IPacket)pkt);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void eyeHeight(EntityEvent.Size event) {
        if (event.getEntity() instanceof PlayerEntity && ((PlayerEntity)event.getEntity()).field_71071_by != null && event.getEntity().func_70089_S() && event.getEntity().func_213303_ch().func_189985_c() != 0.0) {
            if (VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)event.getEntity())).getVampSpecial().bat) {
                event.setNewSize(BatVampireAction.BAT_SIZE);
                event.setNewEyeHeight(0.51000005f);
            } else if (VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)event.getEntity())).getVampSpecial().isDBNO) {
                event.setNewSize(EntitySize.func_220311_c((float)0.6f, (float)0.95f));
                event.setNewEyeHeight(0.725f);
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            try {
                event.addCapability(REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.createNewCapability((PlayerEntity)event.getObject()));
                event.addCapability(REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.createNewCapability((PlayerEntity)event.getObject()));
                event.addCapability(REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.createNewCapability((PlayerEntity)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                Throwables.propagate((Throwable)e);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_70089_S()) {
            if (VampirismPlayerAttributes.get((PlayerEntity)player).getVampSpecial().bat) {
                event.setCanceled(true);
            }
            HunterPlayer.getOpt(player).ifPresent(HunterPlayer::breakDisguise);
            if (!this.checkItemUsePerm(player.func_184614_ca(), player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null) {
            HunterPlayer.getOpt(event.getPlayer()).ifPresent(HunterPlayer::breakDisguise);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity) || !event.getEntity().func_70089_S()) {
            return;
        }
        try {
            if (VampirismPlayerAttributes.get((PlayerEntity)event.getEntity()).getVampSpecial().isCannotInteract()) {
                event.setCanceled(true);
            }
            HunterPlayer.getOpt((PlayerEntity)event.getEntity()).ifPresent(HunterPlayer::breakDisguise);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (VampirismPlayerAttributes.get((PlayerEntity)event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCanceled(true);
        } else if ((((Object)((Object)ModBlocks.garlic_beacon_normal)).equals(event.getState().func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_weak)).equals(event.getState().func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_improved)).equals(event.getState().func_177230_c())) && VampirismPlayerAttributes.get((PlayerEntity)event.getPlayer()).vampireLevel > 0) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.1f);
        }
    }

    @SubscribeEvent
    public void onItemPickupPre(EntityItemPickupEvent event) {
        if (VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)event.getEntity())).getVampSpecial().isDBNO) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (!this.checkItemUsePerm(event.getItemStack(), event.getPlayer())) {
            event.setCanceled(true);
        }
        if ((event.getItemStack().func_77973_b() instanceof ThrowablePotionItem || event.getItemStack().func_77973_b() instanceof CrossbowItem) && VampirismPlayerAttributes.get((PlayerEntity)event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)event.getWorld().func_201670_d()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (VampirismPlayerAttributes.get((PlayerEntity)event.getEntity()).getVampSpecial().isCannotInteract()) {
                event.setCanceled(true);
            }
            if (!this.checkItemUsePerm(event.getItem(), player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(LivingEntityUseItemEvent.Finish event) {
        Potion p;
        ItemStack stack;
        if (Helper.isVampire(event.getEntity()) && event.getItem().func_77973_b() instanceof GarlicBreadItem && !event.getEntity().func_130014_f_().field_72995_K) {
            if (event.getEntity() instanceof IVampire) {
                DamageHandler.affectVampireGarlicDirect((IVampire)event.getEntity(), EnumStrength.MEDIUM);
            } else if (event.getEntity() instanceof PlayerEntity) {
                VampirePlayer.getOpt((PlayerEntity)event.getEntity()).ifPresent(vampire -> DamageHandler.affectVampireGarlicDirect(vampire, EnumStrength.MEDIUM));
            }
        }
        if (!Helper.isHunter(event.getEntity()) && (stack = event.getItem()).func_77973_b() == Items.field_151068_bn && (p = PotionUtils.func_185191_c((ItemStack)stack)) instanceof VampirismPotion.HunterPotion && p.func_185170_a().stream().map(EffectInstance::func_188419_a).anyMatch(Effect::func_188408_i)) {
            event.getEntityLiving().func_195064_c(new EffectInstance(ModEffects.poison, Integer.MAX_VALUE, VampirismPoisonEffect.DEADLY_AMPLIFIER));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof PlayerEntity && event.getEntity().func_70089_S() && !FactionPlayerHandler.getOpt((PlayerEntity)event.getEntity()).map(h -> h.onEntityAttacked(event.getSource(), event.getAmount())).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            HunterPlayer.getOpt((PlayerEntity)event.getSource().func_76346_g()).ifPresent(HunterPlayer::breakDisguise);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeathFirst(LivingDeathEvent event) {
        if (event.getEntity() instanceof PlayerEntity && VampirePlayer.getOpt((PlayerEntity)event.getEntity()).map(v -> v.onDeadlyHit(event.getSource())).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            event.setDistance(event.getDistance() - (float)VampirismPlayerAttributes.get((PlayerEntity)event.getEntity()).getVampSpecial().getJumpBoost());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurt(LivingHurtEvent event) {
        DamageSource d = event.getSource();
        if (!d.func_151517_h() && !d.func_76363_c() && event.getEntityLiving() instanceof PlayerEntity && VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)event.getEntity())).getVampSpecial().bat) {
            event.setAmount(event.getAmount() * 2.0f);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            event.getEntity().func_213317_d(event.getEntity().func_213322_ci().func_72441_c(0.0, (double)((float)VampirismPlayerAttributes.get((PlayerEntity)event.getEntity()).getVampSpecial().getJumpBoost() * 0.1f), 0.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            FactionPlayerHandler.get(event.getPlayer()).copyFrom(event.getOriginal());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack;
        if (event.getWorld().func_175723_af().func_177746_a(event.getPos()) && !(heldStack = event.getItemStack()).func_190926_b() && heldStack.func_190916_E() == 1) {
            boolean glasBottle = Items.field_151069_bo.equals(heldStack.func_77973_b());
            boolean bloodBottle = ModItems.blood_bottle.equals(heldStack.func_77973_b());
            if (bloodBottle || glasBottle && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
                TileEntity entity;
                Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
                BlockState state = event.getWorld().func_180495_p(event.getPos());
                boolean convert = false;
                if (glasBottle && state.hasTileEntity() && (entity = event.getWorld().func_175625_s(event.getPos())) != null) {
                    convert = entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace()).map(fluidHandler -> {
                        boolean flag = false;
                        FluidStack drain = fluidHandler.drain(new FluidStack(ModFluids.blood, 1000), IFluidHandler.FluidAction.SIMULATE);
                        if (drain.getAmount() >= 100) {
                            flag = true;
                        }
                        if (flag && block instanceof AltarInspirationBlock) {
                            flag = false;
                        }
                        if (flag && block instanceof BloodContainerBlock) {
                            flag = false;
                        }
                        return flag;
                    }).orElse(false);
                }
                if ((bloodBottle || convert) && block instanceof BloodContainerBlock) {
                    event.setUseBlock(Event.Result.ALLOW);
                }
                if (convert) {
                    Hand hand = heldStack.equals(event.getPlayer().func_184614_ca()) ? Hand.MAIN_HAND : (heldStack.equals(event.getPlayer().func_184592_cb()) ? Hand.OFF_HAND : Hand.MAIN_HAND);
                    heldStack = new ItemStack((IItemProvider)ModItems.blood_bottle);
                    event.getPlayer().func_184611_a(hand, heldStack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget().func_200600_R() != EntityType.field_200725_aD) {
            return;
        }
        ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
        if (stack.func_77973_b() != ModItems.injection_empty) {
            return;
        }
        event.getPlayer().func_184611_a(event.getHand(), new ItemStack((IItemProvider)ModItems.injection_zombie_blood));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerLeftLickedBlock(PlayerInteractEvent.LeftClickBlock event) {
        assert (event.getFace() != null);
        BlockPos pos = event.getPos().func_177972_a(event.getFace());
        World world = event.getWorld();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.alchemical_fire) {
            world.func_217378_a(null, 1009, pos, 0);
            world.func_217377_a(pos, false);
            event.setCanceled(true);
        } else if ((((Object)((Object)ModBlocks.garlic_beacon_normal)).equals(state.func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_weak)).equals(state.func_177230_c()) || ((Object)((Object)ModBlocks.garlic_beacon_improved)).equals(state.func_177230_c())) && Helper.isVampire(event.getPlayer())) {
            event.getPlayer().func_195064_c(new EffectInstance(ModEffects.garlic));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerName(PlayerEvent.NameFormat event) {
        if (event.getPlayer() != null && ((Boolean)VampirismConfig.SERVER.factionColorInChat.get()).booleanValue()) {
            FactionPlayerHandler.getOpt(event.getPlayer()).ifPresent(fph -> fph.getCurrentFactionPlayer().ifPresent(fp -> {
                IFaction f = fp.getDisguisedAs();
                if (f != null) {
                    IFormattableTextComponent displayName = fph.getLordLevel() > 0 && (Boolean)VampirismConfig.SERVER.lordPrefixInChat.get() != false ? new StringTextComponent("[").func_230529_a_(fph.getLordTitle()).func_240702_b_("] ").func_230529_a_(event.getDisplayname()) : event.getDisplayname().func_230532_e_();
                    event.setDisplayname((ITextComponent)displayName.func_240699_a_(f.getChatColor()));
                }
            }));
        }
    }

    @SubscribeEvent
    public void sleepTimeCheck(SleepingTimeCheckEvent event) {
        if (Helper.isVampire(event.getPlayer())) {
            event.getSleepingLocation().ifPresent(blockPos -> event.setResult(event.getPlayer().field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof CoffinBlock ? (event.getPlayer().field_70170_p.func_72935_r() ? Event.Result.ALLOW : Event.Result.DENY) : event.getResult()));
        }
        if (Helper.isHunter(event.getPlayer())) {
            event.getSleepingLocation().ifPresent(blockPos -> event.setResult(event.getPlayer().func_130014_f_().func_180495_p(blockPos).func_177230_c() instanceof TentBlock ? (!event.getPlayer().func_130014_f_().func_72935_r() ? Event.Result.ALLOW : Event.Result.DENY) : event.getResult()));
        }
    }

    @SubscribeEvent
    public void sleepTimeFinish(SleepFinishedTimeEvent event) {
        boolean sleepingInCoffin;
        if (event.getWorld() instanceof ServerWorld && ((ServerWorld)event.getWorld()).func_72935_r() && (sleepingInCoffin = event.getWorld().func_217369_A().stream().anyMatch(player -> {
            Optional pos = player.func_213374_dv();
            return pos.isPresent() && event.getWorld().func_180495_p((BlockPos)pos.get()).func_177230_c() instanceof CoffinBlock;
        }))) {
            long dist = ((ServerWorld)event.getWorld()).func_72820_D() % 24000L > 12000L ? 13000L : -11000L;
            event.setTimeAddition(event.getNewTime() + dist);
        }
    }

    private boolean checkItemUsePerm(ItemStack stack, PlayerEntity player) {
        boolean message;
        boolean bl = message = !player.func_130014_f_().field_72995_K;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IFactionLevelItem) {
            IFactionPlayer factionPlayer;
            if (!player.func_70089_S()) {
                return false;
            }
            IFactionLevelItem item = (IFactionLevelItem)stack.func_77973_b();
            FactionPlayerHandler handler = FactionPlayerHandler.get(player);
            IPlayableFaction usingFaction = item.getUsingFaction(stack);
            ISkill requiredSkill = item.getRequiredSkill(stack);
            if (usingFaction != null && !handler.isInFaction(usingFaction)) {
                if (message) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.can_only_be_used_by", new Object[]{usingFaction.getNamePlural()}), true);
                }
                return false;
            }
            if (handler.getCurrentLevel() < item.getMinLevel(stack)) {
                if (message) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.can_only_be_used_by_level", new Object[]{usingFaction == null ? new TranslationTextComponent("text.vampirism.all") : usingFaction.getNamePlural(), item.getMinLevel(stack)}), true);
                }
                return false;
            }
            if (!(requiredSkill == null || (factionPlayer = (IFactionPlayer)handler.getCurrentFactionPlayer().orElse(null)) != null && factionPlayer.getSkillHandler().isSkillEnabled(requiredSkill))) {
                if (message) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.can_only_be_used_with_skill", new Object[]{requiredSkill.getName()}), true);
                }
                return false;
            }
        }
        return true;
    }
}

