/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.player.TaskManager;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class VampirismPlayer<T extends IFactionPlayer<?>>
implements IFactionPlayer<T>,
ISyncable.ISyncableEntityCapabilityInst,
IPlayerEventListener {
    private static final Logger LOGGER = LogManager.getLogger(VampirismPlayer.class);
    protected final PlayerEntity player;
    private final TaskManager taskManager;

    public VampirismPlayer(PlayerEntity player) {
        this.player = player;
        this.taskManager = player instanceof ServerPlayerEntity ? new TaskManager((ServerPlayerEntity)player, this, (IPlayableFaction<?>)this.getFaction()) : null;
    }

    @Override
    public int getLevel() {
        return VampirismAPI.getFactionPlayerHandler(this.player).map(handler -> handler.getCurrentLevel((IPlayableFaction<? extends IFactionPlayer<?>>)this.getFaction())).orElse(0);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this.player;
    }

    @Override
    public PlayerEntity getRepresentingPlayer() {
        return this.player;
    }

    @Override
    @Nonnull
    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public boolean isRemote() {
        if (this.player.func_130014_f_() == null) {
            LOGGER.error("Trying to check if remote, but world is not set yet", new Throwable("World not loaded").fillInStackTrace());
            return false;
        }
        return this.player.func_130014_f_().field_72995_K;
    }

    public void loadData(CompoundNBT nbt) {
        if (this.taskManager != null) {
            this.taskManager.readNBT(nbt);
        } else {
            LOGGER.debug("The player is loaded on the client side and therefore taskmaster related data is missing");
        }
    }

    @Override
    public final void loadUpdateFromNBT(CompoundNBT nbt) {
        this.loadUpdate(nbt);
    }

    @Override
    public void onDeath(DamageSource src) {
        this.getSkillHandler().damageRefinements();
    }

    @Override
    public void onPlayerClone(PlayerEntity original, boolean wasDeath) {
        this.copyFrom(original);
    }

    @Override
    public void onUpdate() {
        if (!this.isRemote()) {
            this.taskManager.tick();
        }
    }

    public void saveData(CompoundNBT nbt) {
        if (this.taskManager != null) {
            this.taskManager.writeNBT(nbt);
        } else {
            LOGGER.debug("The player is saved on the client side and therefore taskmaster related data is missing");
        }
    }

    public void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    @Override
    public final void writeFullUpdateToNBT(CompoundNBT nbt) {
        this.writeFullUpdate(nbt);
    }

    protected abstract VampirismPlayer<T> copyFromPlayer(PlayerEntity var1);

    protected void loadUpdate(CompoundNBT nbt) {
    }

    protected void sync(CompoundNBT data, boolean all) {
        HelperLib.sync(this, data, (Entity)this.player, all);
    }

    protected void writeFullUpdate(CompoundNBT nbt) {
    }

    private void copyFrom(PlayerEntity old) {
        VampirismPlayer<T> p = this.copyFromPlayer(old);
    }
}

