/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter.actions;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class AwarenessHunterAction
extends DefaultHunterAction
implements ILastingAction<IHunterPlayer> {
    private final EntityPredicate vampirePredicate = new EntityPredicate().func_221012_a(VampirismAPI.factionRegistry().getPredicate(VReference.HUNTER_FACTION, true, true, false, false, VReference.VAMPIRE_FACTION));

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return !player.getActionHandler().isActionActive(HunterActions.disguise_hunter);
    }

    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.haAwarenessCooldown.get();
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.haAwarenessDuration.get();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.haAwarenessEnabled.get();
    }

    @Override
    public void onActivatedClient(IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public void onDeactivated(IHunterPlayer player) {
        ((HunterPlayer)player).getSpecialAttributes().nearbyVampire(0.0);
    }

    @Override
    public void onReActivated(IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public boolean onUpdate(IHunterPlayer player) {
        if (player.getRepresentingEntity().func_130014_f_().func_201670_d() && player.getRepresentingEntity().field_70173_aa % 8 == 0) {
            double dist = this.nearbyVampire(player);
            double p = 0.0;
            if (dist != Double.MAX_VALUE) {
                p = 1.0 - dist / (double)((Integer)VampirismConfig.BALANCE.haAwarenessRadius.get()).intValue();
            }
            ((HunterPlayer)player).getSpecialAttributes().nearbyVampire(p);
        }
        return false;
    }

    @Override
    protected boolean activate(IHunterPlayer player) {
        this.onUpdate(player);
        return true;
    }

    private double nearbyVampire(IHunterPlayer player) {
        int r = (Integer)VampirismConfig.BALANCE.haAwarenessRadius.get();
        LivingEntity closestVampire = player.getRepresentingEntity().func_130014_f_().func_225318_b(LivingEntity.class, this.vampirePredicate, null, player.getRepresentingEntity().func_226277_ct_(), player.getRepresentingEntity().func_226278_cu_(), player.getRepresentingEntity().func_226281_cx_(), new AxisAlignedBB(player.getRepresentingEntity().func_226277_ct_() - (double)r, player.getRepresentingEntity().func_226278_cu_() - (double)r + 1.0, player.getRepresentingEntity().func_226281_cx_() - (double)r, player.getRepresentingEntity().func_226277_ct_() + (double)r, player.getRepresentingEntity().func_226278_cu_() + (double)r + 1.0, player.getRepresentingEntity().func_226281_cx_() + (double)r));
        if (closestVampire != null) {
            return closestVampire.func_70032_d((Entity)player.getRepresentingEntity());
        }
        return Double.MAX_VALUE;
    }
}

