/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import de.teamlapen.vampirism.player.skills.SkillNode;
import de.teamlapen.vampirism.player.skills.SkillTreeManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillHandler<T extends IFactionPlayer<?>>
implements ISkillHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(SkillHandler.class);
    private final ArrayList<ISkill> enabledSkills = new ArrayList();
    private final T player;
    private final IPlayableFaction<T> faction;
    private final IRefinementSet[] appliedRefinementSets = new IRefinementSet[3];
    private final int[] refinementSetDamage = new int[3];
    private final Set<IRefinement> activeRefinements = new HashSet<IRefinement>();
    private final Map<IRefinement, AttributeModifier> refinementModifier = new HashMap<IRefinement, AttributeModifier>();
    private boolean dirty = false;

    public SkillHandler(T player, IPlayableFaction<T> faction) {
        this.player = player;
        this.faction = faction;
    }

    public Optional<SkillNode> anyLastNode() {
        SkillNode rootNode = this.getRootNode();
        ArrayDeque<SkillNode> queue = new ArrayDeque<SkillNode>();
        queue.add(rootNode);
        SkillNode skillNode = (SkillNode)queue.poll();
        while (skillNode != null) {
            List child = skillNode.getChildren().stream().filter(this::isNodeEnabled).collect(Collectors.toList());
            if (child.isEmpty()) {
                if (skillNode == rootNode) {
                    skillNode = null;
                }
                return Optional.ofNullable(skillNode);
            }
            queue.addAll(child);
            skillNode = (SkillNode)queue.poll();
        }
        return Optional.empty();
    }

    @Override
    public ISkillHandler.Result canSkillBeEnabled(ISkill skill) {
        if (this.player.getRepresentingPlayer().func_70660_b(ModEffects.oblivion) != null) {
            return ISkillHandler.Result.LOCKED_BY_PLAYER_STATE;
        }
        if (this.isSkillEnabled(skill)) {
            return ISkillHandler.Result.ALREADY_ENABLED;
        }
        SkillNode node = this.findSkillNode(this.getRootNode(), skill);
        if (node != null) {
            if (this.isSkillNodeLocked(node)) {
                return ISkillHandler.Result.LOCKED_BY_OTHER_NODE;
            }
            if (node.isRoot() || this.isNodeEnabled(node.getParent())) {
                if (this.getLeftSkillPoints() > 0) {
                    return this.isNodeEnabled(node) ? ISkillHandler.Result.OTHER_NODE_SKILL : ISkillHandler.Result.OK;
                }
                return ISkillHandler.Result.NO_POINTS;
            }
            return ISkillHandler.Result.PARENT_NOT_ENABLED;
        }
        LOGGER.warn("Node for skill {} could not be found", (Object)skill);
        return ISkillHandler.Result.NOT_FOUND;
    }

    @Override
    public ItemStack[] createRefinementItems() {
        ItemStack[] items = new ItemStack[this.appliedRefinementSets.length];
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            VampireRefinementItem item;
            if (this.appliedRefinementSets[i] == null) continue;
            switch (i) {
                case 0: {
                    item = ModItems.amulet;
                    break;
                }
                case 1: {
                    item = ModItems.ring;
                    break;
                }
                default: {
                    item = ModItems.obi_belt;
                }
            }
            items[i] = new ItemStack((IItemProvider)item);
            item.applyRefinementSet(items[i], this.appliedRefinementSets[i]);
            items[i].func_196085_b(this.refinementSetDamage[i]);
        }
        return items;
    }

    @Override
    public void damageRefinements() {
        for (int i = 0; i < this.refinementSetDamage.length; ++i) {
            if (this.appliedRefinementSets[i] == null) continue;
            int damage = 40 + (this.appliedRefinementSets[i].getRarity().weight - 1) * 10 + this.getPlayer().getRepresentingPlayer().func_70681_au().nextInt(60);
            int n = i;
            this.refinementSetDamage[n] = this.refinementSetDamage[n] + damage;
            if (this.refinementSetDamage[n] < 500) continue;
            this.removeRefinementSet(i);
        }
    }

    public void disableAllSkills() {
        for (ISkill skill : this.enabledSkills) {
            skill.onDisable((IFactionPlayer)this.player);
        }
        this.enabledSkills.clear();
        this.dirty = true;
    }

    @Override
    public void disableSkill(ISkill skill) {
        if (this.enabledSkills.remove(skill)) {
            skill.onDisable((IFactionPlayer)this.player);
            this.dirty = true;
        }
    }

    public void enableRootSkill() {
        this.enableSkill(this.getRootNode().getElements()[0]);
    }

    @Override
    public void enableSkill(ISkill skill) {
        if (!this.enabledSkills.contains(skill)) {
            skill.onEnable((IFactionPlayer)this.player);
            this.enabledSkills.add(skill);
            this.dirty = true;
            if (this.player.getRepresentingPlayer() instanceof ServerPlayerEntity) {
                ModAdvancements.TRIGGER_SKILL_UNLOCKED.trigger((ServerPlayerEntity)this.player.getRepresentingPlayer(), skill);
            }
        }
    }

    @Override
    public boolean equipRefinementItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof IRefinementItem) {
            IRefinementItem refinementItem = (IRefinementItem)stack.func_77973_b();
            IRefinementSet newSet = refinementItem.getRefinementSet(stack);
            IRefinementItem.AccessorySlotType setSlot = refinementItem.getSlotType();
            this.removeRefinementSet(setSlot.getSlot());
            this.dirty = true;
            if (newSet != null && newSet.getFaction() == this.faction) {
                this.applyRefinementSet(newSet, setSlot.getSlot());
            }
            return true;
        }
        return false;
    }

    public SkillNode findSkillNode(SkillNode base, ISkill skill) {
        for (ISkill s : base.getElements()) {
            if (!s.equals(skill)) continue;
            return base;
        }
        for (SkillNode child : base.getChildren()) {
            SkillNode node = this.findSkillNode(child, skill);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getLeftSkillPoints() {
        int level = this.player.getLevel();
        int totalSkillPoints = (int)((double)level * (Double)VampirismConfig.BALANCE.skillPointsPerLevel.get());
        int remainingSkillPoints = totalSkillPoints - this.enabledSkills.size();
        if (((Boolean)VampirismConfig.SERVER.unlockAllSkills.get()).booleanValue() && level == this.player.getMaxLevel()) {
            return Math.max(remainingSkillPoints, 1);
        }
        return remainingSkillPoints;
    }

    public List<ISkill> getLockingSkills(SkillNode nodeIn) {
        return Arrays.stream(nodeIn.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node -> Arrays.stream(node.getElements())).collect(Collectors.toList());
    }

    @Override
    public ISkill[] getParentSkills(ISkill skill) {
        SkillNode node = this.findSkillNode(this.getRootNode(), skill);
        if (node == null) {
            return null;
        }
        return node.getParent().getElements();
    }

    public T getPlayer() {
        return this.player;
    }

    public SkillNode getRootNode() {
        return VampirismMod.proxy.getSkillTree(this.player.isRemote()).getRootNodeForFaction(this.faction.getID());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isNodeEnabled(SkillNode node) {
        for (ISkill s : this.enabledSkills) {
            if (!node.containsSkill(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRefinementEquipped(IRefinement refinement) {
        return this.activeRefinements.contains(refinement);
    }

    @Override
    public boolean isSkillEnabled(ISkill skill) {
        return this.enabledSkills.contains(skill);
    }

    public boolean isSkillNodeLocked(SkillNode nodeIn) {
        return Arrays.stream(nodeIn.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node -> Arrays.stream(node.getElements())).anyMatch(this::isSkillEnabled);
    }

    public void loadFromNbt(CompoundNBT nbt) {
        if (nbt.func_74764_b("skills")) {
            for (String id : nbt.func_74775_l("skills").func_150296_c()) {
                ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(id));
                if (skill == null) {
                    LOGGER.warn("Skill {} does not exist anymore", (Object)id);
                    continue;
                }
                this.enableSkill(skill);
            }
        }
        if (nbt.func_74764_b("refinement_set")) {
            CompoundNBT setsNBT = nbt.func_74775_l("refinement_set");
            for (String id : setsNBT.func_150296_c()) {
                int i = Integer.parseInt(id);
                CompoundNBT setNBT = setsNBT.func_74775_l(id);
                String setName = setNBT.func_74779_i("id");
                int damage = setNBT.func_74762_e("damage");
                if ("none".equals(setName)) continue;
                ResourceLocation setId = new ResourceLocation(setName);
                IRefinementSet set = (IRefinementSet)ModRegistries.REFINEMENT_SETS.getValue(setId);
                this.applyRefinementSet(set, i);
                this.refinementSetDamage[i] = damage;
            }
        }
    }

    public void readUpdateFromServer(CompoundNBT nbt) {
        if (nbt.func_74764_b("skills")) {
            List old = (List)this.enabledSkills.clone();
            for (String id : nbt.func_74775_l("skills").func_150296_c()) {
                ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(id));
                if (skill == null) {
                    LOGGER.error("Skill {} does not exist on client!!!", (Object)id);
                    continue;
                }
                if (old.contains(skill)) {
                    old.remove(skill);
                    continue;
                }
                this.enableSkill(skill);
            }
            for (ISkill skill : old) {
                this.disableSkill(skill);
            }
            VampirismMod.proxy.resetSkillScreenCache();
        }
        if (nbt.func_74764_b("refinement_set")) {
            CompoundNBT setsNBT = nbt.func_74775_l("refinement_set");
            for (String id : setsNBT.func_150296_c()) {
                IRefinementSet oldSet;
                int i = Integer.parseInt(id);
                CompoundNBT setNBT = setsNBT.func_74775_l(id);
                String setName = setNBT.func_74779_i("id");
                int damage = setNBT.func_74762_e("damage");
                IRefinementSet set = null;
                if (!"none".equals(setName)) {
                    set = (IRefinementSet)ModRegistries.REFINEMENT_SETS.getValue(new ResourceLocation(setName));
                }
                if ((oldSet = this.appliedRefinementSets[i]) != set) {
                    this.removeRefinementSet(i);
                    this.applyRefinementSet(set, i);
                }
                this.refinementSetDamage[i] = damage;
            }
        }
    }

    @Override
    public void resetRefinements() {
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            this.removeRefinementSet(i);
        }
    }

    @Override
    public void resetSkills() {
        this.disableAllSkills();
        this.enableRootSkill();
    }

    public void saveToNbt(CompoundNBT nbt) {
        CompoundNBT skills = new CompoundNBT();
        for (ISkill skill : this.enabledSkills) {
            skills.func_74757_a(skill.getRegistryName().toString(), true);
        }
        nbt.func_218657_a("skills", (INBT)skills);
        CompoundNBT refinements = new CompoundNBT();
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            CompoundNBT setNbt = new CompoundNBT();
            IRefinementSet set = this.appliedRefinementSets[i];
            int damage = this.refinementSetDamage[i];
            setNbt.func_74778_a("id", set != null ? set.getRegistryName().toString() : "none");
            setNbt.func_74768_a("damage", damage);
            refinements.func_218657_a(String.valueOf(i), (INBT)setNbt);
        }
        nbt.func_218657_a("refinement_set", (INBT)refinements);
    }

    public void writeUpdateForClient(CompoundNBT nbt) {
        CompoundNBT skills = new CompoundNBT();
        for (ISkill skill : this.enabledSkills) {
            skills.func_74757_a(skill.getRegistryName().toString(), true);
        }
        nbt.func_218657_a("skills", (INBT)skills);
        CompoundNBT refinements = new CompoundNBT();
        for (int i = 0; i < this.appliedRefinementSets.length; ++i) {
            CompoundNBT setNbt = new CompoundNBT();
            IRefinementSet set = this.appliedRefinementSets[i];
            int damage = this.refinementSetDamage[i];
            setNbt.func_74778_a("id", set != null ? set.getRegistryName().toString() : "none");
            setNbt.func_74768_a("damage", damage);
            refinements.func_218657_a(String.valueOf(i), (INBT)setNbt);
        }
        nbt.func_218657_a("refinement_set", (INBT)refinements);
        this.dirty = false;
    }

    private void applyRefinementSet(@Nullable IRefinementSet set, int slot) {
        this.appliedRefinementSets[slot] = set;
        this.refinementSetDamage[slot] = 0;
        if (set != null) {
            Set<IRefinement> refinements = set.getRefinements();
            for (IRefinement refinement : refinements) {
                Attribute a;
                this.activeRefinements.add(refinement);
                if (this.player.isRemote() || (a = refinement.getAttribute()) == null) continue;
                ModifiableAttributeInstance attributeInstance = this.player.getRepresentingPlayer().func_110148_a(a);
                double value = refinement.getModifierValue();
                AttributeModifier t = attributeInstance.func_111127_a(refinement.getUUID());
                if (t != null) {
                    attributeInstance.func_111124_b(t);
                    value += t.func_111164_d();
                }
                t = refinement.createAttributeModifier(refinement.getUUID(), value);
                this.refinementModifier.put(refinement, t);
                attributeInstance.func_233767_b_(t);
            }
        }
    }

    private void removeRefinementSet(int slot) {
        IRefinementSet set = this.appliedRefinementSets[slot];
        this.appliedRefinementSets[slot] = null;
        if (set != null) {
            Set<IRefinement> refinements = set.getRefinements();
            for (IRefinement refinement : refinements) {
                Attribute a;
                this.activeRefinements.remove(refinement);
                if (this.player.isRemote() || (a = refinement.getAttribute()) == null) continue;
                ModifiableAttributeInstance attributeInstance = this.player.getRepresentingPlayer().func_110148_a(a);
                AttributeModifier modifier = this.refinementModifier.get(refinement);
                double value = modifier.func_111164_d() - refinement.getModifierValue();
                this.refinementModifier.remove(refinement);
                attributeInstance.func_111124_b(modifier);
                if (value == 0.0) continue;
                modifier = refinement.createAttributeModifier(modifier.func_111167_a(), value);
                attributeInstance.func_233767_b_(modifier);
                this.refinementModifier.put(refinement, modifier);
                this.activeRefinements.add(refinement);
            }
        }
    }
}

