/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillManager
implements ISkillManager {
    private static final Logger LOGGER = LogManager.getLogger(SkillManager.class);

    @Nonnull
    public ISkill getRootSkill(IPlayableFaction faction) {
        ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(faction.getID());
        if (skill == null) {
            LOGGER.warn("No root skill exists for faction {}", (Object)faction.getID());
            throw new IllegalStateException("You need to register a root skill for your faction " + faction.getID());
        }
        return skill;
    }

    @Override
    public List<ISkill> getSkillsForFaction(IPlayableFaction faction) {
        ArrayList list = Lists.newArrayList((Iterable)ModRegistries.SKILLS.getValues());
        list.removeIf(skill -> !faction.equals(skill.getFaction()));
        return list;
    }

    public void printSkills(IPlayableFaction faction, CommandSource sender) {
        for (ISkill s : this.getSkillsForFaction(faction)) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("ID: " + ModRegistries.SKILLS.getKey((IForgeRegistryEntry)s) + " Skill: ").func_230529_a_(s.getName()), true);
        }
    }
}

