/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.tasks;

import com.google.common.base.Objects;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.player.TaskManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class TaskInstance
implements ITaskInstance {
    @Nonnull
    private final UUID taskGiver;
    @Nonnull
    private final Task task;
    @Nonnull
    private final UUID instanceId;
    @Nonnull
    private final Map<ResourceLocation, Integer> stats;
    @Nonnull
    private final ITaskRewardInstance reward;
    private final long taskDuration;
    private boolean accepted;
    private long taskTimeStamp;
    private boolean completed;

    @Nullable
    public static TaskInstance readNBT(@Nonnull CompoundNBT nbt) {
        Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(nbt.func_74779_i("task")));
        if (task == null) {
            return null;
        }
        UUID id = nbt.func_186857_a("id");
        UUID insId = nbt.func_186857_a("insId");
        boolean accepted = nbt.func_74767_n("accepted");
        long taskTimer = nbt.func_74763_f("taskTimer");
        CompoundNBT statsNBT = nbt.func_74775_l("stats");
        HashMap<ResourceLocation, Integer> stats = new HashMap<ResourceLocation, Integer>();
        statsNBT.func_150296_c().forEach(name -> stats.put(new ResourceLocation(name), statsNBT.func_74762_e(name)));
        ResourceLocation rewardId = new ResourceLocation(nbt.func_74779_i("rewardId"));
        ITaskRewardInstance reward = TaskManager.createReward(rewardId, nbt);
        long taskDuration = nbt.func_74763_f("taskDuration");
        return new TaskInstance(id, task, stats, accepted, taskTimer, insId, reward, taskDuration);
    }

    public static TaskInstance decode(PacketBuffer buffer) {
        UUID id = buffer.func_179253_g();
        Task task = (Task)ModRegistries.TASKS.getValue(buffer.func_192575_l());
        UUID insId = buffer.func_179253_g();
        boolean accepted = buffer.readBoolean();
        long taskTimer = buffer.func_179260_f();
        int statsAmount = buffer.func_150792_a();
        HashMap<ResourceLocation, Integer> stats = new HashMap<ResourceLocation, Integer>();
        for (int i = 0; i < statsAmount; ++i) {
            stats.put(buffer.func_192575_l(), buffer.func_150792_a());
        }
        ResourceLocation rewardId = buffer.func_192575_l();
        ITaskRewardInstance reward = TaskManager.createReward(rewardId, buffer);
        long taskDuration = buffer.func_179260_f();
        return new TaskInstance(id, task, stats, accepted, taskTimer, insId, reward, taskDuration);
    }

    public TaskInstance(@Nonnull Task task, @Nonnull UUID taskGiver, @Nonnull IFactionPlayer<?> player, long taskDuration) {
        this.task = task;
        this.taskGiver = taskGiver;
        this.instanceId = UUID.randomUUID();
        this.stats = new HashMap<ResourceLocation, Integer>();
        this.taskTimeStamp = -1L;
        this.taskDuration = taskDuration;
        this.reward = this.task.getReward().createInstance(player);
    }

    private TaskInstance(@Nonnull UUID taskGiver, @Nonnull Task task, @Nonnull Map<ResourceLocation, Integer> stats, boolean accepted, long taskTimeStamp, @Nonnull UUID instanceId, @Nonnull ITaskRewardInstance taskRewardInstance, long taskDuration) {
        this.taskGiver = taskGiver;
        this.task = task;
        this.stats = stats;
        this.accepted = accepted;
        this.taskTimeStamp = taskTimeStamp;
        this.instanceId = instanceId;
        this.reward = taskRewardInstance;
        this.taskDuration = taskDuration;
    }

    @Override
    public void aboardTask() {
        this.accepted = false;
        this.stats.clear();
        this.taskTimeStamp = -1L;
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.taskGiver);
        buffer.func_192572_a(this.task.getRegistryName());
        buffer.func_179252_a(this.instanceId);
        buffer.writeBoolean(this.accepted);
        buffer.func_179254_b(this.taskTimeStamp);
        buffer.func_150787_b(this.stats.size());
        this.stats.forEach((loc, val) -> {
            buffer.func_192572_a(loc);
            buffer.func_150787_b(val.intValue());
        });
        buffer.func_192572_a(this.reward.getId());
        this.reward.encode(buffer);
        buffer.func_179254_b(this.taskDuration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance instance = (TaskInstance)o;
        return this.accepted == instance.accepted && this.taskTimeStamp == instance.taskTimeStamp && Objects.equal((Object)this.taskGiver, (Object)instance.taskGiver) && Objects.equal((Object)this.instanceId, (Object)instance.instanceId) && Objects.equal((Object)((Object)this.task), (Object)((Object)instance.task)) && Objects.equal(this.stats, instance.stats);
    }

    @Override
    @Nonnull
    public UUID getId() {
        return this.instanceId;
    }

    @Override
    @Nonnull
    public ITaskRewardInstance getReward() {
        return this.reward;
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, Integer> getStats() {
        return this.stats;
    }

    @Override
    public void setStats(@Nonnull Map<ResourceLocation, Integer> newStats) {
        this.stats.clear();
        this.stats.putAll(newStats);
    }

    @Override
    @Nonnull
    public Task getTask() {
        return this.task;
    }

    @Override
    public UUID getTaskBoard() {
        return this.taskGiver;
    }

    @Override
    public long getTaskDuration() {
        return this.taskDuration;
    }

    @Override
    public long getTaskTimeStamp() {
        return this.taskTimeStamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.taskGiver, this.task, this.instanceId});
    }

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isUnique() {
        return this.task.isUnique();
    }

    @Override
    public void startTask(long timestamp) {
        this.taskTimeStamp = timestamp;
        this.accepted = true;
    }

    @Override
    public CompoundNBT writeNBT(@Nonnull CompoundNBT nbt) {
        nbt.func_186854_a("id", this.taskGiver);
        nbt.func_74778_a("task", this.task.getRegistryName().toString());
        nbt.func_186854_a("insId", this.instanceId);
        nbt.func_74757_a("accepted", this.accepted);
        nbt.func_74772_a("taskTimer", this.taskTimeStamp);
        CompoundNBT stats = new CompoundNBT();
        this.stats.forEach((loc, amount) -> stats.func_74768_a(loc.toString(), amount.intValue()));
        nbt.func_218657_a("stats", (INBT)stats);
        nbt.func_74778_a("rewardId", this.reward.getId().toString());
        this.reward.writeNBT(nbt);
        nbt.func_74772_a("taskDuration", this.taskDuration);
        return nbt;
    }
}

