/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.tasks.reward;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class LordLevelReward
implements TaskReward,
ITaskRewardInstance {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "lord_level_reward");
    public final int targetLevel;

    public static LordLevelReward decode(PacketBuffer buffer) {
        return new LordLevelReward(buffer.func_150792_a());
    }

    public static LordLevelReward readNbt(CompoundNBT nbt) {
        return new LordLevelReward(nbt.func_74762_e("targetLevel"));
    }

    public LordLevelReward(int targetLevel) {
        this.targetLevel = targetLevel;
    }

    @Override
    public void applyReward(IFactionPlayer<?> p) {
        FactionPlayerHandler.getOpt(p.getRepresentingPlayer()).ifPresent(fph -> {
            if (fph.getLordLevel() == this.targetLevel - 1) {
                fph.setLordLevel(this.targetLevel);
            }
        });
    }

    @Override
    public ITaskRewardInstance createInstance(IFactionPlayer<?> player) {
        return this;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.targetLevel);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT writeNBT(@Nonnull CompoundNBT nbt) {
        nbt.func_74768_a("targetLevel", this.targetLevel);
        return nbt;
    }
}

