/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.tasks.reward;

import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import de.teamlapen.vampirism.player.refinements.RefinementSet;
import de.teamlapen.vampirism.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.player.tasks.reward.ItemRewardInstance;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.WeightedRandom;

public class RefinementItemReward
extends ItemReward {
    private static final Random RANDOM = new Random();
    @Nullable
    private final IFaction<?> faction;
    @Nullable
    private final IRefinementSet.Rarity rarity;

    public RefinementItemReward(@Nullable IFaction<?> faction) {
        this(faction, null);
    }

    public RefinementItemReward(@Nullable IFaction<?> faction, @Nullable IRefinementSet.Rarity refinementRarity) {
        this(faction, null, refinementRarity);
    }

    public RefinementItemReward(@Nullable IFaction<?> faction, @Nullable VampireRefinementItem item, @Nullable IRefinementSet.Rarity refinementRarity) {
        super(new ItemStack((IItemProvider)item));
        this.faction = faction;
        this.rarity = refinementRarity;
    }

    @Override
    public ItemRewardInstance createInstance(IFactionPlayer<?> player) {
        return new ItemRewardInstance(this.createItem());
    }

    @Override
    public List<ItemStack> getAllPossibleRewards() {
        return (!this.reward.func_190926_b() ? Stream.of((VampireRefinementItem)this.reward.func_77973_b()) : Arrays.stream(IRefinementItem.AccessorySlotType.values()).map(VampireRefinementItem::getItemForType)).map(ItemStack::new).collect(Collectors.toList());
    }

    protected ItemStack createItem() {
        VampireRefinementItem item = VampireRefinementItem.getItemForType(IRefinementItem.AccessorySlotType.values()[RANDOM.nextInt(IRefinementItem.AccessorySlotType.values().length)]);
        IRefinementItem.AccessorySlotType slot = item.getSlotType();
        List sets = ModRegistries.REFINEMENT_SETS.getValues().stream().filter(set -> this.faction == null || set.getFaction() == this.faction).filter(set -> this.rarity == null || set.getRarity().ordinal() >= this.rarity.ordinal()).filter(set -> set.getSlotType().map(slot1 -> slot1 == slot).orElse(true)).map(set -> ((RefinementSet)set).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return new ItemStack((IItemProvider)item);
        }
        IRefinementSet set2 = (IRefinementSet)((WeightedRandomItem)WeightedRandom.func_76271_a((Random)RANDOM, sets)).getItem();
        ItemStack stack = new ItemStack((IItemProvider)item);
        item.applyRefinementSet(stack, set2);
        return stack;
    }
}

