/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVision;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.VampireNightVisionEffectInstance;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import de.teamlapen.vampirism.mixin.ArmorItemAccessor;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import de.teamlapen.vampirism.player.IVampirismPlayer;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.vampire.BloodStats;
import de.teamlapen.vampirism.player.vampire.VampirePlayerDefaultImpl;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirePlayer
extends VampirismPlayer<IVampirePlayer>
implements IVampirePlayer {
    public static final UUID NATURAL_ARMOR_UUID = UUID.fromString("17dcf6d2-30ac-4730-b16a-528353d0abe5");
    private static final Logger LOGGER = LogManager.getLogger(VampirePlayer.class);
    private static final int FEED_TIMER = 20;
    private static final String KEY_EYE = "eye_type";
    private static final String KEY_FANGS = "fang_type";
    private static final String KEY_GLOWING_EYES = "glowing_eyes";
    private static final String KEY_SPAWN_BITE_PARTICLE = "bite_particle";
    private static final String KEY_VISION = "vision";
    private static final String KEY_FEED_VICTIM_ID = "feed_victim";
    private static final String KEY_WING_COUNTER = "wing";
    private static final String KEY_DBNO_TIMER = "dbno";
    private static final String KEY_DBNO_MSG = "dbno_msg";
    @CapabilityInject(value=IVampirePlayer.class)
    public static Capability<IVampirePlayer> CAP = (Capability)UtilLib.getNull();
    private final BloodStats bloodStats;
    private final ActionHandler<IVampirePlayer> actionHandler;
    private final SkillHandler<IVampirePlayer> skillHandler;
    private final List<IVampireVision> unlockedVisions = new ArrayList<IVampireVision>();
    private boolean sundamage_cache = false;
    private EnumStrength garlic_cache = EnumStrength.NONE;
    private int ticksInSun = 0;
    private boolean wasDead = false;
    private IVampireVision activatedVision = null;
    private int wing_counter = 0;
    private int feed_victim = -1;
    private IVampirePlayer.BITE_TYPE feed_victim_bite_type;
    private int feedBiteTickCounter = 0;
    private boolean forceNaturalArmorUpdate;
    private int dbnoTimer = -1;
    private boolean wasDBNO = false;
    @Nullable
    private ITextComponent dbnoMessage;

    public static VampirePlayer get(@Nonnull PlayerEntity player) {
        return (VampirePlayer)player.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get Vampire player capability from player " + player));
    }

    public static LazyOptional<VampirePlayer> getOpt(@Nonnull PlayerEntity player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Vampire player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IVampirePlayer.class, (Capability.IStorage)new Storage(), VampirePlayerDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final PlayerEntity player) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IVampirePlayer inst;
            final LazyOptional<IVampirePlayer> opt;
            {
                this.inst = new VampirePlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public static double getNaturalArmorValue(int lvl) {
        return lvl > 0 ? (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorBaseValue.get()).intValue() + (double)lvl / 14.0 * (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorIncrease.get()).intValue() : 0.0;
    }

    public static double getNaturalArmorToughnessValue(int lvl) {
        return (double)lvl / 14.0 * (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorToughnessIncrease.get()).intValue();
    }

    public VampirePlayer(PlayerEntity player) {
        super(player);
        this.bloodStats = new BloodStats(player);
        this.actionHandler = new ActionHandler<VampirePlayer>(this);
        this.skillHandler = new SkillHandler<IVampirePlayer>(this, VReference.VAMPIRE_FACTION);
    }

    @Override
    public void activateVision(@Nullable IVampireVision vision) {
        if (vision != null && !this.isRemote() && ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        if (!Objects.equals(this.activatedVision, vision)) {
            if (this.activatedVision != null) {
                this.activatedVision.onDeactivated(this);
            }
            this.activatedVision = vision;
            if (vision != null) {
                vision.onActivated(this);
            }
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a(KEY_VISION, this.activatedVision == null ? -1 : ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(this.activatedVision));
                this.sync(nbt, false);
            }
        }
    }

    public void addExhaustion(float exhaustion) {
        if (!this.player.field_71075_bZ.field_75102_a && this.getLevel() > 0 && !this.isRemote()) {
            this.bloodStats.addExhaustion(exhaustion);
        }
    }

    public void biteBlock(BlockPos pos) {
        if (this.player.func_175149_v()) {
            LOGGER.warn("Player can't bite in spectator mode");
            return;
        }
        double dist = this.player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0;
        if (this.player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > dist * dist) {
            LOGGER.warn("Block sent by client is not in reach" + pos);
        } else {
            this.biteBlock(pos, this.player.field_70170_p.func_180495_p(pos), this.player.field_70170_p.func_175625_s(pos));
        }
    }

    public void biteEntity(int entityId) {
        if (this.getLevel() == 0) {
            LOGGER.warn("Player can't bite. Isn't a vampire");
            return;
        }
        Entity e = this.player.func_130014_f_().func_73045_a(entityId);
        if (this.player.func_175149_v()) {
            LOGGER.warn("Player can't bite in spectator mode");
            return;
        }
        if (this.getActionHandler().isActionActive(VampireActions.bat)) {
            LOGGER.warn("Cannot bite in bat mode");
            return;
        }
        if (e instanceof LivingEntity) {
            if ((double)e.func_70032_d((Entity)this.player) <= this.player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0) {
                this.feed_victim_bite_type = this.determineBiteType((LivingEntity)e);
                if (this.feed_victim_bite_type != IVampirePlayer.BITE_TYPE.NONE) {
                    if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.HUNTER_CREATURE) {
                        this.player.func_195064_c(new EffectInstance(ModEffects.poison, 60));
                        if (this.player instanceof ServerPlayerEntity) {
                            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)this.player, VampireActionTrigger.Action.POISONOUS_BITE);
                        }
                    } else {
                        if (this.feed_victim == -1) {
                            this.feedBiteTickCounter = 0;
                        }
                        this.feed_victim = e.func_145782_y();
                        ((LivingEntity)e).func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 7, false, false));
                        this.player.func_195064_c(new EffectInstance(Effects.field_76421_d, 25, 4, false, false));
                        CompoundNBT nbt = new CompoundNBT();
                        nbt.func_74768_a(KEY_FEED_VICTIM_ID, this.feed_victim);
                        this.sync(nbt, true);
                    }
                }
            } else {
                LOGGER.warn("Entity sent by client is not in reach " + entityId);
            }
        }
    }

    @Override
    public float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        EffectInstance protection = this.player.func_70660_b(ModEffects.fire_protection);
        if (protection != null) {
            int amplifier = protection.func_76458_c();
            protectionMod = amplifier >= 5 ? 0.0f : 1.0f / (2.0f + (float)amplifier);
        }
        return amount * protectionMod * (float)LevelAttributeModifier.calculateModifierValue(this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpFireVulnerabilityMod.get(), 0.5);
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return !this.player.func_175149_v() && !this.player.func_184812_l_();
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IVampirePlayer.BITE_TYPE determineBiteType(LivingEntity entity) {
        if (entity instanceof IBiteableEntity && ((IBiteableEntity)entity).canBeBitten(this)) {
            return IVampirePlayer.BITE_TYPE.SUCK_BLOOD;
        }
        if (entity instanceof CreatureEntity && entity.func_70089_S()) {
            LazyOptional<IExtendedCreatureVampirism> opt = ExtendedCreature.getSafe((Entity)entity);
            if (opt.map(creature -> creature.canBeBitten(this)).orElse(false).booleanValue()) {
                if (opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false).booleanValue()) {
                    return IVampirePlayer.BITE_TYPE.HUNTER_CREATURE;
                }
                return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE;
            }
        } else if (entity instanceof PlayerEntity) {
            if (((PlayerEntity)entity).field_71075_bZ.field_75098_d || !Permissions.isPvpEnabled(this.player)) {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
            if (!UtilLib.canReallySee(entity, (LivingEntity)this.player, false) && VampirePlayer.getOpt((PlayerEntity)entity).map(v -> v.canBeBitten(this)).orElse(false).booleanValue() && PermissionAPI.hasPermission((PlayerEntity)this.player, (String)"vampirism.bite.feed.player")) {
                if (!(entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof VampirismHunterArmor)) {
                    return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER;
                }
            } else {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
        }
        return IVampirePlayer.BITE_TYPE.NONE;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        int left = this.bloodStats.addBlood(amt, saturationMod);
        if (useRemaining && left > 0) {
            this.handleSpareBlood(left);
        }
    }

    public void endFeeding(boolean sync) {
        if (this.feed_victim != -1 || this.feed_victim_bite_type != null) {
            this.feed_victim = -1;
            this.feed_victim_bite_type = null;
            if (this.player.func_70644_a(Effects.field_76421_d)) {
                this.player.func_195063_d(Effects.field_76421_d);
            }
        }
        if (sync) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(KEY_FEED_VICTIM_ID, this.feed_victim);
            this.sync(nbt, true);
        }
    }

    @Override
    public IActionHandler<IVampirePlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    @Nullable
    public IVampireVision getActiveVision() {
        return this.activatedVision;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodStats.getBloodLevel();
    }

    @Override
    public float getBloodLevelRelative() {
        if (this.getLevel() == 0) {
            return (float)this.player.func_71024_bL().func_75116_a() / 20.0f;
        }
        return (float)this.bloodStats.getBloodLevel() / (float)this.bloodStats.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return ((Double)VampirismConfig.BALANCE.vpPlayerBloodSaturation.get()).floatValue();
    }

    @Override
    public IBloodStats getBloodStats() {
        return this.bloodStats;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.VAMPIRE_PLAYER_KEY;
    }

    public int getDbnoDuration() {
        int duration = (Integer)VampirismConfig.BALANCE.vpDbnoDuration.get() * 20;
        if (this.skillHandler.isSkillEnabled(VampireSkills.dbno_duration)) {
            duration = Math.max(1, (int)((double)duration * (Double)VampirismConfig.BALANCE.vsDbnoReduction.get()));
        }
        return duration;
    }

    public int getDbnoTimer() {
        return this.dbnoTimer;
    }

    @Override
    @Nullable
    public IFaction getDisguisedAs() {
        return this.isDisguised() ? this.getSpecialAttributes().disguisedAs : this.getFaction();
    }

    public int getEyeType() {
        return this.getSpecialAttributes().eyeType;
    }

    public int getFangType() {
        return this.getSpecialAttributes().fangType;
    }

    public float getFeedProgress() {
        return (float)this.feedBiteTickCounter / 20.0f;
    }

    public boolean getGlowingEyes() {
        return this.getSpecialAttributes().glowingEyes;
    }

    public void setGlowingEyes(boolean value) {
        if (value != this.getSpecialAttributes().glowingEyes) {
            this.getSpecialAttributes().glowingEyes = value;
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a(KEY_GLOWING_EYES, value);
                this.sync(nbt, true);
            }
        }
    }

    @Override
    public int getLevel() {
        return ((IVampirismPlayer)this.player).getVampAtts().vampireLevel;
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    @Nonnull
    public ISkillHandler<IVampirePlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @Nonnull
    public VampirePlayerSpecialAttributes getSpecialAttributes() {
        return ((IVampirismPlayer)this.player).getVampAtts().getVampSpecial();
    }

    @Override
    public int getTicksInSun() {
        return this.ticksInSun;
    }

    public int getWingCounter() {
        return this.wing_counter;
    }

    @Override
    public boolean isAdvancedBiter() {
        return this.getSpecialAttributes().advanced_biter;
    }

    @Override
    public boolean isAutoFillEnabled() {
        return false;
    }

    @Override
    public boolean isDBNO() {
        return this.dbnoTimer >= 0;
    }

    @Override
    public boolean isDisguised() {
        return this.getSpecialAttributes().disguised;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlic_cache = Helper.getGarlicStrength((Entity)this.player, iWorld);
        }
        return this.garlic_cache;
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.sundamage_cache = Helper.gettingSundamge((LivingEntity)this.player, iWorld, this.player.field_70170_p.func_217381_Z()) && !((Object)((Object)ModItems.umbrella)).equals(this.player.func_184614_ca().func_77973_b());
        }
        return this.sundamage_cache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Override
    public void loadData(CompoundNBT nbt) {
        super.loadData(nbt);
        this.bloodStats.readNBT(nbt);
        VampirePlayerSpecialAttributes a = this.getSpecialAttributes();
        a.eyeType = nbt.func_74762_e(KEY_EYE);
        a.fangType = nbt.func_74762_e(KEY_FANGS);
        a.glowingEyes = nbt.func_74767_n(KEY_GLOWING_EYES);
        this.actionHandler.loadFromNbt(nbt);
        this.skillHandler.loadFromNbt(nbt);
        if (nbt.func_74767_n("wasDBNO")) {
            this.wasDBNO = true;
        }
    }

    @Override
    public int onBite(IVampire biter) {
        float perc;
        float f = perc = biter instanceof IVampirePlayer ? 0.2f : 0.08f;
        if (this.getLevel() == 0) {
            int amt = this.player.func_71024_bL().func_75116_a();
            int sucked = (int)Math.ceil((float)amt * perc);
            this.player.func_71024_bL().func_75114_a(amt - sucked);
            this.player.func_71020_j(1000.0f);
            if (!this.player.func_70644_a(ModEffects.sanguinare) && Helper.canTurnPlayer(biter, this.player) && Helper.canBecomeVampire(this.player) && !this.player.func_184812_l_()) {
                SanguinareEffect.addRandom((LivingEntity)this.player, true);
            }
            return sucked;
        }
        int amt = this.getBloodStats().getBloodLevel();
        int sucked = (int)Math.ceil((float)amt * perc);
        this.bloodStats.removeBlood(sucked, true);
        this.sync(this.bloodStats.writeUpdate(new CompoundNBT()), true);
        return sucked;
    }

    @Override
    public void onChangedDimension(RegistryKey<World> from, RegistryKey<World> to) {
    }

    @Override
    public boolean onDeadlyHit(DamageSource source) {
        if (this.getLevel() > 0 && !this.player.func_70644_a(ModEffects.neonatal) && !Helper.canKillVampires(source)) {
            this.setDBNOTimer(this.getDbnoDuration());
            this.player.func_70606_j(0.5f);
            this.player.setForcedPose(Pose.SLEEPING);
            this.resetNearbyTargetingMobs();
            boolean flag = this.player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l);
            if (flag) {
                this.dbnoMessage = this.player.func_110142_aN().func_151521_b();
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(KEY_DBNO_TIMER, this.dbnoTimer);
            if (this.dbnoMessage != null) {
                nbt.func_74778_a(KEY_DBNO_MSG, ITextComponent.Serializer.func_150696_a((ITextComponent)this.dbnoMessage));
            }
            HelperLib.sync(this, nbt, (Entity)this.player, true);
            return true;
        }
        return false;
    }

    @Override
    public void onDeath(DamageSource src) {
        super.onDeath(src);
        if (this.actionHandler.isActionActive(VampireActions.bat) && src.func_76364_f() instanceof ProjectileEntity && this.player instanceof ServerPlayerEntity) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)this.player, VampireActionTrigger.Action.SNIPED_IN_BAT);
        }
        this.actionHandler.deactivateAllActions();
        this.wasDead = true;
        this.setDBNOTimer(-1);
        this.dbnoMessage = null;
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (this.getLevel() > 0) {
            if (this.isDBNO() && !Helper.canKillVampires(src)) {
                if (src.func_76346_g() != null && src.func_76346_g() instanceof MobEntity && ((MobEntity)src.func_76346_g()).func_70638_az() == this.player) {
                    ((MobEntity)src.func_76346_g()).func_70624_b(null);
                }
                return true;
            }
            if (DamageSource.field_76370_b.equals(src)) {
                this.player.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amt));
                return true;
            }
            if (DamageSource.field_76372_a.equals(src) || DamageSource.field_76371_c.equals(src)) {
                this.player.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amt));
                return true;
            }
        }
        this.endFeeding(true);
        if (this.getSpecialAttributes().half_invulnerable) {
            double d = amt;
            double d2 = this.getRepresentingEntity().func_110138_aP();
            double d3 = this.skillHandler.isRefinementEquipped(ModRefinements.half_invulnerable) ? (Double)VampirismConfig.BALANCE.vrHalfInvulnerableThresholdMod.get() : 1.0;
            if (d >= d2 * d3 * (Double)VampirismConfig.BALANCE.vaHalfInvulnerableThreshold.get() && amt < 999.0f) {
                if (this.useBlood((Integer)VampirismConfig.BALANCE.vaHalfInvulnerableBloodCost.get(), false)) {
                    return true;
                }
                this.actionHandler.toggleAction(VampireActions.half_invulnerable);
            }
        }
        return false;
    }

    @Override
    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped(ModRefinements.rage_fury)) {
            int bonus = (Integer)VampirismConfig.BALANCE.vrRageFuryDurationBonus.get() * 20;
            if (victim instanceof PlayerEntity) {
                bonus *= 2;
            }
            this.getActionHandler().extendActionTimer(VampireActions.vampire_rage, bonus);
        }
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
            this.ticksInSun = 0;
            if (this.wasDead) {
                this.player.func_195064_c(new EffectInstance(ModEffects.sunscreen, 400, 4, false, false));
                this.player.func_195064_c(new EffectInstance(ModEffects.armor_regeneration, (Integer)VampirismConfig.BALANCE.vpNaturalArmorRegenDuration.get() * 20, 0, false, false));
                this.requestNaturalArmorUpdate();
                this.player.func_70606_j(this.player.func_110138_aP());
                this.bloodStats.setBloodLevel(this.bloodStats.getMaxBlood());
            }
        }
    }

    @Override
    public void onLevelChanged(int newLevel, int oldLevel) {
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.VAMPIRE_LEVEL_CRITERIA, newLevel);
            this.applyLevelModifiersA(newLevel);
            this.applyLevelModifiersB(newLevel, false);
            if (this.player.func_110143_aJ() > this.player.func_110138_aP()) {
                this.player.func_70606_j(this.player.func_110138_aP());
            }
            this.updateNaturalArmor(newLevel);
            if (newLevel > 13) {
                this.bloodStats.setMaxBlood(40);
            } else if (newLevel > 9) {
                this.bloodStats.setMaxBlood(34);
            } else if (newLevel > 6) {
                this.bloodStats.setMaxBlood(30);
            } else if (newLevel > 3) {
                this.bloodStats.setMaxBlood(26);
            } else {
                this.bloodStats.setMaxBlood(20);
            }
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
                this.skillHandler.resetRefinements();
            }
        } else if (oldLevel == 0) {
            if (this.player.func_70644_a(Effects.field_76439_r)) {
                this.player.func_195063_d(Effects.field_76439_r);
            }
        } else if (newLevel == 0) {
            if (this.player.func_70660_b(Effects.field_76439_r) instanceof VampireNightVisionEffectInstance) {
                this.player.func_195063_d(Effects.field_76439_r);
            }
            this.actionHandler.resetTimers();
            this.skillHandler.resetRefinements();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
        if (this.getLevel() > 0 && !this.player.field_70170_p.field_72995_K) {
            this.player.func_195064_c(new EffectInstance(ModEffects.sunscreen, 200, 4, true, false));
        }
    }

    @Override
    public void onPlayerLoggedOut() {
        this.endFeeding(false);
        if (this.isDBNO()) {
            this.setDBNOTimer(-1);
            this.player.func_70097_a(DamageSource.field_76377_j, 10000.0f);
        }
    }

    public void onSanguinareFinished() {
        if (Helper.canBecomeVampire(this.player) && !this.isRemote() && this.player.func_70089_S()) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(this.player);
            handler.joinFaction((IPlayableFaction<? extends IFactionPlayer<?>>)this.getFaction());
            this.player.func_195064_c(new EffectInstance(Effects.field_76429_m, 300));
            this.player.func_195064_c(new EffectInstance(Effects.field_76443_y, 300));
        }
    }

    @Override
    public void onUpdate() {
        World world = this.player.func_130014_f_();
        world.func_217381_Z().func_76320_a("vampirism_vampirePlayer");
        if (this.wasDBNO) {
            this.wasDBNO = false;
            this.player.func_70097_a(DamageSource.field_76377_j, 100000.0f);
            return;
        }
        if (this.dbnoTimer >= 0) {
            if (this.dbnoTimer > 0) {
                this.setDBNOTimer(this.dbnoTimer - 1);
                if (this.dbnoTimer == 0) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74768_a(KEY_DBNO_TIMER, 0);
                    HelperLib.sync(this, nbt, (Entity)this.player, false);
                }
            }
            this.player.func_70050_g(300);
            this.player.func_213293_j(0.0, Math.min(0.0, this.player.func_213322_ci().func_82617_b()), 0.0);
            this.player.func_195061_cb();
            return;
        }
        super.onUpdate();
        int level = this.getLevel();
        if (level > 0) {
            if (this.player.field_70173_aa % 8 == 0) {
                this.isGettingSundamage((IWorld)world, true);
            }
            if (this.player.field_70173_aa % 40 == 0) {
                this.isGettingGarlicDamage((IWorld)world, true);
            }
        } else {
            this.sundamage_cache = false;
            this.garlic_cache = EnumStrength.NONE;
        }
        if (this.activatedVision != null) {
            this.activatedVision.tick(this);
        }
        if (!this.isRemote()) {
            if (level > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundNBT syncPacket = new CompoundNBT();
                if (this.isGettingSundamage((IWorld)world)) {
                    this.handleSunDamage(false);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
                if (this.isGettingGarlicDamage((IWorld)world) != EnumStrength.NONE) {
                    DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)world), this.player.field_70173_aa);
                }
                if (this.player.func_70089_S()) {
                    this.player.func_70050_g(300);
                    if (this.player.field_70173_aa % 16 == 4 && !this.getSpecialAttributes().waterResistance && !this.player.field_71075_bZ.field_75098_d) {
                        if (this.player.func_70090_H()) {
                            this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, (int)((float)this.getLevel() / (float)this.getMaxLevel() * 3.0f)));
                        } else if (this.player.func_70026_G()) {
                            this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
                        }
                    }
                }
                if (this.player.field_70173_aa % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.player.func_70644_a(Effects.field_76426_n)) {
                    EffectInstance fireResistance = this.player.func_70660_b(Effects.field_76426_n);
                    this.player.func_195064_c(new EffectInstance(ModEffects.fire_protection, fireResistance.func_76459_b(), fireResistance.func_76458_c()));
                    this.player.func_195063_d(Effects.field_76426_n);
                }
                if (this.player.field_70173_aa % 9 == 3 && this.player.func_70644_a(Effects.field_76438_s)) {
                    EffectInstance hunterEffect = this.player.func_70660_b(Effects.field_76438_s);
                    this.player.func_195064_c(new EffectInstance(ModEffects.thirst, hunterEffect.func_76459_b(), hunterEffect.func_76458_c()));
                    this.player.func_195063_d(Effects.field_76438_s);
                }
                if (this.player.field_70173_aa % 64 == 0 && this.player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)this.player).func_147099_x().func_150873_a(this.player, Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n), 1);
                }
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                if (this.feed_victim != -1 && this.feedBiteTickCounter++ >= 20) {
                    this.updateFeeding();
                    this.feedBiteTickCounter = 0;
                }
                if (this.forceNaturalArmorUpdate || this.player.field_70173_aa % 128 == 0) {
                    this.updateNaturalArmor(this.getLevel());
                    this.forceNaturalArmorUpdate = false;
                }
            } else {
                this.ticksInSun = 0;
            }
        } else {
            if (level > 0) {
                VampirismMod.proxy.handleSleepClient(this.player);
                this.actionHandler.updateActions();
                if (this.isGettingSundamage((IWorld)world)) {
                    this.handleSunDamage(true);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
            } else {
                this.ticksInSun = 0;
            }
            if (this.feed_victim != -1 && this.feedBiteTickCounter++ % 5 == 0) {
                Entity e = VampirismMod.proxy.getMouseOverEntity();
                if (e == null || e.func_145782_y() != this.feed_victim) {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("esb", ""));
                    this.feedBiteTickCounter = 0;
                    this.feed_victim = -1;
                    return;
                }
                if (this.feedBiteTickCounter >= 20) {
                    this.feedBiteTickCounter = 0;
                }
            }
        }
        if (this.feed_victim == -1) {
            this.feedBiteTickCounter = 0;
        }
        if (this.wing_counter > 0) {
            --this.wing_counter;
        }
        world.func_217381_Z().func_76319_b();
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END && this.getLevel() > 0 && !this.isDBNO()) {
            this.player.field_70170_p.func_217381_Z().func_76320_a("vampirism_bloodupdate");
            if (!this.player.field_70170_p.field_72995_K && this.bloodStats.onUpdate()) {
                this.sync(this.bloodStats.writeUpdate(new CompoundNBT()), false);
            }
            this.player.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    public void requestNaturalArmorUpdate() {
        this.forceNaturalArmorUpdate = true;
    }

    @Override
    public void saveData(CompoundNBT nbt) {
        super.saveData(nbt);
        this.bloodStats.writeNBT(nbt);
        nbt.func_74768_a(KEY_EYE, this.getEyeType());
        nbt.func_74768_a(KEY_FANGS, this.getFangType());
        nbt.func_74757_a(KEY_GLOWING_EYES, this.getGlowingEyes());
        this.actionHandler.saveToNbt(nbt);
        this.skillHandler.saveToNbt(nbt);
        if (this.isDBNO()) {
            nbt.func_74757_a("wasDBNO", true);
        }
    }

    public boolean setEyeType(int eyeType) {
        if (eyeType >= 16 || eyeType < 0) {
            return false;
        }
        if (eyeType != this.getEyeType()) {
            this.getSpecialAttributes().eyeType = eyeType;
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a(KEY_EYE, eyeType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public boolean setFangType(int fangType) {
        if (fangType >= 7 || fangType < 0) {
            return false;
        }
        if (fangType != this.getFangType()) {
            this.getSpecialAttributes().fangType = fangType;
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a(KEY_FANGS, fangType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(int ... data) {
        if (data.length > 0) {
            this.setFangType(data[0]);
            if (data.length > 1) {
                this.setEyeType(data[1]);
                if (data.length > 2) {
                    this.setGlowingEyes(data[2] > 0);
                }
            }
        }
    }

    public void switchVision() {
        int id = -1;
        if (this.activatedVision != null) {
            id = this.unlockedVisions.indexOf(this.activatedVision);
        }
        if (++id > this.unlockedVisions.size() - 1) {
            id = -1;
        }
        this.activateVision(id == -1 ? null : this.unlockedVisions.get(id));
    }

    public void triggerWings() {
        this.wing_counter = 1200;
        this.sync(true);
    }

    public void tryResurrect() {
        if (this.getDbnoTimer() == 0) {
            this.setDBNOTimer(-1);
            this.dbnoMessage = null;
            this.player.func_70606_j(Math.max(0.5f, (float)(this.bloodStats.getBloodLevel() - 1)));
            this.bloodStats.removeBlood(this.bloodStats.getBloodLevel() - 1, true);
            this.player.setForcedPose(null);
            this.player.func_213323_x_();
            this.sync(true);
            int duration = (Integer)VampirismConfig.BALANCE.vpNeonatalDuration.get() * 20;
            if (this.skillHandler.isSkillEnabled(VampireSkills.neonatal_decrease)) {
                duration = Math.max(1, (int)((double)duration * (Double)VampirismConfig.BALANCE.vsNeonatalReduction.get()));
            }
            this.player.func_195064_c(new EffectInstance(ModEffects.neonatal, duration));
        } else if (this.isRemote()) {
            this.setDBNOTimer(-1);
        } else {
            this.sync(false);
        }
    }

    public void giveUpDBNO() {
        if (this.isDBNO()) {
            this.setDBNOTimer(-1);
            this.dbnoMessage = null;
            this.player.setForcedPose(null);
            this.player.func_213323_x_();
            this.sync(true);
            this.player.func_70097_a(DamageSource.field_76377_j, 10000.0f);
        }
    }

    @Override
    public void unUnlockVision(@Nonnull IVampireVision vision) {
        if (vision.equals(this.activatedVision)) {
            this.activateVision(null);
        }
        this.unlockedVisions.remove(vision);
    }

    @Override
    public void unlockVision(@Nonnull IVampireVision vision) {
        if (((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        this.unlockedVisions.add(vision);
    }

    public void updateNaturalArmor(int lvl) {
        ModifiableAttributeInstance armorAtt = this.player.func_110148_a(Attributes.field_233826_i_);
        ModifiableAttributeInstance toughnessAtt = this.player.func_110148_a(Attributes.field_233827_j_);
        if (armorAtt != null && toughnessAtt != null) {
            if (lvl == 0) {
                armorAtt.func_188479_b(NATURAL_ARMOR_UUID);
                toughnessAtt.func_188479_b(NATURAL_ARMOR_UUID);
            } else {
                AttributeModifier modArmor = armorAtt.func_111127_a(NATURAL_ARMOR_UUID);
                AttributeModifier modToughness = toughnessAtt.func_111127_a(NATURAL_ARMOR_UUID);
                double naturalArmor = VampirePlayer.getNaturalArmorValue(lvl);
                EffectInstance armorRegen = this.player.func_70660_b(ModEffects.armor_regeneration);
                double armorRegenerationMod = armorRegen == null ? 0.0 : (double)armorRegen.func_76459_b() / ((double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorRegenDuration.get()).intValue() * 20.0);
                double naturalToughness = VampirePlayer.getNaturalArmorToughnessValue(lvl);
                List<UUID> armorItemModifiers = Arrays.asList(ArmorItemAccessor.getModifierUUID_vampirism());
                double baseArmor = armorAtt.func_225504_a_(AttributeModifier.Operation.ADDITION).stream().filter(m -> armorItemModifiers.contains(m.func_111167_a())).map(AttributeModifier::func_111164_d).mapToDouble(Double::doubleValue).sum();
                double baseToughness = toughnessAtt.func_225504_a_(AttributeModifier.Operation.ADDITION).stream().filter(m -> armorItemModifiers.contains(m.func_111167_a())).map(AttributeModifier::func_111164_d).mapToDouble(Double::doubleValue).sum();
                double targetArmor = Math.max(0.0, (naturalArmor *= 1.0 - 0.75 * armorRegenerationMod) - baseArmor);
                double targetToughness = Math.max(0.0, naturalToughness - baseToughness);
                if (modArmor != null && targetArmor != modArmor.func_111164_d()) {
                    armorAtt.func_111124_b(modArmor);
                    modArmor = null;
                }
                if (targetArmor != 0.0 && modArmor == null) {
                    armorAtt.func_233767_b_(new AttributeModifier(NATURAL_ARMOR_UUID, "Natural Vampire Armor", targetArmor, AttributeModifier.Operation.ADDITION));
                }
                if (modToughness != null && targetToughness != modToughness.func_111164_d()) {
                    toughnessAtt.func_111124_b(modToughness);
                    modToughness = null;
                }
                if (targetToughness != 0.0 && modToughness == null) {
                    toughnessAtt.func_233767_b_(new AttributeModifier(NATURAL_ARMOR_UUID, "Natural Vampire Armor Toughness", targetToughness, AttributeModifier.Operation.ADDITION));
                }
                this.applyLevelModifiersB(lvl, (Boolean)VampirismConfig.BALANCE.vpArmorPenalty.get() != false && baseArmor > 7.0);
            }
        }
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return this.bloodStats.removeBlood(amt, allowPartial);
    }

    @Override
    public boolean wantsBlood() {
        return this.getLevel() > 0 && this.bloodStats.needsBlood();
    }

    @Override
    protected VampirismPlayer copyFromPlayer(PlayerEntity old) {
        VampirePlayer oldVampire = VampirePlayer.get(old);
        CompoundNBT nbt = new CompoundNBT();
        oldVampire.saveData(nbt);
        this.loadData(nbt);
        this.wasDead = oldVampire.wasDead;
        return oldVampire;
    }

    @Override
    protected void loadUpdate(CompoundNBT nbt) {
        super.loadUpdate(nbt);
        if (nbt.func_74764_b(KEY_EYE)) {
            this.setEyeType(nbt.func_74762_e(KEY_EYE));
        }
        if (nbt.func_74764_b(KEY_FANGS)) {
            this.setFangType(nbt.func_74762_e(KEY_FANGS));
        }
        if (nbt.func_74764_b(KEY_SPAWN_BITE_PARTICLE)) {
            this.spawnBiteParticle(nbt.func_74762_e(KEY_SPAWN_BITE_PARTICLE));
        }
        if (nbt.func_74764_b(KEY_GLOWING_EYES)) {
            this.setGlowingEyes(nbt.func_74767_n(KEY_GLOWING_EYES));
        }
        if (nbt.func_74764_b(KEY_FEED_VICTIM_ID)) {
            this.feed_victim = nbt.func_74762_e(KEY_FEED_VICTIM_ID);
        }
        if (nbt.func_74764_b(KEY_WING_COUNTER)) {
            this.wing_counter = nbt.func_74762_e(KEY_WING_COUNTER);
        }
        if (nbt.func_74764_b(KEY_DBNO_MSG)) {
            this.dbnoMessage = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i(KEY_DBNO_MSG));
        }
        if (nbt.func_74764_b(KEY_DBNO_TIMER)) {
            boolean wasDBNOClient = this.isDBNO();
            this.setDBNOTimer(nbt.func_74762_e(KEY_DBNO_TIMER));
            if (!wasDBNOClient && this.isDBNO()) {
                VampirismMod.proxy.showDBNOScreen(this.player, this.dbnoMessage);
                this.player.setForcedPose(Pose.SLEEPING);
                this.player.func_213323_x_();
            } else if (wasDBNOClient && !this.isDBNO()) {
                this.player.setForcedPose(null);
                this.player.func_213323_x_();
            }
        }
        this.bloodStats.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
        if (nbt.func_74764_b(KEY_VISION)) {
            IVampireVision vision;
            int id = nbt.func_74762_e(KEY_VISION);
            if (id == -1) {
                vision = null;
            } else {
                vision = ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getVisionOfId(id);
                if (vision == null) {
                    LOGGER.warn("Failed to find vision with id {}", (Object)id);
                }
            }
            this.activateVision(vision);
        }
    }

    @Override
    protected void writeFullUpdate(CompoundNBT nbt) {
        super.writeFullUpdate(nbt);
        nbt.func_74768_a(KEY_EYE, this.getEyeType());
        nbt.func_74768_a(KEY_FANGS, this.getFangType());
        nbt.func_74757_a(KEY_GLOWING_EYES, this.getGlowingEyes());
        nbt.func_74768_a(KEY_FEED_VICTIM_ID, this.feed_victim);
        nbt.func_74768_a(KEY_WING_COUNTER, this.wing_counter);
        this.bloodStats.writeUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
        nbt.func_74768_a(KEY_VISION, this.activatedVision == null ? -1 : ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(this.activatedVision));
        nbt.func_74768_a(KEY_DBNO_TIMER, this.getDbnoTimer());
        if (this.dbnoMessage != null) {
            nbt.func_74778_a(KEY_DBNO_MSG, ITextComponent.Serializer.func_150696_a((ITextComponent)this.dbnoMessage));
        }
    }

    private void applyEntityAttributes() {
        this.player.func_110148_a((Attribute)ModAttributes.sundamage).func_111128_a(((Double)VampirismConfig.BALANCE.vpSundamage.get()).doubleValue());
        this.player.func_110148_a((Attribute)ModAttributes.blood_exhaustion).func_111128_a(((Double)VampirismConfig.BALANCE.vpExhaustionMaxMod.get()).doubleValue());
        this.player.func_110148_a((Attribute)ModAttributes.bite_damage).func_111128_a(0.0);
    }

    private void applyLevelModifiersA(int level) {
        LevelAttributeModifier.applyModifier(this.player, Attributes.field_233818_a_, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpHealthMaxMod.get(), 0.5, AttributeModifier.Operation.ADDITION, true);
        LevelAttributeModifier.applyModifier(this.player, (Attribute)ModAttributes.blood_exhaustion, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpExhaustionMaxMod.get(), 0.5, AttributeModifier.Operation.MULTIPLY_BASE, false);
    }

    private void applyLevelModifiersB(int level, boolean heavyArmor) {
        LevelAttributeModifier.applyModifier(this.player, Attributes.field_233821_d_, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpSpeedMaxMod.get() * (double)(heavyArmor ? 0.5f : 1.0f), 0.5, AttributeModifier.Operation.MULTIPLY_BASE, false);
        LevelAttributeModifier.applyModifier(this.player, Attributes.field_233825_h_, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpAttackSpeedMaxMod.get() * (double)(heavyArmor ? 0.5f : 1.0f), 0.5, AttributeModifier.Operation.MULTIPLY_BASE, false);
    }

    private void biteBlock(@Nonnull BlockPos pos, @Nonnull BlockState blockState, @Nullable TileEntity tileEntity) {
        if (this.isRemote()) {
            return;
        }
        if (this.getLevel() == 0) {
            return;
        }
        if (!this.bloodStats.needsBlood()) {
            return;
        }
        int need = Math.min(8, this.bloodStats.getMaxBlood() - this.bloodStats.getBloodLevel());
        if (((Object)((Object)ModBlocks.blood_container)).equals(blockState.func_177230_c()) && tileEntity != null) {
            tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                FluidStack drained;
                int blood = 0;
                FluidStack drainable = handler.drain(new FluidStack(ModFluids.blood, need * 100), IFluidHandler.FluidAction.SIMULATE);
                if (drainable.getAmount() >= 100 && !(drained = handler.drain(drainable.getAmount() / 100 * 100, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                    blood = drained.getAmount() / 100;
                }
                if (blood > 0) {
                    this.drinkBlood(blood, 0.3f);
                    CompoundNBT updatePacket = this.bloodStats.writeUpdate(new CompoundNBT());
                    this.sync(updatePacket, true);
                }
            });
        }
    }

    private boolean biteFeed(LivingEntity entity) {
        if (this.isRemote()) {
            return true;
        }
        if (this.getLevel() == 0) {
            return false;
        }
        int blood = 0;
        float saturationMod = 1.0f;
        boolean continue_feeding = true;
        if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE && entity.func_70089_S()) {
            LazyOptional<IExtendedCreatureVampirism> opt = ExtendedCreature.getSafe((Entity)entity);
            blood = opt.map(creature -> creature.onBite(this)).orElse(0);
            saturationMod = opt.map(IBiteableEntity::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
            if (this.isAdvancedBiter() && opt.map(IExtendedCreatureVampirism::getBlood).orElse(0) == 1) {
                continue_feeding = false;
            }
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER) {
            blood = VampirePlayer.getOpt((PlayerEntity)entity).map(v -> v.onBite(this)).orElse(0);
            saturationMod = VampirePlayer.getOpt((PlayerEntity)entity).map(VampirePlayer::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD) {
            blood = ((IBiteableEntity)entity).onBite(this);
            saturationMod = ((IBiteableEntity)entity).getBloodSaturation();
        }
        if (blood > 0) {
            this.drinkBlood(blood, saturationMod);
            CompoundNBT updatePacket = this.bloodStats.writeUpdate(new CompoundNBT());
            updatePacket.func_74768_a(KEY_SPAWN_BITE_PARTICLE, entity.func_145782_y());
            this.sync(updatePacket, true);
            if (this.player instanceof ServerPlayerEntity) {
                ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)this.player, VampireActionTrigger.Action.SUCK_BLOOD);
            }
            return continue_feeding;
        }
        return false;
    }

    private void handleSpareBlood(int amt) {
        BloodHelper.fillBloodIntoInventory(this.player, amt * 100);
    }

    private void handleSunDamage(boolean isRemote) {
        float damage;
        int sunscreen;
        EffectInstance potionEffect = this.player.func_70660_b(ModEffects.sunscreen);
        int n = sunscreen = potionEffect == null ? -1 : potionEffect.func_76458_c();
        if (this.ticksInSun < 100) {
            ++this.ticksInSun;
        }
        if (sunscreen >= 5 && this.ticksInSun > 50) {
            this.ticksInSun = 50;
        }
        if (isRemote || this.player.field_71075_bZ.field_75098_d || this.player.field_71075_bZ.field_75102_a) {
            return;
        }
        if (((Boolean)VampirismConfig.BALANCE.vpSundamageNausea.get()).booleanValue() && this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageNauseaMinLevel.get() && this.player.field_70173_aa % 300 == 1 && this.ticksInSun > 50 && sunscreen == -1) {
            this.player.func_195064_c(new EffectInstance(Effects.field_76431_k, 180));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageWeaknessMinLevel.get() && this.player.field_70173_aa % 150 == 3 && sunscreen < 5) {
            this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 152, 0));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageMinLevel.get() && this.ticksInSun >= 100 && this.player.field_70173_aa % 40 == 5 && (damage = (float)this.player.func_110148_a((Attribute)ModAttributes.sundamage).func_111126_e()) > 0.0f) {
            this.player.func_70097_a(VReference.SUNDAMAGE, damage);
        }
    }

    private void resetNearbyTargetingMobs() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.player.func_233580_cy_()).func_72314_b(32.0, 10.0, 32.0);
        this.player.field_70170_p.func_225317_b(MobEntity.class, axisalignedbb).forEach(e -> {
            if (e.func_70638_az() == this.player) {
                e.field_70715_bh.func_220888_c().filter(g -> g.func_220772_j() instanceof TargetGoal).forEach(PrioritizedGoal::func_75251_c);
            }
            if (e instanceof IAngerable) {
                ((IAngerable)e).func_233681_b_(this.player);
            }
        });
    }

    private void setDBNOTimer(int newValue) {
        this.dbnoTimer = newValue;
        this.getSpecialAttributes().isDBNO = this.isDBNO();
    }

    private void spawnBiteParticle(int entityId) {
        Entity entity = this.player.field_70170_p.func_73045_a(entityId);
        if (entity != null) {
            UtilLib.spawnParticles(this.player.field_70170_p, (IParticleData)ParticleTypes.field_197614_g, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.player.func_226277_ct_() - entity.func_226277_ct_(), this.player.func_226278_cu_() - entity.func_226278_cu_(), this.player.func_226281_cx_() - entity.func_226281_cx_(), 10, 1.0f);
        }
        for (int j = 0; j < 16; ++j) {
            Vector3d vec3 = new Vector3d(((double)this.player.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.func_178789_a(-this.player.field_70125_A * (float)Math.PI / 180.0f);
            vec3 = vec3.func_178785_b(-this.player.field_70177_z * (float)Math.PI / 180.0f);
            double d0 = (double)(-this.player.func_70681_au().nextFloat()) * 0.6 - 0.3;
            Vector3d vec31 = new Vector3d(((double)this.player.func_70681_au().nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.func_178789_a(-this.player.field_70125_A * (float)Math.PI / 180.0f);
            vec31 = vec31.func_178785_b(-this.player.field_70177_z * (float)Math.PI / 180.0f);
            vec31 = vec31.func_72441_c(this.player.func_226277_ct_(), this.player.func_226278_cu_() + (double)this.player.func_70047_e(), this.player.func_226281_cx_());
            this.player.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_151034_e)), vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, vec3.field_72450_a, vec3.field_72448_b + 0.05, vec3.field_72449_c);
        }
        this.player.field_70170_p.func_184134_a(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), ModSounds.player_bite, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
    }

    private void updateFeeding() {
        Entity entity = this.player.field_70170_p.func_73045_a(this.feed_victim);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity e = (LivingEntity)entity;
        if (e.func_110143_aJ() == 0.0f) {
            this.endFeeding(true);
            return;
        }
        e.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 7, false, false));
        this.player.func_195064_c(new EffectInstance(Effects.field_76421_d, 25, 4, false, false));
        ModParticles.spawnParticlesServer(this.player.field_70170_p, new FlyingBloodEntityParticleData(ModParticles.flying_blood_entity, this.player.func_145782_y(), true), e.func_226277_ct_(), e.func_226278_cu_() + (double)(e.func_70047_e() / 2.0f), e.func_226281_cx_(), 10, 0.1f, 0.1f, 0.1f, 0.0);
        if (!this.biteFeed(e)) {
            this.endFeeding(true);
        }
        if (!((double)e.func_70032_d((Entity)this.player) <= this.player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0) || e.func_110143_aJ() == 0.0f) {
            this.endFeeding(true);
        }
    }

    private static class Storage
    implements Capability.IStorage<IVampirePlayer> {
        private Storage() {
        }

        public void readNBT(Capability<IVampirePlayer> capability, IVampirePlayer instance, Direction side, INBT nbt) {
            ((VampirePlayer)instance).loadData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IVampirePlayer> capability, IVampirePlayer instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((VampirePlayer)instance).saveData(nbt);
            return nbt;
        }
    }
}

