/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.client.core.ClientEventHandler;
import de.teamlapen.vampirism.client.core.ModBlocksRender;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.core.ModItemsRender;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.core.ModParticleFactories;
import de.teamlapen.vampirism.client.core.ModScreens;
import de.teamlapen.vampirism.client.gui.CustomBossInfoOverlay;
import de.teamlapen.vampirism.client.gui.DBNOScreen;
import de.teamlapen.vampirism.client.gui.GarlicBeaconScreen;
import de.teamlapen.vampirism.client.gui.NameSwordScreen;
import de.teamlapen.vampirism.client.gui.RevertBackScreen;
import de.teamlapen.vampirism.client.gui.ScreenEventHandler;
import de.teamlapen.vampirism.client.gui.SelectActionScreen;
import de.teamlapen.vampirism.client.gui.SelectMinionScreen;
import de.teamlapen.vampirism.client.gui.SkillsScreen;
import de.teamlapen.vampirism.client.gui.SleepInMultiplayerModScreen;
import de.teamlapen.vampirism.client.gui.VampirismHUDOverlay;
import de.teamlapen.vampirism.client.render.RenderHandler;
import de.teamlapen.vampirism.client.render.layers.VampireEntityLayer;
import de.teamlapen.vampirism.client.render.layers.VampirePlayerHeadLayer;
import de.teamlapen.vampirism.client.render.layers.WingsLayer;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.inventory.container.VampirismContainer;
import de.teamlapen.vampirism.network.BloodValuePacket;
import de.teamlapen.vampirism.network.OpenVampireBookPacket;
import de.teamlapen.vampirism.network.PlayEventPacket;
import de.teamlapen.vampirism.network.RequestMinionSelectPacket;
import de.teamlapen.vampirism.network.SkillTreePacket;
import de.teamlapen.vampirism.network.TaskPacket;
import de.teamlapen.vampirism.network.TaskStatusPacket;
import de.teamlapen.vampirism.network.UpdateMultiBossInfoPacket;
import de.teamlapen.vampirism.player.skills.ClientSkillTreeManager;
import de.teamlapen.vampirism.player.skills.SkillTree;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.proxy.CommonProxy;
import de.teamlapen.vampirism.tileentity.GarlicBeaconTileEntity;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SleepInMultiplayerScreen;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Logger LOGGER = LogManager.getLogger(ClientProxy.class);
    private final ClientSkillTreeManager skillTreeManager = new ClientSkillTreeManager();
    private VampirismHUDOverlay overlay;
    private CustomBossInfoOverlay bossInfoOverlay;

    public ClientProxy() {
        RenderHandler renderHandler = new RenderHandler(Minecraft.func_71410_x());
        MinecraftForge.EVENT_BUS.register((Object)renderHandler);
        if (Minecraft.func_71410_x() != null) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)renderHandler);
        }
    }

    public void clearBossBarOverlay() {
        this.bossInfoOverlay.clear();
    }

    @Override
    public void displayGarlicBeaconScreen(GarlicBeaconTileEntity tile, ITextComponent title) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GarlicBeaconScreen(tile, title));
    }

    @Override
    public void displayNameSwordScreen(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new NameSwordScreen(stack));
    }

    @Override
    public void displayRevertBackScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new RevertBackScreen());
    }

    @Override
    @Nullable
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    @Nullable
    public Entity getMouseOverEntity() {
        RayTraceResult r = Minecraft.func_71410_x().field_71476_x;
        if (r instanceof EntityRayTraceResult) {
            return ((EntityRayTraceResult)r).func_216348_a();
        }
        return null;
    }

    @Override
    public float getRenderPartialTick() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    @Override
    public SkillTree getSkillTree(boolean client) {
        return client ? this.skillTreeManager.getSkillTree() : super.getSkillTree(false);
    }

    @Override
    public void handleBloodValuePacket(BloodValuePacket msg) {
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).applyNewResources((Map)msg.getValues()[0].getFirst(), (Integer)msg.getValues()[0].getSecond());
        BloodConversionRegistry.applyNewItemResources((Map)msg.getValues()[1].getFirst(), (Integer)msg.getValues()[1].getSecond());
        BloodConversionRegistry.applyNewFluidResources((Map)msg.getValues()[2].getFirst(), (Integer)msg.getValues()[2].getSecond());
    }

    @Override
    public void handlePlayEventPacket(PlayEventPacket msg) {
        if (msg.type == 1) {
            this.spawnParticles((World)Minecraft.func_71410_x().field_71441_e, msg.pos, Block.func_196257_b((int)msg.stateId));
        }
    }

    @Override
    public void handleRequestMinionSelect(RequestMinionSelectPacket.Action action, List<Pair<Integer, ITextComponent>> minions) {
        Minecraft.func_71410_x().func_147108_a((Screen)new SelectMinionScreen(action, minions));
    }

    @Override
    public void handleSkillTreePacket(SkillTreePacket msg) {
        this.skillTreeManager.loadUpdate(msg);
    }

    @Override
    public void handleSleepClient(PlayerEntity player) {
        if (player.func_70608_bn()) {
            player.func_213374_dv().ifPresent(pos -> {
                if (player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof TentBlock) {
                    if (Minecraft.func_71410_x().field_71462_r instanceof SleepInMultiplayerScreen && !(Minecraft.func_71410_x().field_71462_r instanceof SleepInMultiplayerModScreen)) {
                        Minecraft.func_71410_x().func_147108_a((Screen)new SleepInMultiplayerModScreen("text.vampirism.tent.stop_sleeping"));
                    }
                    TentBlock.setTentSleepPosition(player, pos, (Integer)player.field_70170_p.func_180495_p(pos).func_177229_b((Property)TentBlock.POSITION), (Direction)player.field_70170_p.func_180495_p(pos).func_177229_b((Property)TentBlock.FACING));
                } else if (player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof CoffinBlock && Minecraft.func_71410_x().field_71462_r instanceof SleepInMultiplayerScreen && !(Minecraft.func_71410_x().field_71462_r instanceof SleepInMultiplayerModScreen)) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new SleepInMultiplayerModScreen("text.vampirism.coffin.stop_sleeping"));
                }
            });
        }
    }

    @Override
    public void handleTaskPacket(TaskPacket msg) {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (msg.containerId == container.field_75152_c && container instanceof VampirismContainer) {
            ((VampirismContainer)container).init(msg.taskWrappers, msg.completableTasks, msg.completedRequirements);
        }
    }

    @Override
    public void handleTaskStatusPacket(TaskStatusPacket msg) {
        Container container = Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_71070_bA;
        if (msg.containerId == container.field_75152_c && container instanceof TaskBoardContainer) {
            ((TaskBoardContainer)container).init(msg.available, msg.completableTasks, msg.completedRequirements, msg.taskBoardId);
        }
    }

    @Override
    public void handleUpdateMultiBossInfoPacket(UpdateMultiBossInfoPacket msg) {
        this.bossInfoOverlay.read(msg);
    }

    @Override
    public void handleVampireBookPacket(OpenVampireBookPacket msg) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ReadBookScreen((ReadBookScreen.IBookInfo)new ReadBookScreen.WrittenBookInfo(msg.itemStack)));
    }

    @Override
    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        super.onInitStep(step, event);
        switch (step) {
            case CLIENT_SETUP: {
                ModEntitiesRender.registerEntityRenderer(((FMLClientSetupEvent)event).getMinecraftSupplier());
                ModKeys.register();
                this.registerSubscriptions();
                SelectActionScreen.loadActionOrder();
                ModBlocksRender.register();
                ((Minecraft)((FMLClientSetupEvent)event).getMinecraftSupplier().get()).func_175598_ae().getSkinMap().forEach((k, r) -> r.func_177094_a(new WingsLayer<AbstractClientPlayerEntity, PlayerModel>((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel>)r, player -> VampirePlayer.getOpt((PlayerEntity)player).map(VampirePlayer::getWingCounter).filter(i -> i > 0).isPresent(), (e, m) -> m.field_78115_e)));
                break;
            }
            case LOAD_COMPLETE: {
                ModBlocksRender.registerColors();
                ModItemsRender.registerColors();
                ModParticleFactories.registerFactories();
                event.enqueueWork(ModScreens::registerScreensUnsafe);
                this.skillTreeManager.init();
                this.registerVampireEntityOverlays();
                break;
            }
        }
    }

    @Override
    public void renderScreenFullColor(int ticksOn, int ticksOff, int color) {
        if (this.overlay != null) {
            this.overlay.makeRenderFullColor(ticksOn, ticksOff, color);
        }
    }

    @Override
    public void resetSkillScreenCache() {
        if (Minecraft.func_71410_x().field_71462_r instanceof SkillsScreen) {
            ((SkillsScreen)Minecraft.func_71410_x().field_71462_r).resetToolTipCache();
        }
    }

    @Override
    public void showDBNOScreen(PlayerEntity playerEntity, @Nullable ITextComponent deathMessage) {
        if (playerEntity == Minecraft.func_71410_x().field_71439_g && !playerEntity.func_233643_dh_()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new DBNOScreen(deathMessage));
        }
    }

    private void registerSubscriptions() {
        this.overlay = new VampirismHUDOverlay(Minecraft.func_71410_x());
        this.bossInfoOverlay = new CustomBossInfoOverlay();
        MinecraftForge.EVENT_BUS.register((Object)this.overlay);
        MinecraftForge.EVENT_BUS.register((Object)this.bossInfoOverlay);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ScreenEventHandler());
    }

    private void registerVampireEntityOverlay(EntityRendererManager manager, EntityType<? extends CreatureEntity> type, ResourceLocation loc) {
        EntityRenderer render = (EntityRenderer)manager.field_78729_o.get(type);
        if (render == null) {
            LOGGER.error("Did not find renderer for {}", type);
            return;
        }
        if (!(render instanceof LivingRenderer)) {
            LOGGER.error("Renderer ({}) for {} does not extend RenderLivingEntity", type, (Object)render);
            return;
        }
        LivingRenderer rendererLiving = (LivingRenderer)render;
        rendererLiving.func_177094_a(new VampireEntityLayer(rendererLiving, loc, true));
    }

    private void registerVampireEntityOverlays() {
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        this.registerVampirePlayerHead(manager);
        for (Map.Entry<EntityType<? extends CreatureEntity>, ResourceLocation> entry : VampirismAPI.entityRegistry().getConvertibleOverlay().entrySet()) {
            this.registerVampireEntityOverlay(manager, entry.getKey(), entry.getValue());
        }
    }

    private void registerVampirePlayerHead(EntityRendererManager manager) {
        for (PlayerRenderer renderPlayer : manager.getSkinMap().values()) {
            renderPlayer.func_177094_a((LayerRenderer)new VampirePlayerHeadLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderPlayer));
        }
    }

    private void spawnParticles(World world, BlockPos pos, BlockState state) {
        if (!(world instanceof ClientWorld)) {
            return;
        }
        VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, pos);
        voxelshape.func_197755_b((p_199284_3_, p_199284_5_, p_199284_7_, p_199284_9_, p_199284_11_, p_199284_13_) -> {
            double d1 = Math.min(1.0, p_199284_9_ - p_199284_3_);
            double d2 = Math.min(1.0, p_199284_11_ - p_199284_5_);
            double d3 = Math.min(1.0, p_199284_13_ - p_199284_7_);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
            for (int l = 0; l < i / 2; ++l) {
                for (int i1 = 0; i1 < j / 2; ++i1) {
                    for (int j1 = 0; j1 < k / 2; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_199284_3_;
                        double d8 = d5 * d2 + p_199284_5_;
                        double d9 = d6 * d3 + p_199284_7_;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticle((ClientWorld)world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                    }
                }
            }
        });
    }
}

