/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tests;

import com.google.common.base.Stopwatch;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.fluids.BloodHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Tests {
    private static final Logger LOGGER = LogManager.getLogger(Tests.class);

    public static void runTests(World world, PlayerEntity player) {
        Tests.sendMsg(player, "Starting tests");
        LOGGER.warn("Clearing area", new Object[0]);
        Tests.clearArea(world);
        boolean wasCreative = player.func_184812_l_();
        player.func_71033_a(GameType.SURVIVAL);
        player.func_195064_c(new EffectInstance(Effects.field_76429_m, 40, 100));
        player.func_213373_a(0.0, 5.0, 0.0, true);
        TestInfo info = new TestInfo(world, player, new BlockPos(-20, 2, -20), "BloodFluidHandler");
        Tests.runTest(Tests::bloodFluidHandler, info);
        Tests.runTest(Tests::blockWeaponTableFluids, info.next("BlockWeaponTableFluids"));
        Tests.runLightTest(Tests::checkObjectHolders, "Object holders", player);
        LOGGER.warn("Finished tests -> teleporting player", new Object[0]);
        player.func_213373_a(0.0, 5.0, 0.0, true);
        if (wasCreative) {
            player.func_71033_a(GameType.CREATIVE);
        }
        Tests.sendMsg(player, "Finished tests");
    }

    private static void runTest(Tester tester, TestInfo info) {
        boolean result;
        try {
            result = tester.run(info);
        }
        catch (Throwable t) {
            LOGGER.warn(info.name + " failed with exception %s", new Object[]{t});
            result = false;
        }
        Tests.sendMsg(info.player, info.name + " test " + (result ? "\u00a72was successful\u00a7r" : "\u00a74failed\u00a7r"));
    }

    private static void runLightTest(LightTester tester, String name, @Nullable PlayerEntity player) {
        boolean result;
        try {
            result = tester.run();
        }
        catch (Throwable t) {
            LOGGER.warn(name + " failed with exception {}", new Object[]{t});
            result = false;
        }
        if (player != null) {
            Tests.sendMsg(player, name + " test " + (result ? "\u00a72was successful\u00a7r" : "\u00a74failed\u00a7r"));
        } else {
            String msg = name + "test " + (result ? "was successful" : "failed");
            LOGGER.warn(msg, new Object[0]);
        }
    }

    public static void runBackgroundTests() {
        LOGGER.warn("Running background tests", new Object[0]);
        Stopwatch w = Stopwatch.createStarted();
        Tests.runLightTest(Tests::checkObjectHolders, "Object holders", null);
        LOGGER.warn("Finished background tests after {} ms", new Object[]{w.stop().elapsed(TimeUnit.MILLISECONDS)});
    }

    private static boolean checkObjectHolders() {
        boolean failed = !Tests.checkObjectHolders(ModBiomes.class);
        failed |= !Tests.checkObjectHolders(ModBlocks.class);
        failed |= !Tests.checkObjectHolders(ModEnchantments.class);
        failed |= !Tests.checkObjectHolders(ModEntities.class);
        failed |= !Tests.checkObjectHolders(ModFluids.class);
        failed |= !Tests.checkObjectHolders(ModItems.class);
        failed |= !Tests.checkObjectHolders(ModEffects.class);
        return !(failed |= !Tests.checkObjectHolders(ModSounds.class));
    }

    private static boolean checkObjectHolders(@Nonnull Class clazz) {
        boolean failed = false;
        for (Field f : clazz.getFields()) {
            boolean isMatch;
            int mods = f.getModifiers();
            boolean bl = isMatch = Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods);
            if (!isMatch) continue;
            try {
                if (f.get(null) != null) continue;
                LOGGER.warn("Field {} in class {} is null", new Object[]{f.getName(), clazz.getName()});
                failed = true;
            }
            catch (IllegalAccessException e) {
                LOGGER.error(String.format("Failed to check fields of class %s", clazz.getName()), (Throwable)e);
                return false;
            }
        }
        return !failed;
    }

    private static boolean bloodFluidHandler(TestInfo info) {
        info.world.func_175656_a(info.pos, ModBlocks.blood_container.func_176223_P());
        TileEntity t = info.world.func_175625_s(info.pos);
        LazyOptional opt = t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.func_239631_a_((Random)info.world.field_73012_v));
        opt.ifPresent(handler -> handler.fill(new FluidStack(ModFluids.blood, 10000000), IFluidHandler.FluidAction.EXECUTE));
        int blood = BloodHelper.getBlood((LazyOptional<IFluidHandler>)opt);
        assert (blood > 0) : "Could not fill blood container";
        ItemStack bloodBottle1 = new ItemStack((IItemProvider)ModItems.blood_bottle);
        ItemStack bloodBottle2 = new ItemStack((IItemProvider)ModItems.blood_bottle);
        IFluidHandler handler2 = (IFluidHandler)opt.orElse(null);
        FluidActionResult result1 = FluidUtil.tryFillContainer((ItemStack)bloodBottle1, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result1.isSuccess()) : "Transaction 1 failed";
        bloodBottle1 = result1.getResult();
        FluidActionResult result2 = FluidUtil.tryFillContainer((ItemStack)bloodBottle2, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result2.isSuccess()) : "Transaction 2 failed";
        bloodBottle2 = result2.getResult();
        assert (BloodHelper.getBlood(handler2) < blood) : "Failed to drain from container into bottles";
        FluidActionResult result3 = FluidUtil.tryEmptyContainer((ItemStack)bloodBottle1, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result3.isSuccess()) : "Transaction 3 failed";
        bloodBottle1 = result3.getResult();
        FluidActionResult result4 = FluidUtil.tryEmptyContainer((ItemStack)bloodBottle2, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result4.isSuccess()) : "Transaction 4 failed";
        bloodBottle2 = result4.getResult();
        LOGGER.warn("{} {}", new Object[]{BloodHelper.getBlood(handler2), blood});
        assert (BloodHelper.getBlood(handler2) == blood) : "Lost blood somewhere";
        return true;
    }

    private static boolean blockWeaponTableFluids(TestInfo info) {
        info.world.func_175656_a(info.pos, ModBlocks.weapon_table.func_176223_P());
        info.player.func_184611_a(info.player.func_184600_cs(), new ItemStack((IItemProvider)Items.field_151129_at));
        BlockState block = info.world.func_180495_p(info.pos);
        block.func_227031_a_(info.world, info.player, info.player.func_184600_cs(), new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.func_239631_a_((Random)info.world.field_73012_v), info.pos, false));
        block = info.world.func_180495_p(info.pos);
        assert (info.player.func_184586_b(info.player.func_184600_cs()).func_77973_b().equals(Items.field_151133_ar)) : "Incorrect Fluid Container Handling";
        LOGGER.warn("Block lava level: {}", new Object[]{block.func_177229_b((Property)WeaponTableBlock.LAVA)});
        assert ((Integer)block.func_177229_b((Property)WeaponTableBlock.LAVA) * 200 == 1000) : "Incorrect Fluid Transaction";
        return true;
    }

    private static void sendMsg(PlayerEntity player, String msg) {
        player.func_146105_b((ITextComponent)new StringTextComponent("\u00a71[V-TEST]\u00a7r " + msg), false);
    }

    private static void clearArea(World world) {
        for (int x = -21; x < 22; ++x) {
            for (int y = 1; y < 22; ++y) {
                for (int z = -21; z < 22; ++z) {
                    BlockState s = y == 1 || x == -21 || x == 21 || z == -21 || z == 21 || y == 21 ? ModBlocks.castle_block_dark_stone.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                    world.func_175656_a(new BlockPos(x, y, z), s);
                }
            }
        }
    }

    private static class TestInfo {
        final World world;
        final PlayerEntity player;
        BlockPos pos;
        String name;

        private TestInfo(World world, PlayerEntity player, BlockPos pos, String name) {
            this.world = world;
            this.player = player;
            this.pos = pos;
            this.name = name;
        }

        private TestInfo next(String name) {
            int x = this.pos.func_177958_n();
            int z = this.pos.func_177952_p();
            if ((x += 5) > 20) {
                x = -20;
                if ((z += 5) > 20) {
                    throw new IllegalStateException("Not enough room -> Too many tests");
                }
            }
            this.pos = new BlockPos(x, this.pos.func_177956_o(), z);
            this.name = name;
            return this;
        }
    }

    @FunctionalInterface
    private static interface LightTester {
        public Boolean run() throws Throwable;
    }

    @FunctionalInterface
    private static interface Tester {
        public Boolean run(TestInfo var1) throws Throwable;
    }
}

