/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.ICaptureIgnore;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.event.VampirismVillageEvent;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.api.world.ITotem;
import de.teamlapen.vampirism.blocks.TotemBaseBlock;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.SanguinareEffectInstance;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.FactionVillagerProfession;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.particle.GenericParticleData;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.ServerMultiBossInfo;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class TotemTileEntity
extends TileEntity
implements ITickableTileEntity,
ITotem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RNG = new Random();
    private static final ResourceLocation nonFactionTotem = new ResourceLocation("none");
    private final ServerMultiBossInfo captureInfo = new ServerMultiBossInfo((ITextComponent)new TranslationTextComponent("text.vampirism.village.bossinfo.raid"), BossInfo.Overlay.NOTCHED_10, new Color[0]);
    public long timeSinceLastRaid = 0L;
    private boolean isComplete;
    private boolean isInsideVillage;
    private boolean isDisabled;
    @Nonnull
    private Set<PointOfInterest> village = Sets.newHashSet();
    @Nullable
    private IFaction<?> controllingFaction;
    @Nullable
    private IFaction<?> capturingFaction;
    @Nullable
    private AxisAlignedBB villageArea;
    @Nullable
    private AxisAlignedBB villageAreaReduced;
    @Nullable
    private IFaction<?> forcedFaction;
    private int forcedFactionTimer;
    private boolean forceVillageUpdate;
    private CAPTURE_PHASE phase;
    private int captureTimer;
    private int captureAbortTimer;
    private int captureDuration;
    private int captureForceTargetTimer;
    private float strengthRatio;
    private int badOmenLevel;
    @OnlyIn(value=Dist.CLIENT)
    private long beamRenderCounter;
    @OnlyIn(value=Dist.CLIENT)
    private float beamRenderScale;
    private float[] baseColors = DyeColor.WHITE.func_193349_f();
    private float[] progressColor = DyeColor.WHITE.func_193349_f();

    public static void makeAgressive(VillagerEntity villager) {
        AggressiveVillagerEntity hunter = AggressiveVillagerEntity.makeHunter(villager);
        UtilLib.replaceEntity((LivingEntity)villager, (LivingEntity)hunter);
    }

    public TotemTileEntity() {
        super(ModTiles.totem);
    }

    public void abortCapture() {
        this.applyVictoryBonus(false);
        this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.defended"));
        this.breakCapture();
    }

    public void breakCapture() {
        this.setCapturingFaction(null);
        this.forceVillageUpdate = true;
        this.informEntitiesAboutCaptureStop();
        this.updateBossinfoPlayers(null);
        this.captureInfo.clear();
        VampirismWorld.getOpt(this.field_145850_b).ifPresent(vw -> vw.updateTemporaryArtificialFog(this.field_174879_c, null));
        this.func_70296_d();
    }

    public boolean canPlayerRemoveBlock(PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (!player.func_70089_S()) {
            return false;
        }
        IPlayableFaction<? extends IFactionPlayer<?>> faction = VampirismPlayerAttributes.get((PlayerEntity)player).faction;
        if (faction == this.controllingFaction) {
            if (this.capturingFaction == null) {
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.totem_destroy.fail_other_capturing"), true);
            return false;
        }
        if (faction == this.capturingFaction) {
            if (this.controllingFaction == null) {
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.totem_destroy.fail_other_faction"), true);
            return false;
        }
        if (this.capturingFaction != null || this.controllingFaction != null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.village.totem_destroy.fail_other_faction"), true);
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getBaseColors() {
        return this.baseColors;
    }

    @Override
    @Nullable
    public EntityType<? extends MobEntity> getCaptureEntityForFaction(@Nonnull IFaction<?> faction) {
        return ((CaptureEntityEntry)WeightedRandom.func_76271_a((Random)RNG, faction.getVillageData().getCaptureEntries())).getEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCaptureProgress() {
        return this.capturingFaction == null ? 0 : (this.phase == CAPTURE_PHASE.PHASE_2 ? 80 : (int)((float)this.captureTimer / (float)((Integer)VampirismConfig.BALANCE.viPhase1Duration.get()).intValue() * 80.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getCapturingColors() {
        return this.progressColor;
    }

    @Override
    @Nullable
    public IFaction<?> getCapturingFaction() {
        return this.capturingFaction;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Override
    @Nullable
    public IFaction<?> getControllingFaction() {
        return this.controllingFaction;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getSize() {
        return this.village.size();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void initiateCapture(PlayerEntity player) {
        if (!player.func_70089_S()) {
            return;
        }
        this.initiateCapture(VampirismPlayerAttributes.get((PlayerEntity)player).faction, (arg_0, arg_1) -> ((PlayerEntity)player).func_146105_b(arg_0, arg_1), -1, -1.0f);
    }

    @Override
    @Nonnull
    public AxisAlignedBB getVillageArea() {
        if (this.villageArea == null) {
            this.updateVillageArea();
        }
        return this.villageArea;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getVillageAreaReduced() {
        if (this.villageAreaReduced == null) {
            this.updateVillageArea();
        }
        return this.villageAreaReduced;
    }

    public void initiateCapture(IFaction<?> faction, @Nullable BiConsumer<ITextComponent, Boolean> feedback, int badOmenLevel, float strengthModifier) {
        this.updateTileStatus();
        if (!this.capturePreconditions(faction, feedback == null ? (a, b) -> {} : feedback)) {
            return;
        }
        this.forceVillageUpdate = true;
        this.captureAbortTimer = 0;
        this.captureDuration = 24000;
        this.captureTimer = 0;
        this.captureForceTargetTimer = 0;
        this.setCapturingFaction(faction);
        this.calculateAttackStrength(badOmenLevel, strengthModifier);
        this.timeSinceLastRaid = 0L;
        if (this.controllingFaction == null) {
            this.phase = CAPTURE_PHASE.PHASE_1_NEUTRAL;
            this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.neutral_village_under_attack", new Object[]{faction.getNamePlural()}));
        } else {
            this.phase = CAPTURE_PHASE.PHASE_1_OPPOSITE;
            this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.faction_village_under_attack", new Object[]{this.controllingFaction.getNamePlural(), faction.getNamePlural()}));
        }
        this.func_70296_d();
        this.makeAgressive();
        LOGGER.debug("Initiated capture with strength {} by {} at {} with badomen level {}", (Object)Float.valueOf(this.strengthRatio), (Object)faction.getID(), (Object)this.func_174877_v(), (Object)badOmenLevel);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.badOmenLevel = compound.func_74762_e("badOmenTriggered");
        this.isDisabled = compound.func_74767_n("isDisabled");
        this.isComplete = compound.func_74767_n("isComplete");
        this.isInsideVillage = compound.func_74767_n("isInsideVillage");
        if (compound.func_74764_b("controllingFaction")) {
            this.setControllingFaction(VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(compound.func_74779_i("controllingFaction"))));
        } else {
            this.setControllingFaction(null);
        }
        if (compound.func_74764_b("capturingFaction")) {
            this.setCapturingFaction(VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(compound.func_74779_i("capturingFaction"))));
            this.captureTimer = compound.func_74762_e("captureTimer");
            this.captureDuration = compound.func_74762_e("captureDuration");
            this.phase = CAPTURE_PHASE.valueOf(compound.func_74779_i("phase"));
            this.strengthRatio = compound.func_74760_g("strengthRatio");
            this.captureAbortTimer = compound.func_74762_e("captureAbortTimer");
            if (this.phase == CAPTURE_PHASE.PHASE_2) {
                this.setupPhase2();
            }
        } else {
            this.setCapturingFaction(null);
        }
        if (this.field_145850_b != null && compound.func_74764_b("villageArea")) {
            VampirismWorld.getOpt(this.field_145850_b).ifPresent(vw -> {
                AxisAlignedBB aabb = UtilLib.intToBB(compound.func_74759_k("villageArea"));
                vw.updateArtificialFogBoundingBox(this.field_174879_c, (AxisAlignedBB)(this.controllingFaction == VReference.VAMPIRE_FACTION ? aabb : null));
                if (this.isRaidTriggeredByBadOmen() && this.capturingFaction == VReference.VAMPIRE_FACTION) {
                    vw.updateTemporaryArtificialFog(this.field_174879_c, aabb);
                }
            });
        }
        this.forceVillageUpdate = true;
        ListNBT list = compound.func_150295_c("captureInfo", 10);
        for (INBT inbt : list) {
            Color color = new Color(((CompoundNBT)inbt).func_74762_e("color"), true);
            float perc = ((CompoundNBT)inbt).func_74760_g("perc");
            this.captureInfo.setPercentage(color, perc);
        }
        this.timeSinceLastRaid = compound.func_74763_f("timeSinceLastRaid");
    }

    public void notifyNearbyPlayers(ITextComponent textComponent) {
        for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
            if (player.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) > (double)((Integer)VampirismConfig.BALANCE.viNotifyDistanceSQ.get()).intValue()) continue;
            player.func_146105_b(textComponent, true);
        }
    }

    public boolean initiateCaptureOrIncreaseBadOmenLevel(IFaction<?> faction, @Nullable BiConsumer<ITextComponent, Boolean> feedback, int badOmenLevel, float strengthModifier) {
        if (this.capturingFaction == null) {
            this.initiateCapture(faction, feedback, badOmenLevel, strengthModifier);
            return true;
        }
        if (this.capturingFaction == faction) {
            if (this.phase == CAPTURE_PHASE.PHASE_1_OPPOSITE) {
                int tmpBadOmen = this.badOmenLevel;
                float tmpStrength = this.strengthRatio;
                this.calculateAttackStrength(this.badOmenLevel + badOmenLevel, strengthModifier);
                this.captureTimer /= 2;
                LOGGER.debug("Increase capture from strength {} and badomen level {} to strength {} and badomen level {}", (Object)Float.valueOf(tmpStrength), (Object)tmpBadOmen, (Object)Float.valueOf(this.strengthRatio), (Object)this.badOmenLevel);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRaidTriggeredByBadOmen() {
        return this.badOmenLevel >= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.func_145830_o()) {
            this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    public void ringBell(@Nonnull PlayerEntity playerEntity) {
        if (this.capturingFaction != null) {
            IPlayableFaction<? extends IFactionPlayer<?>> faction = VampirismPlayerAttributes.get((PlayerEntity)playerEntity).faction;
            boolean defender = faction == this.controllingFaction;
            boolean attacker = faction == this.capturingFaction;
            List entities = this.field_145850_b.func_217357_a(LivingEntity.class, this.getVillageArea());
            for (LivingEntity entity : entities) {
                IFaction f = VampirismAPI.factionRegistry().getFaction((Entity)entity);
                if (f == null || entity instanceof ICaptureIgnore || attacker && this.capturingFaction == f || defender && this.controllingFaction == f) continue;
                entity.func_195064_c(new EffectInstance(Effects.field_188423_x, 120));
            }
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("isDisabled", this.isDisabled);
        compound.func_74757_a("isComplete", this.isComplete);
        compound.func_74757_a("isInsideVillage", this.isInsideVillage);
        if (this.controllingFaction != null) {
            compound.func_74778_a("controllingFaction", this.controllingFaction.getID().toString());
        }
        if (this.capturingFaction != null) {
            compound.func_74778_a("capturingFaction", this.capturingFaction.getID().toString());
            compound.func_74768_a("captureTimer", this.captureTimer);
            compound.func_74776_a("strengthRatio", this.strengthRatio);
            compound.func_74768_a("captureDuration", this.captureDuration);
            compound.func_74768_a("captureAbortTimer", this.captureAbortTimer);
            compound.func_74778_a("phase", this.phase.name());
        }
        if (!this.village.isEmpty()) {
            compound.func_74783_a("villageArea", UtilLib.bbToInt(this.getVillageArea()));
        }
        ListNBT list = new ListNBT();
        for (Map.Entry<Color, Float> entry : this.captureInfo.getEntries().entrySet()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("color", entry.getKey().getRGB());
            nbt.func_74776_a("perc", entry.getValue().floatValue());
            list.add((Object)nbt);
        }
        compound.func_218657_a("captureInfo", (INBT)list);
        compound.func_74768_a("badOmenTriggered", this.badOmenLevel);
        compound.func_74772_a("timeSinceLastRaid", this.timeSinceLastRaid);
        return super.func_189515_b(compound);
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            super.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            if (!this.village.isEmpty()) {
                VampirismWorld.getOpt(this.field_145850_b).ifPresent(vw -> {
                    vw.updateArtificialFogBoundingBox(this.field_174879_c, this.controllingFaction == VReference.VAMPIRE_FACTION ? this.getVillageArea() : null);
                    if (this.isRaidTriggeredByBadOmen() && this.capturingFaction == VReference.VAMPIRE_FACTION) {
                        vw.updateTemporaryArtificialFog(this.field_174879_c, this.getVillageArea());
                    }
                });
            }
        }
    }

    public void setForcedFaction(@Nullable IFaction<?> faction) {
        this.forcedFaction = faction;
        this.forcedFactionTimer = 5;
        this.func_70296_d();
    }

    public void func_145843_s() {
        VampirismWorld.getOpt(this.field_145850_b).ifPresent(vw -> vw.updateArtificialFogBoundingBox(this.field_174879_c, null));
        TotemHelper.removeTotem((RegistryKey<World>)this.field_145850_b.func_234923_W_(), this.village, this.field_174879_c, true);
        if (this.capturingFaction != null) {
            this.breakCapture();
        } else {
            this.updateBossinfoPlayers(null);
        }
        super.func_145843_s();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float shouldRenderBeam() {
        if (!this.isComplete || this.isDisabled || !this.isInsideVillage) {
            return 0.0f;
        }
        if (this.capturingFaction == null) {
            return 0.0f;
        }
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        long time = this.field_145850_b.func_82737_E();
        if (this.field_145850_b.field_72995_K) {
            if (time % 10L == 7L && this.controllingFaction != null) {
                ModParticles.spawnParticlesClient(this.field_145850_b, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "generic_4"), 20, this.controllingFaction.getColor().getRGB(), 0.2f), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 3, 30.0, this.field_145850_b.field_73012_v);
            }
        } else {
            if (this.isDisabled) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() instanceof TotemBaseBlock) {
                    this.field_145850_b.func_175655_b(this.field_174879_c.func_177977_b(), true);
                }
            }
            if (time % 20L == 0L) {
                this.updateTileStatus();
            }
            if (!this.checkTileStatus()) {
                if (!this.isInsideVillage && this.capturingFaction != null) {
                    this.breakCapture();
                }
                return;
            }
            if (this.forcedFaction != null) {
                if (this.forcedFactionTimer > 0) {
                    if (this.forcedFactionTimer == 1) {
                        this.breakCapture();
                    }
                    --this.forcedFactionTimer;
                } else {
                    this.setCapturingFaction(this.forcedFaction);
                    this.completeCapture(false, true);
                    this.forcedFaction = null;
                }
            }
            if (this.forceVillageUpdate) {
                this.updateTileStatus();
                this.forceVillageUpdate = false;
            }
            if (time % 12000L == 0L) {
                this.updateVillageArea();
            }
            if (this.capturingFaction != null) {
                if (time % 20L == 0L) {
                    List entities = this.field_145850_b.func_217357_a(LivingEntity.class, this.getVillageArea());
                    this.updateBossinfoPlayers(entities);
                    int currentAttacker = 0;
                    int attackerPlayer = 0;
                    int currentDefender = 0;
                    int defenderPlayer = 0;
                    int neutral = 0;
                    float attackerStrength = 0.0f;
                    float defenderStrength = 0.0f;
                    float attackerHealth = 0.0f;
                    float attackerMaxHealth = 0.0f;
                    float defenderHealth = 0.0f;
                    float defenderMaxHealth = 0.0f;
                    CaptureInfo captureInfo = new CaptureInfo(this);
                    for (LivingEntity entity2 : entities) {
                        IFaction faction = VampirismAPI.factionRegistry().getFaction((Entity)entity2);
                        if (faction == null || entity2 instanceof ICaptureIgnore || !entity2.func_70089_S()) continue;
                        if (this.capturingFaction.equals(faction)) {
                            ++currentAttacker;
                            attackerStrength += this.getStrength(entity2);
                            attackerMaxHealth += entity2.func_110138_aP();
                            attackerHealth += entity2.func_110143_aJ();
                            if (entity2 instanceof PlayerEntity) {
                                ++attackerPlayer;
                            }
                            if (!(entity2 instanceof IVillageCaptureEntity)) continue;
                            ((IVillageCaptureEntity)entity2).attackVillage(captureInfo);
                            continue;
                        }
                        if (faction.equals(this.controllingFaction)) {
                            ++currentDefender;
                            defenderStrength += this.getStrength(entity2);
                            defenderMaxHealth += entity2.func_110138_aP();
                            defenderHealth += entity2.func_110143_aJ();
                            if (entity2 instanceof PlayerEntity) {
                                ++defenderPlayer;
                            }
                            if (!(entity2 instanceof IVillageCaptureEntity)) continue;
                            ((IVillageCaptureEntity)entity2).defendVillage(captureInfo);
                            continue;
                        }
                        ++neutral;
                    }
                    this.captureAbortTimer = currentAttacker == 0 ? ++this.captureAbortTimer : 0;
                    ++this.captureTimer;
                    --this.captureDuration;
                    if (this.phase == CAPTURE_PHASE.PHASE_2) {
                        ++this.captureForceTargetTimer;
                    }
                    if (this.captureDuration == 0 || this.captureAbortTimer > 10) {
                        this.abortCapture();
                    } else {
                        switch (this.phase) {
                            case PHASE_1_NEUTRAL: {
                                if (this.captureTimer >= (Integer)VampirismConfig.BALANCE.viPhase1Duration.get()) {
                                    this.captureTimer = 1;
                                    this.setupPhase2();
                                    this.func_70296_d();
                                    break;
                                }
                                if (this.captureTimer % 2 != 0 || !(attackerStrength < 5.0f)) break;
                                this.spawnCaptureEntity(this.capturingFaction);
                                break;
                            }
                            case PHASE_1_OPPOSITE: {
                                if (this.captureTimer >= (Integer)VampirismConfig.BALANCE.viPhase1Duration.get()) {
                                    this.captureTimer = 1;
                                    this.setupPhase2();
                                    this.func_70296_d();
                                    this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.almost_captured", new Object[]{currentDefender}));
                                    break;
                                }
                                if (this.captureTimer % 2 != 0) break;
                                float max = attackerStrength + defenderStrength;
                                if (attackerStrength / max <= this.strengthRatio) {
                                    this.spawnCaptureEntity(this.capturingFaction);
                                    break;
                                }
                                if (!(defenderStrength / max <= 1.0f - this.strengthRatio)) break;
                                this.spawnCaptureEntity(this.controllingFaction);
                                break;
                            }
                            case PHASE_2: {
                                if (currentDefender == 0) {
                                    ++this.captureTimer;
                                    if (this.captureTimer <= 4) break;
                                    this.completeCapture(true, false);
                                    break;
                                }
                                if (currentAttacker == 0) {
                                    ++this.captureTimer;
                                    if (this.captureTimer <= 4) break;
                                    this.abortCapture();
                                    break;
                                }
                                this.captureTimer = 1;
                                break;
                            }
                        }
                        this.handleBossBar(defenderMaxHealth, defenderHealth, attackerMaxHealth, attackerHealth);
                    }
                }
            } else {
                ++this.timeSinceLastRaid;
                if (this.controllingFaction != null && time % 512L == 0L) {
                    List guards;
                    int defenderNumMax;
                    int max;
                    int beds = (int)((ServerWorld)this.field_145850_b).func_217443_B().func_219146_b(pointOfInterestType -> pointOfInterestType.equals(PointOfInterestType.field_221069_q), this.field_174879_c, (int)Math.sqrt(Math.pow(this.getVillageArea().func_216364_b(), 2.0) + Math.pow(this.getVillageArea().func_216362_d(), 2.0)) / 2, PointOfInterestManager.Status.ANY).count();
                    boolean spawnTaskMaster = RNG.nextInt(6) == 0;
                    int villager = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea().func_186662_g(20.0)).size();
                    if (villager < (max = Math.min(beds, (Integer)VampirismConfig.BALANCE.viMaxVillagerRespawn.get()))) {
                        boolean isConverted;
                        boolean bl = isConverted = this.controllingFaction == VReference.VAMPIRE_FACTION && RNG.nextBoolean();
                        if (isConverted) {
                            this.spawnVillagerVampire();
                        } else {
                            this.spawnVillagerDefault(this.controllingFaction == VReference.HUNTER_FACTION);
                        }
                    } else {
                        spawnTaskMaster = true;
                    }
                    if (spawnTaskMaster && this.field_145850_b.func_175647_a(VampirismEntity.class, this.getVillageArea(), entity -> entity instanceof ITaskMasterEntity).isEmpty()) {
                        this.spawnTaskMaster();
                    }
                    if ((defenderNumMax = Math.min(6, this.village.size() / 5)) > (guards = this.field_145850_b.func_217357_a(this.controllingFaction.getVillageData().getGuardSuperClass(), this.getVillageArea())).size()) {
                        EntityType<? extends MobEntity> entityType = this.getCaptureEntityForFaction(this.controllingFaction);
                        this.spawnEntity((MobEntity)entityType.func_200721_a(this.field_145850_b));
                    }
                }
                if (this.controllingFaction != null && ((Boolean)VampirismConfig.BALANCE.viReplaceBlocks.get()).booleanValue() && time % 20L == 0L) {
                    int x = (int)(this.getVillageArea().field_72340_a + (double)RNG.nextInt((int)(this.getVillageArea().field_72336_d - this.getVillageArea().field_72340_a)));
                    int z = (int)(this.getVillageArea().field_72339_c + (double)RNG.nextInt((int)(this.getVillageArea().field_72334_f - this.getVillageArea().field_72339_c)));
                    BlockPos pos = new BlockPos(x, this.field_145850_b.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x, 0, z)).func_177956_o() - 1, z);
                    BlockState b = this.field_145850_b.func_180495_p(pos);
                    boolean flag = false;
                    if (VReference.VAMPIRE_FACTION.equals(this.controllingFaction)) {
                        if (!(this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BushBlock) && b.func_177230_c() == this.field_145850_b.func_226691_t_(pos).func_242440_e().func_242502_e().func_204108_a().func_177230_c() && b.func_177230_c() != Blocks.field_150354_m) {
                            this.field_145850_b.func_217377_a(pos.func_177984_a(), false);
                            this.field_145850_b.func_175656_a(pos, ModBlocks.cursed_earth.func_176223_P());
                            if (this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_196804_gh) {
                                this.field_145850_b.func_217377_a(pos.func_177984_a(), false);
                                flag = true;
                            }
                        }
                    } else if (this.controllingFaction == VReference.HUNTER_FACTION && b.func_177230_c() == ModBlocks.cursed_earth) {
                        this.field_145850_b.func_175656_a(pos, this.field_145850_b.func_226691_t_(pos).func_242440_e().func_242502_e().func_204108_a());
                        flag = true;
                    }
                    if (!flag) {
                        VampirismEventFactory.fireReplaceVillageBlockEvent(this, b, pos);
                    }
                }
                if (this.timeSinceLastRaid > 12000L && time % 20L == 0L && this.field_145850_b.func_175659_aa() != Difficulty.PEACEFUL && (double)this.field_145850_b.field_73012_v.nextFloat() < (Double)VampirismConfig.BALANCE.viRandomRaidChance.get()) {
                    ArrayList factions = Lists.newArrayList((Object[])VampirismAPI.factionRegistry().getFactions());
                    if (this.controllingFaction != null) {
                        factions.remove(this.controllingFaction);
                    }
                    this.initiateCapture((IFaction)factions.get(this.field_145850_b.field_73012_v.nextInt(factions.size())), null, 0, -1.0f);
                }
            }
        }
    }

    public void updateTileStatus() {
        Set<PointOfInterest> points;
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        Block b = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        this.isComplete = b instanceof TotemTopBlock && this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().equals((Object)ModBlocks.totem_base);
        if (!this.isComplete) {
            return;
        }
        ResourceLocation blockFaction = ((TotemTopBlock)b).faction;
        if (!blockFaction.equals((Object)(this.controllingFaction == null ? nonFactionTotem : this.controllingFaction.getID()))) {
            this.forcedFaction = VampirismAPI.factionRegistry().getFactionByID(blockFaction);
        }
        if (!(this.isInsideVillage = !(points = TotemHelper.getVillagePointsOfInterest((ServerWorld)this.field_145850_b, this.field_174879_c)).isEmpty())) {
            this.village = Collections.emptySet();
            if (this.controllingFaction != null) {
                this.setControllingFaction(null);
            }
        } else if (7 != TotemHelper.isVillage(points, (ServerWorld)this.field_145850_b, this.field_174879_c, this.controllingFaction != null || this.capturingFaction != null)) {
            this.isInsideVillage = false;
            this.village = Collections.emptySet();
            if (this.controllingFaction != null) {
                this.setControllingFaction(null);
            }
        } else {
            this.isDisabled = !TotemHelper.addTotem((ServerWorld)this.field_145850_b, points, this.field_174879_c);
            if (!this.isDisabled) {
                this.village.removeIf(points::contains);
                TotemHelper.removeTotem((RegistryKey<World>)this.field_145850_b.func_234923_W_(), this.village, this.field_174879_c, false);
                this.village = points;
            } else {
                this.village = Collections.emptySet();
            }
        }
        this.func_70296_d();
    }

    public void updateTrainer(boolean toDummy) {
        Object entityType;
        List trainer;
        if (toDummy) {
            trainer = this.field_145850_b.func_217357_a(HunterTrainerEntity.class, this.getVillageArea());
            entityType = ModEntities.hunter_trainer_dummy;
        } else {
            trainer = this.field_145850_b.func_217357_a(DummyHunterTrainerEntity.class, this.getVillageArea());
            entityType = ModEntities.hunter_trainer;
        }
        for (VampirismEntity oldEntity : trainer) {
            VampirismEntity newEntity = (VampirismEntity)entityType.func_200721_a(this.field_145850_b);
            if (newEntity == null) continue;
            newEntity.func_180432_n((Entity)oldEntity);
            newEntity.func_184221_a(MathHelper.func_188210_a());
            newEntity.func_184224_h(true);
            UtilLib.replaceEntity((LivingEntity)oldEntity, (LivingEntity)newEntity);
        }
    }

    private void applyVictoryBonus(boolean attackWin) {
        for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
            if (player.func_175149_v() || !this.getVillageArea().func_72318_a(player.func_213303_ch()) || player.func_175149_v() || VampirismAPI.factionRegistry().getFaction((Entity)player) != (attackWin ? this.capturingFaction : this.controllingFaction)) continue;
            if (!attackWin) {
                player.func_195064_c(new EffectInstance(Effects.field_220310_F, 48000, Math.max(this.badOmenLevel - 1, 0), false, false, true));
            }
            player.func_195066_a(ModStats.win_village_capture);
            if (attackWin) {
                player.func_195066_a(ModStats.capture_village);
                continue;
            }
            player.func_195066_a(ModStats.defend_village);
        }
    }

    private boolean capturePreconditions(@Nullable IFaction<?> faction, @Nonnull BiConsumer<ITextComponent, Boolean> feedback) {
        if (faction == null) {
            feedback.accept((ITextComponent)new TranslationTextComponent("text.vampirism.village.no_faction"), true);
            return false;
        }
        if (this.capturingFaction != null) {
            feedback.accept((ITextComponent)new TranslationTextComponent("text.vampirism.village.capturing_in_progress"), true);
            return false;
        }
        if (faction.equals(this.controllingFaction)) {
            feedback.accept((ITextComponent)new TranslationTextComponent("text.vampirism.village.same_faction"), true);
            return false;
        }
        if (!this.isInsideVillage) {
            if (this.getControllingFaction() != null) {
                this.setControllingFaction(null);
                this.func_70296_d();
            }
            Map<Integer, Integer> stats = TotemHelper.getVillageStats(TotemHelper.getVillagePointsOfInterest((ServerWorld)this.field_145850_b, this.field_174879_c), this.field_145850_b);
            int status = TotemHelper.isVillage(stats, this.controllingFaction != null || this.capturingFaction != null);
            TranslationTextComponent text = new TranslationTextComponent("text.vampirism.village.missing_components");
            if ((status & 1) == 0) {
                text.func_240702_b_("\n  - ");
                text.func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampirism.village.missing_components.home"));
                text.func_240702_b_(" " + stats.get(1) + "/" + 4);
            }
            if ((status & 2) == 0) {
                text.func_240702_b_("\n  - ");
                text.func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampirism.village.missing_components.workstations"));
                text.func_240702_b_(" " + stats.get(2) + "/" + 2);
            }
            if ((status & 4) == 0) {
                text.func_240702_b_("\n  - ");
                text.func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampirism.village.missing_components.villager"));
                text.func_240702_b_(" " + stats.get(4) + "/" + 4);
            }
            feedback.accept((ITextComponent)text, false);
            return false;
        }
        if (this.isDisabled) {
            feedback.accept((ITextComponent)new TranslationTextComponent("text.vampirism.village.othertotem"), true);
            return false;
        }
        VampirismVillageEvent.InitiateCapture event = new VampirismVillageEvent.InitiateCapture(this, faction);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult().equals((Object)Event.Result.DENY)) {
            feedback.accept((ITextComponent)new TranslationTextComponent(event.getMessage()), true);
            return false;
        }
        return true;
    }

    private void completeCapture(boolean notifyPlayer, boolean fullConvert) {
        this.informEntitiesAboutCaptureStop();
        if (!this.field_145850_b.field_72995_K) {
            this.updateCreaturesOnCapture(fullConvert);
        }
        this.applyVictoryBonus(true);
        this.setControllingFaction(this.capturingFaction);
        this.setCapturingFaction(null);
        if (notifyPlayer) {
            assert (this.controllingFaction != null);
            this.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.village_captured_by", new Object[]{this.controllingFaction.getNamePlural()}));
        }
        this.updateBossinfoPlayers(null);
        this.func_70296_d();
    }

    private void calculateAttackStrength(int badOmenLevel, float strengthModifier) {
        this.badOmenLevel = MathHelper.func_76125_a((int)badOmenLevel, (int)-1, (int)5);
        int level = this.badOmenLevel - 1;
        float defenderStrength = 1.0f;
        float attackerStrength = 1.0f;
        if (level >= 0) {
            attackerStrength += 0.25f + 0.4375f * (float)level;
        }
        if (strengthModifier > 0.0f) {
            attackerStrength += strengthModifier;
        } else {
            defenderStrength -= strengthModifier;
        }
        Pair<Float, Float> strength = VampirismEventFactory.fireDefineRaidStrengthEvent(this, level, defenderStrength, attackerStrength);
        this.strengthRatio = ((Float)strength.getRight()).floatValue() / (((Float)strength.getLeft()).floatValue() + ((Float)strength.getRight()).floatValue());
    }

    private void informEntitiesAboutCaptureStop() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List list = this.field_145850_b.func_217357_a(CreatureEntity.class, this.getVillageArea());
        for (CreatureEntity e : list) {
            if (!(e instanceof IVillageCaptureEntity)) continue;
            ((IVillageCaptureEntity)e).stopVillageAttackDefense();
        }
    }

    private boolean checkTileStatus() {
        return this.isComplete && this.isInsideVillage && !this.isDisabled && !this.village.isEmpty();
    }

    private void makeAgressive() {
        if (((Boolean)VampirismConfig.SERVER.disableVillageGuards.get()).booleanValue()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            List villagerEntities = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea());
            for (VillagerEntity villager : villagerEntities) {
                if (!VampirismEventFactory.fireMakeAggressive(this, villager) || !VReference.VAMPIRE_FACTION.equals(this.capturingFaction) || villager instanceof IFactionEntity || villager.func_70874_b() < 0 || RNG.nextInt(3) != 0) continue;
                TotemTileEntity.makeAgressive(villager);
            }
        }
    }

    private float getStrength(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return FactionPlayerHandler.getOpt((PlayerEntity)entity).map(FactionPlayerHandler::getCurrentLevelRelative).orElse(Float.valueOf(0.0f)).floatValue();
        }
        if (entity instanceof ConvertedVillagerEntity) {
            return 0.5f;
        }
        if (entity instanceof IAggressiveVillager) {
            return 0.7f;
        }
        if (entity instanceof VillagerEntity) {
            return 0.4f;
        }
        return 1.0f;
    }

    private void handleBossBar(float defenderMaxHealth, float defenderHealth, float attackerMaxHealth, float attackerHealth) {
        float neutralPerc;
        switch (this.phase) {
            case PHASE_1_NEUTRAL: 
            case PHASE_1_OPPOSITE: {
                neutralPerc = (float)this.captureTimer / (float)((Integer)VampirismConfig.BALANCE.viPhase1Duration.get()).intValue();
                break;
            }
            case PHASE_2: {
                neutralPerc = 1.0f;
                this.captureInfo.setName((ITextComponent)new TranslationTextComponent("text.vampirism.village.bossinfo.remaining"));
                break;
            }
            default: {
                neutralPerc = 0.0f;
            }
        }
        float max = defenderHealth + attackerHealth;
        this.captureInfo.setPercentage(neutralPerc * attackerHealth / max, 1.0f - neutralPerc, neutralPerc * defenderHealth / max);
    }

    private void setCapturingFaction(@Nullable IFaction<?> faction) {
        this.capturingFaction = faction;
        float[] fArray = this.progressColor = faction != null ? faction.getColor().getColorComponents(null) : DyeColor.WHITE.func_193349_f();
        if (faction != null) {
            this.captureInfo.setColors(faction.getColor(), Color.WHITE, this.controllingFaction == null ? Color.WHITE : this.controllingFaction.getColor());
            this.captureInfo.setName((ITextComponent)new TranslationTextComponent("text.vampirism.village.bossinfo.raid", new Object[]{faction.getName().func_230531_f_().func_240699_a_(faction.getChatColor())}));
        }
    }

    private void setControllingFaction(@Nullable IFaction<?> faction) {
        this.controllingFaction = faction;
        float[] fArray = this.baseColors = faction != null ? faction.getColor().getColorComponents(null) : DyeColor.WHITE.func_193349_f();
        if (this.field_145850_b != null) {
            boolean crafted;
            BlockState oldBlockState = this.func_195044_w();
            Block b = oldBlockState.func_177230_c();
            boolean bl = crafted = b instanceof TotemTopBlock && ((TotemTopBlock)b).isCrafted();
            BlockState newBlockState = (faction == null ? (crafted ? ModBlocks.totem_top_crafted : ModBlocks.totem_top) : (crafted ? (Block)faction.getVillageData().getTotemTopBlock().getRight() : (Block)faction.getVillageData().getTotemTopBlock().getLeft())).func_176223_P();
            try {
                this.field_145850_b.func_180501_a(this.field_174879_c, newBlockState, 55);
            }
            catch (IllegalStateException e) {
                LOGGER.error("Setting blockstate from {} to {}", (Object)oldBlockState, (Object)newBlockState);
                LOGGER.error("Failed to set totem blockstate", (Throwable)e);
            }
        }
    }

    private void setupPhase2() {
        if (this.phase != CAPTURE_PHASE.PHASE_2) {
            this.phase = CAPTURE_PHASE.PHASE_2;
            this.captureInfo.setName((ITextComponent)new TranslationTextComponent("text.vampirism.village.bossinfo.remaining"));
        }
    }

    private void spawnCaptureEntity(@Nullable IFaction<?> faction) {
        if (faction == null) {
            return;
        }
        assert (this.field_145850_b instanceof ServerWorld);
        EntityType<? extends MobEntity> entityType = this.getCaptureEntityForFaction(faction);
        if (entityType == null) {
            LOGGER.warn("No village capture entity registered for {}", faction);
            return;
        }
        MobEntity entity = (MobEntity)entityType.func_200721_a(this.field_145850_b);
        if (entity instanceof VampireBaseEntity) {
            ((VampireBaseEntity)entity).setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SIMPLE);
        }
        List players = this.field_145850_b.func_217369_A();
        players.removeIf(PlayerEntity::func_175149_v);
        if (entity != null && !UtilLib.spawnEntityInWorld((ServerWorld)this.field_145850_b, this.getVillageAreaReduced(), (Entity)entity, 50, (List<? extends LivingEntity>)players, SpawnReason.EVENT)) {
            entity.func_70106_y();
            entity = null;
        }
        if (entity instanceof IVillageCaptureEntity) {
            if (faction == this.controllingFaction) {
                ((IVillageCaptureEntity)entity).defendVillage(new CaptureInfo(this));
            } else {
                ((IVillageCaptureEntity)entity).attackVillage(new CaptureInfo(this));
            }
        } else if (entity != null) {
            LOGGER.warn("Creature registered for village capture does not implement IVillageCaptureEntity ({})", (Object)entityType.getRegistryName());
        } else {
            LOGGER.info("Failed to spawn capture creature");
        }
    }

    private void spawnEntity(MobEntity newEntity) {
        assert (this.field_145850_b instanceof ServerWorld);
        UtilLib.spawnEntityInWorld((ServerWorld)this.field_145850_b, this.getVillageAreaReduced(), (Entity)newEntity, 50, (List<? extends LivingEntity>)Lists.newArrayList(), SpawnReason.EVENT);
    }

    private void spawnEntity(MobEntity newEntity, MobEntity oldEntity, boolean replaceOld, boolean copyData) {
        if (copyData) {
            newEntity.func_180432_n((Entity)oldEntity);
        } else {
            newEntity.func_82149_j((Entity)oldEntity);
        }
        newEntity.func_184221_a(MathHelper.func_188210_a());
        assert (this.field_145850_b != null);
        if (replaceOld) {
            UtilLib.replaceEntity((LivingEntity)oldEntity, (LivingEntity)newEntity);
        } else {
            this.field_145850_b.func_217376_c((Entity)newEntity);
        }
    }

    private void spawnTaskMaster() {
        assert (this.field_145850_b instanceof ServerWorld);
        assert (this.controllingFaction != null);
        EntityType<? extends ITaskMasterEntity> entity = this.controllingFaction.getVillageData().getTaskMasterEntity();
        if (entity != null) {
            ITaskMasterEntity newEntity = (ITaskMasterEntity)entity.func_200721_a(this.field_145850_b);
            newEntity.setHome(this.getVillageAreaReduced());
            UtilLib.spawnEntityInWorld((ServerWorld)this.field_145850_b, this.getVillageAreaReduced(), (Entity)newEntity, 25, (List<? extends LivingEntity>)Lists.newArrayList(), SpawnReason.EVENT);
        }
    }

    private void spawnVillagerDefault(boolean poisonousBlood) {
        VillagerEntity newVillager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        newVillager = VampirismEventFactory.fireSpawnNewVillagerEvent(this, null, newVillager, false, poisonousBlood);
        this.spawnEntity((MobEntity)newVillager);
    }

    private void spawnVillagerReplace(MobEntity oldEntity, boolean poisonousBlood) {
        VillagerEntity newVillager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        if (oldEntity instanceof VillagerEntity) {
            newVillager.func_213390_a(oldEntity.func_213384_dI(), (int)oldEntity.func_213391_dJ());
        }
        newVillager = VampirismEventFactory.fireSpawnNewVillagerEvent(this, oldEntity, newVillager, true, poisonousBlood);
        this.spawnEntity((MobEntity)newVillager, oldEntity, true, true);
    }

    private void spawnVillagerReplaceForced(MobEntity oldEntity, boolean poisonousBlood) {
        VillagerEntity newVillager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
        ExtendedCreature.getSafe((Entity)newVillager).ifPresent(e -> e.setPoisonousBlood(poisonousBlood));
        newVillager.func_82149_j((Entity)oldEntity);
        if (oldEntity instanceof VillagerEntity) {
            newVillager.func_213390_a(oldEntity.func_213384_dI(), (int)oldEntity.func_213391_dJ());
        }
        newVillager = VampirismEventFactory.fireSpawnNewVillagerEvent(this, oldEntity, newVillager, true, poisonousBlood);
        UtilLib.replaceEntity((LivingEntity)oldEntity, (LivingEntity)newVillager);
    }

    private void spawnVillagerVampire() {
        this.spawnEntity((MobEntity)ModEntities.villager_converted.func_200721_a(this.field_145850_b));
    }

    private void updateBossinfoPlayers(@Nullable List<LivingEntity> includedPlayerEntities) {
        HashSet<ServerPlayerEntity> oldList = new HashSet<ServerPlayerEntity>(this.captureInfo.getPlayers());
        if (includedPlayerEntities != null) {
            for (LivingEntity entity : includedPlayerEntities) {
                if (!(entity instanceof ServerPlayerEntity) || oldList.remove(entity)) continue;
                this.captureInfo.addPlayer((ServerPlayerEntity)entity);
            }
        }
        for (ServerPlayerEntity player : oldList) {
            this.captureInfo.removePlayer(player);
        }
    }

    private void updateCreaturesOnCapture(boolean fullConvert) {
        Object hunterEntities;
        List villagerEntities = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea());
        if (VampirismEventFactory.fireVillagerCaptureEventPre(this, villagerEntities, fullConvert)) {
            return;
        }
        if (VReference.HUNTER_FACTION.equals(this.capturingFaction)) {
            hunterEntities = this.field_145850_b.func_217357_a(HunterBaseEntity.class, this.getVillageArea());
            int i = Math.max(2, hunterEntities.size() / 2);
            Iterator iterator = hunterEntities.iterator();
            while (iterator.hasNext()) {
                HunterBaseEntity hunter = (HunterBaseEntity)iterator.next();
                if (hunter instanceof ICaptureIgnore || i-- <= 0) continue;
                this.spawnVillagerReplace((MobEntity)hunter, true);
            }
            for (int o = i; o > 0; --o) {
                this.spawnVillagerDefault(true);
            }
            for (VillagerEntity villager : villagerEntities) {
                ExtendedCreature.getSafe((Entity)villager).ifPresent(e -> e.setPoisonousBlood(true));
            }
            this.updateTrainer(false);
        } else if (VReference.HUNTER_FACTION.equals(this.controllingFaction)) {
            this.updateTrainer(true);
            for (Object villager : villagerEntities) {
                ExtendedCreature.getSafe((Entity)villager).ifPresent(e -> e.setPoisonousBlood(false));
            }
            if (fullConvert) {
                Object villager;
                hunterEntities = this.field_145850_b.func_217357_a(HunterBaseEntity.class, this.getVillageArea());
                villager = hunterEntities.iterator();
                while (villager.hasNext()) {
                    HunterBaseEntity hunter = (HunterBaseEntity)villager.next();
                    if (hunter instanceof ICaptureIgnore) continue;
                    this.spawnEntity((MobEntity)this.getCaptureEntityForFaction(this.capturingFaction).func_200721_a(this.field_145850_b), (MobEntity)hunter, true, false);
                }
            }
        } else {
            this.updateTrainer(true);
        }
        if (VReference.VAMPIRE_FACTION.equals(this.capturingFaction)) {
            for (VillagerEntity villager : villagerEntities) {
                if (!fullConvert) {
                    if (RNG.nextInt(2) == 1) continue;
                    SanguinareEffect.addRandom((LivingEntity)villager, false);
                    continue;
                }
                villager.func_195064_c((EffectInstance)new SanguinareEffectInstance(11));
            }
        } else if (VReference.VAMPIRE_FACTION.equals(this.controllingFaction)) {
            for (VillagerEntity villager : villagerEntities) {
                if (villager.func_70644_a(ModEffects.sanguinare)) {
                    villager.func_195063_d(ModEffects.sanguinare);
                }
                if (!fullConvert || !(villager instanceof ConvertedVillagerEntity)) continue;
                this.spawnVillagerReplaceForced((MobEntity)villager, this.capturingFaction == VReference.HUNTER_FACTION);
            }
            if (fullConvert) {
                List vampireEntities = this.field_145850_b.func_217357_a(VampireBaseEntity.class, this.getVillageArea());
                for (VampireBaseEntity vampire : vampireEntities) {
                    if (vampire instanceof ICaptureIgnore) continue;
                    this.spawnEntity((MobEntity)this.getCaptureEntityForFaction(this.capturingFaction).func_200721_a(this.field_145850_b), (MobEntity)vampire, true, false);
                }
            }
        }
        villagerEntities = this.field_145850_b.func_217357_a(VillagerEntity.class, this.getVillageArea());
        for (VillagerEntity villager : villagerEntities) {
            if (!(villager.func_213700_eh().func_221130_b() instanceof FactionVillagerProfession)) continue;
            villager.func_213753_a(villager.func_213700_eh().func_221126_a(VillagerProfession.field_221151_a));
        }
        VampirismEventFactory.fireVillagerCaptureEventPost(this, villagerEntities, fullConvert);
    }

    private void updateVillageArea() {
        StructureStart<?> start;
        if (this.villageArea != null && this.villageAreaReduced != null && this.village.stream().allMatch(point -> this.villageAreaReduced.func_72318_a(Vector3d.func_237491_b_((Vector3i)point.func_218261_f())))) {
            return;
        }
        AxisAlignedBB totem = TotemHelper.getAABBAroundPOIs(this.village);
        if (totem == null) {
            totem = new AxisAlignedBB(this.field_174879_c);
        }
        if ((start = UtilLib.getStructureStartAt(this.field_145850_b, this.field_174879_c, Structure.field_236381_q_)) != null && start != StructureStart.field_214630_a && start.func_75069_d()) {
            totem = totem.func_111270_a(UtilLib.MBtoAABB(start.func_75071_a()));
        }
        this.villageArea = totem;
        this.villageAreaReduced = totem.func_72314_b(-30.0, -10.0, -30.0);
    }

    public static class CaptureInfo
    implements ICaptureAttributes {
        @Nullable
        private final IFaction<?> defendingFaction;
        @Nullable
        private final IFaction<?> attackingFaction;
        private final AxisAlignedBB villageArea;
        private final BlockPos pos;
        private final boolean shouldForceTargets;

        private CaptureInfo(TotemTileEntity totem) {
            this.defendingFaction = totem.controllingFaction;
            this.attackingFaction = totem.capturingFaction;
            this.villageArea = totem.getVillageAreaReduced();
            this.pos = totem.field_174879_c;
            this.shouldForceTargets = totem.captureForceTargetTimer > (Integer)VampirismConfig.BALANCE.viForceTargetTime.get();
        }

        @Override
        @Nullable
        public IFaction<?> getAttackingFaction() {
            return this.attackingFaction;
        }

        @Override
        @Nullable
        public IFaction<?> getDefendingFaction() {
            return this.defendingFaction;
        }

        @Override
        public BlockPos getPosition() {
            return this.pos;
        }

        @Override
        public AxisAlignedBB getVillageArea() {
            return this.villageArea;
        }

        @Override
        public boolean shouldForceTargets() {
            return this.shouldForceTargets;
        }
    }

    private static enum CAPTURE_PHASE {
        PHASE_1_NEUTRAL,
        PHASE_1_OPPOSITE,
        PHASE_2;

    }
}

