/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IVillageFactionData;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class HunterVillageData
implements IVillageFactionData {
    private final ItemStack banner = HunterVillageData.createBanner();
    private List<CaptureEntityEntry> captureEntityEntries;

    public static ItemStack createBanner() {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196202_er);
        CompoundNBT compoundNBT = itemStack.func_190925_c("BlockEntityTag");
        ListNBT listNBT = new BannerPattern.Builder().func_222477_a(BannerPattern.STRIPE_SMALL, DyeColor.BLACK).func_222477_a(BannerPattern.STRIPE_CENTER, DyeColor.BLACK).func_222477_a(BannerPattern.BORDER, DyeColor.WHITE).func_222477_a(BannerPattern.STRIPE_MIDDLE, DyeColor.BLACK).func_222477_a(BannerPattern.CURLY_BORDER, DyeColor.BLACK).func_222477_a(BannerPattern.STRAIGHT_CROSS, DyeColor.WHITE).func_222476_a();
        compoundNBT.func_218657_a("Patterns", (INBT)listNBT);
        itemStack.func_242395_a(ItemStack.TooltipDisplayFlags.ADDITIONAL);
        itemStack.func_200302_a((ITextComponent)new TranslationTextComponent("block.minecraft.ominous_banner").func_240699_a_(TextFormatting.GOLD));
        return itemStack;
    }

    @Override
    @Nonnull
    public ItemStack getBanner() {
        return this.banner.func_77946_l();
    }

    @Override
    public List<CaptureEntityEntry> getCaptureEntries() {
        if (this.captureEntityEntries == null) {
            this.captureEntityEntries = Lists.newArrayList((Object[])new CaptureEntityEntry[]{new CaptureEntityEntry(ModEntities.hunter, 10)});
        }
        return this.captureEntityEntries;
    }

    @Override
    public VillagerProfession getFactionVillageProfession() {
        return ModVillage.hunter_expert;
    }

    @Override
    public Class<? extends MobEntity> getGuardSuperClass() {
        return HunterBaseEntity.class;
    }

    @Override
    public EntityType<? extends ITaskMasterEntity> getTaskMasterEntity() {
        return ModEntities.task_master_hunter;
    }

    @Override
    public Pair<Block, Block> getTotemTopBlock() {
        return Pair.of((Object)((Object)ModBlocks.totem_top_vampirism_hunter), (Object)((Object)ModBlocks.totem_top_vampirism_hunter_crafted));
    }

    @Override
    public boolean isBanner(@Nonnull ItemStack stack) {
        return ItemStack.func_77989_b((ItemStack)this.banner, (ItemStack)stack);
    }
}

