/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IVillageFactionData;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class VampireVillageData
implements IVillageFactionData {
    private final ItemStack banner = VampireVillageData.createBanner();
    private List<CaptureEntityEntry> captureEntityEntries;

    public static ItemStack createBanner() {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196206_ev);
        CompoundNBT compoundNBT = itemStack.func_190925_c("BlockEntityTag");
        ListNBT listNBT = new BannerPattern.Builder().func_222477_a(BannerPattern.TRIANGLES_BOTTOM, DyeColor.RED).func_222477_a(BannerPattern.TRIANGLES_TOP, DyeColor.RED).func_222477_a(BannerPattern.BORDER, DyeColor.PURPLE).func_222477_a(BannerPattern.RHOMBUS_MIDDLE, DyeColor.RED).func_222477_a(BannerPattern.STRAIGHT_CROSS, DyeColor.RED).func_222477_a(BannerPattern.CIRCLE_MIDDLE, DyeColor.PURPLE).func_222476_a();
        compoundNBT.func_218657_a("Patterns", (INBT)listNBT);
        itemStack.func_242395_a(ItemStack.TooltipDisplayFlags.ADDITIONAL);
        itemStack.func_200302_a((ITextComponent)new TranslationTextComponent("block.minecraft.ominous_banner").func_240699_a_(TextFormatting.GOLD));
        return itemStack;
    }

    @Override
    @Nonnull
    public ItemStack getBanner() {
        return this.banner.func_77946_l();
    }

    @Override
    public List<CaptureEntityEntry> getCaptureEntries() {
        if (this.captureEntityEntries == null) {
            this.captureEntityEntries = Lists.newArrayList((Object[])new CaptureEntityEntry[]{new CaptureEntityEntry(ModEntities.vampire, 10), new CaptureEntityEntry(ModEntities.advanced_vampire, 2)});
        }
        return this.captureEntityEntries;
    }

    @Override
    public VillagerProfession getFactionVillageProfession() {
        return ModVillage.vampire_expert;
    }

    @Override
    public Class<? extends MobEntity> getGuardSuperClass() {
        return VampireBaseEntity.class;
    }

    @Override
    public EntityType<? extends ITaskMasterEntity> getTaskMasterEntity() {
        return ModEntities.task_master_vampire;
    }

    @Override
    public Pair<Block, Block> getTotemTopBlock() {
        return Pair.of((Object)((Object)ModBlocks.totem_top_vampirism_vampire), (Object)((Object)ModBlocks.totem_top_vampirism_vampire_crafted));
    }

    @Override
    public boolean isBanner(@Nonnull ItemStack stack) {
        return ItemStack.func_77989_b((ItemStack)this.banner, (ItemStack)stack);
    }
}

