/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.world.IVampirismWorld;
import de.teamlapen.vampirism.world.VampirismWorldDefaultImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirismWorld
implements IVampirismWorld {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<BlockPos, MutableBoundingBox> fogAreas = Maps.newHashMap();
    private static final Map<BlockPos, MutableBoundingBox> tmpFogAreas = Maps.newHashMap();
    @CapabilityInject(value=IVampirismWorld.class)
    public static Capability<IVampirismWorld> CAP = (Capability)UtilLib.getNull();
    @Nonnull
    private final World world;
    private final HashMap<ChunkPos, EnumStrength> strengthHashMap = Maps.newHashMap();
    private final HashMap<Integer, Emitter> emitterHashMap = Maps.newHashMap();

    public static VampirismWorld get(World world) {
        return (VampirismWorld)world.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get VampirismWorld from World " + world));
    }

    public static LazyOptional<VampirismWorld> getOpt(@Nonnull World world) {
        LazyOptional opt = world.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get world capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IVampirismWorld.class, (Capability.IStorage)new Storage(), VampirismWorldDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final World world) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IVampirismWorld inst;
            final LazyOptional<IVampirismWorld> opt;
            {
                this.inst = new VampirismWorld(world);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    private static boolean isHostingClient() {
        return EffectiveSide.get().isClient() && ServerLifecycleHooks.getCurrentServer() != null;
    }

    public VampirismWorld(@Nonnull World world) {
        this.world = world;
    }

    @Override
    public void clear() {
        this.strengthHashMap.clear();
        this.emitterHashMap.clear();
    }

    @Override
    @Nonnull
    public EnumStrength getStrengthAtChunk(ChunkPos pos) {
        EnumStrength s = this.strengthHashMap.get(pos);
        return s == null ? EnumStrength.NONE : s;
    }

    @Override
    public boolean isInsideArtificialVampireFogArea(BlockPos blockPos) {
        return Stream.concat(fogAreas.entrySet().stream(), tmpFogAreas.entrySet().stream()).anyMatch(entry -> ((MutableBoundingBox)entry.getValue()).func_175898_b((Vector3i)blockPos));
    }

    public void printDebug(CommandSource sender) {
        for (Emitter emitter : this.emitterHashMap.values()) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("E: " + emitter.toString()), true);
        }
        for (Map.Entry entry : this.strengthHashMap.entrySet()) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("S: " + entry.toString()), true);
        }
    }

    @Override
    public int registerGarlicBlock(EnumStrength strength, ChunkPos ... pos) {
        for (ChunkPos p : pos) {
            if (p != null) continue;
            throw new IllegalArgumentException("Garlic emitter position should not be null");
        }
        Emitter e = new Emitter(strength, pos);
        int hash = e.hashCode();
        if (VampirismWorld.isHostingClient()) {
            return hash;
        }
        this.emitterHashMap.put(hash, e);
        this.rebuildStrengthMap();
        return hash;
    }

    @Override
    public void removeGarlicBlock(int id) {
        if (VampirismWorld.isHostingClient()) {
            return;
        }
        Emitter e = this.emitterHashMap.remove(id);
        if (e == null) {
            LOGGER.debug("Removed emitter did not exist");
        }
        this.rebuildStrengthMap();
    }

    public void updateArtificialFogBoundingBox(@Nonnull BlockPos totemPos, @Nullable AxisAlignedBB box) {
        if (box == null) {
            fogAreas.remove(totemPos);
            this.updateTemporaryArtificialFog(totemPos, null);
        } else {
            fogAreas.put(totemPos, UtilLib.AABBtoMB(box));
        }
    }

    public void updateTemporaryArtificialFog(@Nonnull BlockPos totemPos, @Nullable AxisAlignedBB box) {
        if (box == null) {
            tmpFogAreas.remove(totemPos);
        } else {
            tmpFogAreas.put(totemPos, UtilLib.AABBtoMB(box));
        }
    }

    private void loadNBTData(CompoundNBT nbt) {
    }

    private void rebuildStrengthMap() {
        this.strengthHashMap.clear();
        for (Emitter e : this.emitterHashMap.values()) {
            for (ChunkPos pos : e.pos) {
                EnumStrength old = this.strengthHashMap.get(pos);
                if (old != null && !e.strength.isStrongerThan(old)) continue;
                this.strengthHashMap.put(pos, e.strength);
            }
        }
    }

    private void saveNBTData(CompoundNBT nbt) {
    }

    private static class Storage
    implements Capability.IStorage<IVampirismWorld> {
        private Storage() {
        }

        public void readNBT(Capability<IVampirismWorld> capability, IVampirismWorld instance, Direction side, INBT nbt) {
            ((VampirismWorld)instance).loadNBTData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IVampirismWorld> capability, IVampirismWorld instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((VampirismWorld)instance).saveNBTData(nbt);
            return nbt;
        }
    }

    private static class Emitter {
        final EnumStrength strength;
        final ChunkPos[] pos;

        private Emitter(EnumStrength strength, ChunkPos[] pos) {
            this.strength = strength;
            this.pos = pos;
        }

        public String toString() {
            return "Emitter{pos=" + Arrays.toString(this.pos) + ", strength=" + (Object)((Object)this.strength) + '}';
        }
    }
}

