/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.biome;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.mixin.FlatGenerationSettingsAccessor;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;

public class VampirismBiomeFeatures {
    public static final ConfiguredFeature<?, ?> vampire_flower = VampirismBiomeFeatures.registerFeature("vampire_flower", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.vampire_orchid.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5));
    public static final ConfiguredFeature<?, ?> mod_water_lake = VampirismBiomeFeatures.registerFeature("mod_water_lake", ModFeatures.mod_lake.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> vampire_tree = VampirismBiomeFeatures.registerFeature("vampire_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196618_L.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.vampire_spruce_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_()));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> vampire_tree_red = VampirismBiomeFeatures.registerFeature("vampire_tree_red", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.bloody_spruce_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.bloody_spruce_leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_()));
    public static final ConfiguredFeature<?, ?> vampire_trees = VampirismBiomeFeatures.registerFeature("vampire_trees", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)vampire_tree_red.func_227227_a_(0.3f)), vampire_tree)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1))));
    public static final ConfiguredFeature<?, ?> vampire_dungeon = VampirismBiomeFeatures.registerFeature("vampire_dungeon", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ModFeatures.vampire_dungeon.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(256)).func_242728_a()).func_242731_b(2));
    public static final StructureFeature<?, ?> hunter_camp = VampirismBiomeFeatures.registerStructure("hunter_camp", ModFeatures.hunter_camp.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));

    private static <T extends IFeatureConfig> ConfiguredFeature<T, ?> registerFeature(String name, ConfiguredFeature<T, ?> feature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("vampirism", name), feature);
    }

    private static <T extends IFeatureConfig> StructureFeature<T, ?> registerStructure(String name, StructureFeature<T, ?> structure) {
        return (StructureFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("vampirism", name), structure);
    }

    public static void init() {
        if (((Boolean)VampirismConfig.COMMON.enforceTentGeneration.get()).booleanValue()) {
            FlatGenerationSettingsAccessor.getStructures_vampirism().put(ModFeatures.hunter_camp, hunter_camp);
        }
    }

    public static void addVampireFlower(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, vampire_flower);
    }

    public static void addWaterSprings(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243833_af);
    }

    public static void addModdedWaterLake(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.LAKES, mod_water_lake);
    }

    public static void addVampireTrees(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, vampire_trees);
    }
}

