/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;

public class RefinementSetFunction
extends LootFunction {
    @Nullable
    public final IFaction<?> faction;

    public static LootFunction.Builder<?> builder(IFaction<?> faction) {
        return RefinementSetFunction.func_215860_a(conditions -> new RefinementSetFunction((ILootCondition[])conditions, faction));
    }

    public static LootFunction.Builder<?> builder() {
        return RefinementSetFunction.func_215860_a(conditions -> new RefinementSetFunction((ILootCondition[])conditions, null));
    }

    public RefinementSetFunction(@Nonnull ILootCondition[] conditionsIn, @Nullable IFaction<?> faction) {
        super(conditionsIn);
        this.faction = faction;
    }

    @Nonnull
    public LootFunctionType func_230425_b_() {
        return ModLoot.add_refinement_set;
    }

    @Nonnull
    protected ItemStack func_215859_a(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        IRefinementSet set;
        if (stack.func_77973_b() instanceof VampireRefinementItem && (set = VampireRefinementItem.getRandomRefinementForItem(this.faction, (VampireRefinementItem)stack.func_77973_b())) != null) {
            ((VampireRefinementItem)stack.func_77973_b()).applyRefinementSet(stack, set);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<RefinementSetFunction> {
        @Nonnull
        public RefinementSetFunction deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, @Nonnull ILootCondition[] conditionsIn) {
            IFaction faction = null;
            if (json.has("faction")) {
                String string = json.get("faction").getAsString();
                faction = VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(json.get("faction").getAsString()));
                if (faction == null) {
                    throw new IllegalStateException("Faction " + string + " does not exist");
                }
            }
            return new RefinementSetFunction(conditionsIn, faction);
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull RefinementSetFunction function, @Nonnull JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)function, context);
            if (function.faction != null) {
                json.addProperty("faction", function.faction.getID().toString());
            }
        }
    }
}

