/*
 * Decompiled with CFR 0.152.
 */
package com.barion.block_variants.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModItemModels
extends ItemModelProvider {
    public ModItemModels(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "block_variants", fileHelper);
    }

    protected void registerModels() {
        this.regWall("polished_diorite");
        this.regWall("polished_granite");
        this.regWall("polished_andesite");
        this.regWall("stone");
        this.regStairs("smooth_stone", "smooth_stone_slab_side", "smooth_stone");
        this.regWall("smooth_stone");
        this.regWall("cut_sandstone");
        this.regStairs("cut_sandstone", "cut_sandstone", "sandstone_top");
        this.regWall("cut_red_sandstone");
        this.regStairs("cut_red_sandstone", "cut_red_sandstone", "red_sandstone_top");
        this.regWall("quartz", "quartz_block_top");
        this.regAll("quartz_bricks");
        this.regWall("smooth_quartz", "quartz_block_bottom");
        this.regAllWithTop("chiseled_quartz_block", "chiseled_quartz_block_top");
        this.regWall("dark_prismarine");
        this.regWall("prismarine_bricks");
        this.regAll("netherrack");
        this.regAll("end_stone");
        this.regAll("cracked_polished_blackstone_brick", "cracked_polished_blackstone_bricks");
        this.regAll("basalt", "basalt_side", "basalt_top");
        this.regAll("polished_basalt", "polished_basalt_side", "polished_basalt_top");
        this.regAll("terracotta");
        this.regAllTerra(new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"});
        this.regAll("dripstone_block");
        this.regAll("amethyst_block");
    }

    private void regAll(String name) {
        this.regStairs(name);
        this.regSlab(name);
        this.regWall(name);
    }

    private void regAll(String name, String texture) {
        this.regStairs(name, texture);
        this.regSlab(name, texture);
        this.regWall(name, texture);
    }

    private void regAll(String name, String texture, String top) {
        this.regStairs(name, texture, top);
        this.regSlab(name, texture, top);
        this.regWall(name, texture);
    }

    private void regAllWithTop(String name, String top) {
        this.regStairs(name, name, top);
        this.regSlab(name, name, top);
        this.regWall(name);
    }

    private void regStairs(String name) {
        this.regStairs(name, name, name);
    }

    private void regStairs(String name, String texture) {
        this.regStairs(name, texture, texture);
    }

    private void regStairs(String name, String texture, String topTexture) {
        ResourceLocation resource = this.mcLoc("block/" + texture);
        ResourceLocation topResource = this.mcLoc("block/" + topTexture);
        this.stairs(name + "_stairs", resource, topResource, topResource);
    }

    private void regSlab(String name) {
        this.regSlab(name, name, name);
    }

    private void regSlab(String name, String texture) {
        this.regSlab(name, texture, texture);
    }

    private void regSlab(String name, String texture, String topTexture) {
        ResourceLocation resource = this.mcLoc("block/" + texture);
        ResourceLocation topResource = this.mcLoc("block/" + topTexture);
        this.slab(name + "_slab", resource, topResource, topResource);
    }

    private void regWall(String name) {
        this.regWall(name, name);
    }

    private void regWall(String name, String texture) {
        this.wallInventory(name + "_wall", this.mcLoc("block/" + texture));
    }

    private void regAllTerra(String[] colors) {
        for (String color : colors) {
            this.regAll(color + "_terracotta");
        }
    }
}

